/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class BrowseContainerAction
extends TreeViewerAction {
    private static final String NAME_NO_THUMBNAILS = "Browse w/o thumbnails";
    private static final String NAME = "Browse";
    private static final String DESCRIPTION_DEFAULT = "Browse.";
    private static final String DESCRIPTION_PROJECT = "Browse the selected Project.";
    private static final String DESCRIPTION_TAG = "Browse the selected Tag.";
    private static final String DESCRIPTION_TIME = "Browse the selected period.";
    private static final String DESCRIPTION_PLATE = "Browse the selected Plate.";
    private static final String DESCRIPTION_DATASET = "Browse the selected Dataset.";
    private static final String DESCRIPTION_FOLDER = "Browse the selected Folder.";
    private static final String DESCRIPTION_MULTIIMAGE = "Browse the selected Image.";
    private static IconManager icons = IconManager.getInstance();
    private final boolean withThumbnails;

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null || this.model.getSelectedBrowser() == null) {
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.name = NAME;
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        Browser browser = this.model.getSelectedBrowser();
        if (selectedDisplay instanceof TreeImageTimeSet) {
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TIME));
            if (!this.withThumbnails) {
                this.name = NAME_NO_THUMBNAILS;
                this.setEnabled(false);
                return;
            }
            this.name = NAME;
            TreeImageDisplay[] array = browser.getSelectedDisplays();
            if (array != null && array.length > 1) {
                this.setEnabled(false);
            } else {
                TreeImageTimeSet timeNode = (TreeImageTimeSet)selectedDisplay;
                long number = timeNode.getNumberItems();
                this.setEnabled(number > 0L);
            }
            return;
        }
        if (ho == null || ho instanceof ExperimenterData || ho instanceof ImageData || ho instanceof FileAnnotationData) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            this.setEnabled(false);
        } else if (ho instanceof File) {
            File f = (File)ho;
            if (f.isDirectory()) {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_FOLDER));
                this.setEnabled(true);
            }
        } else if (ho instanceof PlateAcquisitionData) {
            this.setEnabled(true);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PLATE));
        } else if (!(ho instanceof DataObject)) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            this.setEnabled(false);
        } else {
            if (browser != null && browser.getSelectedDisplays().length > 1) {
                this.setEnabled(true);
                this.name = this.withThumbnails ? NAME : NAME_NO_THUMBNAILS;
                this.putValue("SmallIcon", icons.getIcon(60));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
                return;
            }
            this.name = this.withThumbnails ? NAME : NAME_NO_THUMBNAILS;
            this.putValue("SmallIcon", icons.getIcon(60));
            String description = DESCRIPTION_DEFAULT;
            if (selectedDisplay instanceof TreeImageSet) {
                TreeImageSet tim = (TreeImageSet)selectedDisplay;
                long n = tim.getNumberItems();
                if (ho instanceof ScreenData) {
                    this.setEnabled(false);
                } else if (ho instanceof PlateData) {
                    List l = selectedDisplay.getChildrenDisplay();
                    description = DESCRIPTION_PLATE;
                    this.setEnabled(l == null || l.size() <= 1);
                } else if (ho instanceof PlateAcquisitionData) {
                    description = DESCRIPTION_PLATE;
                    this.setEnabled(true);
                } else if (ho instanceof ProjectData) {
                    description = DESCRIPTION_PROJECT;
                    if (n > 0L) {
                        List children = tim.getChildrenDisplay();
                        Iterator i = children.iterator();
                        boolean enabled = false;
                        while (i.hasNext()) {
                            TreeImageDisplay node = (TreeImageDisplay)i.next();
                            if (node.getNumberOfItems() <= 0L) continue;
                            enabled = true;
                            break;
                        }
                        this.setEnabled(enabled);
                    } else {
                        this.setEnabled(false);
                    }
                    if (!this.withThumbnails) {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof DatasetData) {
                    description = DESCRIPTION_DATASET;
                    this.setEnabled(n > 0L);
                    if (!this.withThumbnails) {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof TagAnnotationData) {
                    String ns = ((TagAnnotationData)ho).getNameSpace();
                    if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                        this.setEnabled(false);
                    } else {
                        description = DESCRIPTION_TAG;
                        this.setEnabled(n > 0L);
                    }
                    if (!this.withThumbnails) {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof FileData) {
                    FileData f = (FileData)ho;
                    if (f.isDirectory()) {
                        this.setEnabled(true);
                        description = DESCRIPTION_FOLDER;
                    } else {
                        this.setEnabled(false);
                    }
                }
            }
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(description));
        }
    }

    public BrowseContainerAction(TreeViewer model) {
        this(model, true);
    }

    public BrowseContainerAction(TreeViewer model, boolean withThumbnails) {
        super(model);
        this.withThumbnails = withThumbnails;
        this.name = withThumbnails ? NAME : NAME_NO_THUMBNAILS;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
        this.putValue("SmallIcon", icons.getIcon(60));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewCmd cmd = new ViewCmd(this.model, this.withThumbnails);
        cmd.execute();
    }
}

