/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManagerAction
extends TreeViewerAction
implements MouseListener {
    private static final String DESCRIPTION = "Manage the data. Press (Shift) to keep the menu on screen when making the selection.";
    private Point point;

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        this.setEnabled(!(ho instanceof String) && !(ho instanceof ExperimenterData) && !(ho instanceof GroupData));
    }

    public ManagerAction(TreeViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(44));
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu(0, (Component)source, this.point);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

