/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PersonalManagementAction
extends TreeViewerAction
implements MouseListener {
    private static final String DESCRIPTION = "Select your current group.";
    private Point point;
    private IconManager icons = IconManager.getInstance();

    @Override
    protected void onDataImport() {
        this.onBrowserStateChange(this.model.getSelectedBrowser());
    }

    private void setPermissions() {
        GroupData group = this.model.getSelectedGroup();
        String name = "";
        String desc = DESCRIPTION;
        Icon icon = this.icons.getIcon(125);
        if (group != null) {
            name = group.getName();
            switch (group.getPermissions().getPermissionsLevel()) {
                case 0: {
                    desc = "Private Group";
                    icon = this.icons.getIcon(134);
                    break;
                }
                case 1: {
                    desc = "Collaborators can only read your data.";
                    icon = this.icons.getIcon(135);
                    break;
                }
                case 2: {
                    desc = "Collaborators can read and annotate your data.";
                    icon = this.icons.getIcon(136);
                    break;
                }
                case 3: {
                    desc = "Collaborators can read, annotate, delete, etc., your data.";
                    icon = this.icons.getIcon(165);
                    break;
                }
                case 4: {
                    desc = "Public";
                    icon = this.icons.getIcon(137);
                    break;
                }
                case 5: {
                    desc = "Public";
                    icon = this.icons.getIcon(137);
                }
            }
        }
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (browser == null) {
            return;
        }
        if (browser.getBrowserType() == 6) {
            this.setEnabled(false);
        } else if (browser.getState() == 15) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            if (un.hasRunningActivities()) {
                this.setEnabled(false);
            } else if (!this.model.isImporting()) {
                this.setEnabled(TreeViewerAgent.getAvailableUserGroups().size() > 1);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    protected void onBrowserSelection(Browser browser) {
        this.onBrowserStateChange(browser);
    }

    public PersonalManagementAction(TreeViewer model) {
        super(model);
        this.setPermissions();
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("groupChanged".equals(name)) {
                    PersonalManagementAction.this.setPermissions();
                }
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu(5, (Component)source, this.point);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

