/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.util.SaveResultsDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.event.SaveEvent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SaveResultsAction
extends TreeViewerAction {
    private static final String NAME = "Save ImageJ Results";
    private static final String DESCRIPTION = "Save Results back to OMERO.";
    private int plugin;
    private int saveIndex;

    public SaveResultsAction(TreeViewer model, int plugin) {
        super(model);
        this.setEnabled(TreeViewerAgent.canCreate());
        this.plugin = plugin;
        this.saveIndex = -1;
        if (plugin == 1) {
            this.putValue("Name", NAME);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.saveIndex = SaveEvent.ALL;
        }
    }

    public void setSaveIndex(int index) {
        this.saveIndex = index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.plugin == 1) {
            SaveResultsDialog d = new SaveResultsDialog(this.model.getUI(), this.saveIndex);
            UIUtilities.centerAndShow(d);
        }
    }
}

