/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.treeviewer.AdminLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ContainerCounterLoader;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterImageLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterImagesCounter;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.ScreenPlateLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.ContainersManager;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;

class BrowserModel {
    private int browserType;
    private List<TreeImageDisplay> selectedNodes;
    private int state = 10;
    private Point clickPoint;
    private DataBrowserLoader currentLoader;
    private DataBrowserLoader numberLoader;
    private List foundNodes;
    private int foundNodeIndex;
    private ContainersManager containersManager;
    private ContainersManager containersManagerWithIndexes;
    private boolean selected;
    private boolean displayed;
    private Map<String, Object> importedImages;
    private Map<Long, FSFileSystemView> views;
    private TreeViewer parent;
    protected Browser component;

    private void checkBrowserType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Browser type not valid.");
            }
        }
    }

    protected BrowserModel(int browserType, TreeViewer parent) {
        this.parent = parent;
        this.checkBrowserType(browserType);
        this.browserType = browserType;
        this.clickPoint = null;
        this.foundNodeIndex = -1;
        this.selectedNodes = new ArrayList<TreeImageDisplay>();
        this.displayed = true;
    }

    void initialize(Browser component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    TreeImageDisplay getLastSelectedDisplay() {
        int n = this.selectedNodes.size();
        if (n == 0) {
            return null;
        }
        return this.selectedNodes.get(n - 1);
    }

    TreeImageDisplay[] getSelectedDisplays() {
        if (this.selectedNodes.size() == 0) {
            return new TreeImageDisplay[0];
        }
        TreeImageDisplay[] nodes = new TreeImageDisplay[this.selectedNodes.size()];
        Iterator<TreeImageDisplay> i = this.selectedNodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            nodes[index] = i.next();
            ++index;
        }
        return nodes;
    }

    void setSelectedDisplay(TreeImageDisplay display, boolean single) {
        if (single) {
            this.selectedNodes.clear();
            if (display != null) {
                this.selectedNodes.add(display);
            }
        } else if (!this.selectedNodes.contains(display) && display != null) {
            this.selectedNodes.add(display);
        }
    }

    void addFoundNode(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            return;
        }
        TreeImageDisplay display = this.getLastSelectedDisplay();
        if (display != null && !display.getUserObject().getClass().equals(selectedDisplay.getUserObject().getClass())) {
            this.selectedNodes.clear();
        }
        if (!this.selectedNodes.contains(selectedDisplay)) {
            this.selectedNodes.add(selectedDisplay);
        }
    }

    Point getClickPoint() {
        return this.clickPoint;
    }

    void setClickPoint(Point p) {
        this.clickPoint = p;
    }

    int getBrowserType() {
        return this.browserType;
    }

    void fireLeavesLoading(TreeImageDisplay expNode, TreeImageDisplay node) {
        this.state = 12;
        SecurityContext ctx = this.getSecurityContext(expNode);
        if (node instanceof TreeImageTimeSet || node instanceof TreeFileSet) {
            this.currentLoader = new ExperimenterImageLoader(this.component, ctx, (TreeImageSet)expNode, (TreeImageSet)node);
            this.currentLoader.load();
        } else {
            Object ho = node.getUserObject();
            if (ho instanceof DatasetData) {
                this.currentLoader = new ExperimenterDataLoader(this.component, ctx, 1, (TreeImageSet)expNode, (TreeImageSet)node);
                this.currentLoader.load();
            } else if (ho instanceof TagAnnotationData) {
                this.currentLoader = new ExperimenterDataLoader(this.component, ctx, 3, (TreeImageSet)expNode, (TreeImageSet)node);
                this.currentLoader.load();
            } else if (ho instanceof GroupData) {
                if (TreeViewerAgent.isAdministrator()) {
                    ctx = TreeViewerAgent.getAdminContext();
                }
                this.currentLoader = new AdminLoader(this.component, ctx, (TreeImageSet)expNode);
                this.currentLoader.load();
            }
        }
    }

    void fireContainerCountLoading(Set containers, Set<TreeImageSet> nodes, TreeImageDisplay refNode) {
        if (containers == null || containers.size() == 0) {
            this.state = 15;
            return;
        }
        SecurityContext ctx = this.getSecurityContext(refNode);
        if (TreeViewerAgent.isAdministrator() && this.getBrowserType() == 6) {
            ctx = TreeViewerAgent.getAdminContext();
        }
        ContainerCounterLoader loader = new ContainerCounterLoader(this.component, ctx, containers, nodes);
        loader.load();
    }

    void discard() {
        this.cancel();
        if (this.numberLoader != null) {
            this.numberLoader.cancel();
            this.numberLoader = null;
        }
        this.state = 16;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 15;
    }

    boolean setContainerCountValue(JTree tree, long containerID, long value, Set<TreeImageSet> nodes) {
        if (this.containersManager == null) {
            this.containersManager = new ContainersManager(tree, nodes);
        }
        this.containersManager.setNumberItems(containerID, value);
        if (this.containersManager.isDone()) {
            this.containersManager = null;
            this.numberLoader = null;
            return true;
        }
        return false;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setFoundNodes(List nodes) {
        this.foundNodes = nodes;
    }

    void setFoundNodeIndex(int i) {
        this.foundNodeIndex = i;
    }

    int getFoundNodeIndex() {
        return this.foundNodeIndex;
    }

    List getFoundNodes() {
        return this.foundNodes;
    }

    long getUserID() {
        return this.getUserDetails().getId();
    }

    ExperimenterData getUserDetails() {
        return this.parent.getUserDetails();
    }

    TreeViewer getParentModel() {
        return this.parent;
    }

    boolean isDisplayed() {
        return this.displayed;
    }

    void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    String getExperimenterNames() {
        return this.parent.getExperimenterNames();
    }

    void fireExperimenterDataLoading(TreeImageSet expNode) {
        int index = -1;
        if (this.browserType == 6) {
            this.state = 11;
            if (TreeViewerAgent.isAdministrator()) {
                this.currentLoader = new AdminLoader(this.component, TreeViewerAgent.getAdminContext(), null);
                this.currentLoader.load();
            } else {
                this.component.setGroups(TreeViewerAgent.getGroupsLeaderOf(), null);
            }
            return;
        }
        SecurityContext ctx = this.getSecurityContext(expNode);
        if (this.browserType == 1) {
            this.currentLoader = new ScreenPlateLoader(this.component, ctx, expNode, 0);
            this.currentLoader.load();
            this.state = 11;
            return;
        }
        switch (this.browserType) {
            case 0: {
                index = 0;
                break;
            }
            case 5: {
                index = 2;
                break;
            }
            case 2: {
                index = 4;
                break;
            }
            case 4: {
                index = 7;
                break;
            }
        }
        if (index == -1) {
            return;
        }
        this.currentLoader = new ExperimenterDataLoader(this.component, ctx, index, expNode);
        this.currentLoader.load();
        this.state = 11;
    }

    void loadRefreshExperimenterData(Map<SecurityContext, RefreshExperimenterDef> nodes, Class<?> type, long id, Object refNode, DataObject toBrowse) {
        Class<ProjectData> klass = null;
        switch (this.browserType) {
            case 0: {
                klass = ProjectData.class;
                break;
            }
            case 5: {
                klass = ImageData.class;
                break;
            }
            case 2: {
                klass = TagAnnotationData.class;
                break;
            }
            case 1: {
                klass = ScreenData.class;
                break;
            }
            case 3: {
                klass = FileAnnotationData.class;
                break;
            }
            case 6: {
                klass = GroupData.class;
            }
        }
        this.state = 11;
        if (klass == null) {
            return;
        }
        this.currentLoader = new RefreshExperimenterDataLoader(this.component, this.getSecurityContext(null), klass, nodes, type, id, refNode, toBrowse);
        this.currentLoader.load();
    }

    void fireCountExperimenterImages(TreeImageSet expNode) {
        SecurityContext ctx = this.getSecurityContext(expNode);
        List n = expNode.getChildrenDisplay();
        Iterator i = n.iterator();
        HashSet<Integer> indexes = new HashSet<Integer>();
        switch (this.getBrowserType()) {
            case 5: {
                while (i.hasNext()) {
                    TreeImageSet no = (TreeImageSet)i.next();
                    if (!(no instanceof TreeImageTimeSet)) continue;
                    TreeImageTimeSet node = (TreeImageTimeSet)no;
                    indexes.add(node.getType());
                }
                break;
            }
            case 2: 
            case 3: {
                while (i.hasNext()) {
                    Object o = i.next();
                    if (!(o instanceof TreeFileSet)) continue;
                    TreeFileSet file = (TreeFileSet)o;
                    indexes.add(file.getType());
                }
                break;
            }
        }
        if (indexes.size() == 0) {
            return;
        }
        if (this.containersManagerWithIndexes == null) {
            this.containersManagerWithIndexes = new ContainersManager(indexes);
        }
        this.state = 13;
        this.numberLoader = new ExperimenterImagesCounter(this.component, ctx, expNode, n);
        this.numberLoader.load();
    }

    boolean setExperimenterCount(TreeImageSet expNode, int index) {
        if (this.containersManagerWithIndexes == null) {
            return true;
        }
        this.containersManagerWithIndexes.setItem(index);
        if (this.containersManagerWithIndexes.isDone()) {
            if (this.state == 13 && this.containersManager == null) {
                this.state = 15;
            }
            this.containersManagerWithIndexes = null;
            this.numberLoader = null;
            return true;
        }
        return false;
    }

    void removeDisplay(TreeImageDisplay foundNode) {
        if (foundNode != null) {
            this.selectedNodes.remove(foundNode);
        }
    }

    void browse(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        Object object = node.getUserObject();
        if (object instanceof ImageData) {
            this.parent.browse(node, null, true);
        } else if (object instanceof PlateData) {
            if (!node.hasChildrenDisplay() || node.getChildrenDisplay().size() == 1) {
                this.parent.browse(node, null, true);
            }
        } else if (object instanceof PlateAcquisitionData) {
            this.parent.browse(node, null, true);
        }
    }

    void setImportedImages(Collection nodes) {
        if (nodes == null) {
            return;
        }
        this.state = 15;
        Iterator i = nodes.iterator();
        this.importedImages = new HashMap<String, Object>();
        while (i.hasNext()) {
            ImageData img = (ImageData)i.next();
            this.importedImages.put(EditorUtil.getObjectName(img.getName()), img);
        }
    }

    void setRepositories(FSFileSystemView systemView) {
        if (this.views == null) {
            this.views = new HashMap<Long, FSFileSystemView>();
        }
        this.views.put(systemView.getUserID(), systemView);
        this.state = 15;
    }

    FSFileSystemView getRepositories(long userID) {
        return this.views.get(userID);
    }

    void addImportedImages(List nodes) {
        for (ImageData img : nodes) {
            this.importedImages.put(EditorUtil.getObjectName(img.getName()), img);
        }
    }

    void addImportedImage(ImageData image) {
        if (this.importedImages != null) {
            this.importedImages.put(EditorUtil.getObjectName(image.getName()), image);
        }
    }

    ImageData getImportedImage(String fileName) {
        if (this.importedImages == null) {
            return null;
        }
        String name = EditorUtil.getObjectName(fileName);
        Object ho = this.importedImages.get(name);
        if (ho instanceof ImageData) {
            return (ImageData)ho;
        }
        return null;
    }

    boolean isFileImported(String path) {
        if (this.importedImages == null) {
            return false;
        }
        String name = EditorUtil.getObjectName(path);
        return this.importedImages.get(name) != null;
    }

    void delete() {
        if (!TreeViewerAgent.canCreate()) {
            return;
        }
        TreeImageDisplay[] selected = this.getSelectedDisplays();
        int count = 0;
        boolean b = false;
        for (int i = 0; i < selected.length; ++i) {
            b = this.parent.canDelete(selected[i].getUserObject());
            if (!b) continue;
            ++count;
        }
        if (count == selected.length) {
            DeleteCmd c = new DeleteCmd(this.component);
            c.execute();
        }
    }

    DataObject[] getFilesData(long userID, FileData dir) {
        FSFileSystemView fs = this.getRepositories(userID);
        DataObject[] files = null;
        try {
            files = fs.getFiles(dir, false);
        }
        catch (FSAccessException e) {
            LogMessage msg = new LogMessage();
            msg.print("Cannot retrieve the files.");
            msg.print((Throwable)e);
            TreeViewerAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        return files;
    }

    boolean isMultiSelection() {
        TreeImageDisplay[] nodes = this.getSelectedDisplays();
        return nodes != null && nodes.length > 1;
    }

    void transfer(TreeImageDisplay target, List<TreeImageDisplay> nodes, int transferAction) {
        this.parent.transfer(target, nodes, transferAction);
    }

    SecurityContext getSecurityContext(TreeImageDisplay node) {
        if (node == null || this.isSingleGroup()) {
            return new SecurityContext(TreeViewerAgent.getUserDetails().getDefaultGroup().getId());
        }
        GroupData group = this.parent.getSingleGroupDisplayed();
        if (node == null && group != null) {
            return new SecurityContext(group.getId());
        }
        if (node.getUserObject() instanceof ExperimenterData) {
            TreeImageDisplay parent = node.getParentDisplay();
            Object p = parent.getUserObject();
            if (p instanceof GroupData) {
                group = (GroupData)p;
                return new SecurityContext(group.getId());
            }
            return new SecurityContext(this.getUserDetails().getDefaultGroup().getId());
        }
        if (node.getUserObject() instanceof GroupData) {
            group = (GroupData)node.getUserObject();
            return new SecurityContext(group.getId());
        }
        TreeImageDisplay n = null;
        switch (this.getDisplayMode()) {
            case 0: {
                n = EditorUtil.getDataGroup(node);
                if (n == null) break;
                return new SecurityContext(n.getUserObjectId());
            }
            default: {
                n = BrowserFactory.getDataOwner(node);
            }
        }
        if (n == null || this.isSingleGroup()) {
            return new SecurityContext(this.getUserDetails().getDefaultGroup().getId());
        }
        TreeImageDisplay parent = n.getParentDisplay();
        if (parent == null) {
            return new SecurityContext(this.getUserDetails().getDefaultGroup().getId());
        }
        Object p = parent.getUserObject();
        if (p instanceof GroupData) {
            group = (GroupData)p;
            return new SecurityContext(group.getId());
        }
        return new SecurityContext(this.getUserDetails().getDefaultGroup().getId());
    }

    GroupData getSelectedGroup() {
        return this.parent.getSelectedGroup();
    }

    boolean isSingleGroup() {
        return this.getGroups().size() <= 1;
    }

    int getDisplayMode() {
        return this.parent.getDisplayMode();
    }

    Collection getGroups() {
        return TreeViewerAgent.getAvailableUserGroups();
    }
}

