/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.PlateData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;

public class ContainersManager {
    private int totalIDs;
    private Set processedIDs;
    private Map providers;
    private JTree tree;

    public ContainersManager(Set indexes) {
        if (indexes == null) {
            throw new IllegalArgumentException("No container nodes.");
        }
        Iterator i = indexes.iterator();
        this.providers = new HashMap();
        this.processedIDs = new HashSet();
        while (i.hasNext()) {
            Integer index = (Integer)i.next();
            this.providers.put(index, index);
        }
        this.totalIDs = indexes.size();
    }

    public ContainersManager(JTree tree, Set containerNodes) {
        if (containerNodes == null) {
            throw new IllegalArgumentException("No container nodes.");
        }
        if (tree == null) {
            throw new IllegalArgumentException("No tree.");
        }
        this.tree = tree;
        this.totalIDs = 0;
        this.processedIDs = new HashSet();
        this.providers = new HashMap();
        Iterator i = containerNodes.iterator();
        Long id = null;
        while (i.hasNext()) {
            TreeImageSet node = (TreeImageSet)i.next();
            Object userObject = node.getUserObject();
            if (userObject instanceof DatasetData || userObject instanceof PlateData || userObject instanceof TagAnnotationData || userObject instanceof GroupData) {
                id = ((DataObject)userObject).getId();
            }
            if (id == null) continue;
            HashSet<TreeImageSet> p = (HashSet<TreeImageSet>)this.providers.get(id);
            if (p == null) {
                ++this.totalIDs;
                p = new HashSet<TreeImageSet>();
                this.providers.put(id, p);
            }
            p.add(node);
        }
    }

    public void setNumberItems(long containerID, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Value not valid.");
        }
        Long id = containerID;
        Set p = (Set)this.providers.get(id);
        if (p != null) {
            Iterator i = p.iterator();
            DefaultTreeModel dtm = null;
            if (this.tree != null) {
                dtm = (DefaultTreeModel)this.tree.getModel();
            }
            while (i.hasNext()) {
                TreeImageSet node = (TreeImageSet)i.next();
                node.setNumberItems(value);
                if (dtm == null || node.isExpanded() || node.isChildrenLoaded()) continue;
                dtm.reload(node);
            }
            this.processedIDs.add(id);
        }
    }

    public void setItem(int index) {
        Integer i = (Integer)this.providers.get(index);
        this.processedIDs.add(i);
    }

    public boolean isDone() {
        return this.processedIDs.size() == this.totalIDs;
    }
}

