/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;

public class PasteRndSettingsCmd
implements ActionCmd {
    public static final int PASTE = 0;
    public static final int RESET = 1;
    public static final int SET_MIN_MAX = 2;
    public static final int SET_OWNER = 3;
    private TreeViewer model;
    private int index;
    private Collection<DataObject> selection;

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    public PasteRndSettingsCmd(TreeViewer model, int index) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.checkIndex(index);
        this.index = index;
        this.model = model;
    }

    public PasteRndSettingsCmd(TreeViewer model, int index, Collection<DataObject> selection) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.checkIndex(index);
        this.index = index;
        this.model = model;
        this.selection = selection;
    }

    @Override
    public void execute() {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (this.selection != null) {
            Iterator<DataObject> o = this.selection.iterator();
            Class klass = null;
            while (o.hasNext()) {
                DataObject ho = o.next();
                if (ho instanceof WellSampleData) {
                    klass = ImageData.class;
                    ids.add(((WellSampleData)ho).getImage().getId());
                    continue;
                }
                klass = ho.getClass();
                ids.add(ho.getId());
            }
            switch (this.index) {
                case 0: {
                    if (!this.model.hasRndSettings()) break;
                    this.model.pasteRndSettings(ids, klass);
                    break;
                }
                case 1: {
                    this.model.resetRndSettings(ids, klass);
                    break;
                }
                case 2: {
                    this.model.setMinMax(ids, klass);
                    break;
                }
                case 3: {
                    this.model.setOwnerRndSettings(ids, klass);
                }
            }
            return;
        }
        Browser b = this.model.getSelectedBrowser();
        if (b == null) {
            return;
        }
        TreeImageDisplay[] nodes = b.getSelectedDisplays();
        if (nodes.length == 0) {
            return;
        }
        Class klass = null;
        TimeRefObject ref = null;
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay node = nodes[i];
            if (node instanceof TreeImageTimeSet) {
                if (node.containsImages()) {
                    klass = ImageData.class;
                    Iterator j = ViewCmd.getImageNodeIDs(node, b).iterator();
                    while (j.hasNext()) {
                        ids.add((Long)j.next());
                    }
                    continue;
                }
                TreeImageTimeSet time = (TreeImageTimeSet)node;
                ExperimenterData exp = this.model.getUserDetails();
                ref = new TimeRefObject(exp.getId(), 0);
                ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                continue;
            }
            Object ho = node.getUserObject();
            klass = ho.getClass();
            if (!(ho instanceof DataObject)) continue;
            if (ho instanceof WellSampleData) {
                klass = ImageData.class;
                ids.add(((WellSampleData)ho).getImage().getId());
                continue;
            }
            ids.add(((DataObject)ho).getId());
        }
        switch (this.index) {
            case 0: {
                if (!this.model.hasRndSettings()) break;
                if (ref != null) {
                    this.model.pasteRndSettings(ref);
                    break;
                }
                this.model.pasteRndSettings(ids, klass);
                break;
            }
            case 1: {
                if (ref != null) {
                    this.model.resetRndSettings(ref);
                    break;
                }
                this.model.resetRndSettings(ids, klass);
                break;
            }
            case 2: {
                if (ref != null) {
                    this.model.setOriginalRndSettings(ref);
                    break;
                }
                this.model.setMinMax(ids, klass);
                break;
            }
            case 3: {
                if (ref != null) {
                    this.model.setOwnerRndSettings(ref);
                    break;
                }
                this.model.setOwnerRndSettings(ids, klass);
            }
        }
    }
}

