/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.BrowserVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;

public class RefreshVisitor
extends BrowserVisitor {
    private List<Object> foundNodes = new ArrayList<Object>();
    private Map<Class<?>, List<Long>> expandedTopNodes = new HashMap();

    public RefreshVisitor(Browser model) {
        super(model);
    }

    public List<Object> getFoundNodes() {
        return this.foundNodes;
    }

    public Map<Class<?>, List<Long>> getExpandedTopNodes() {
        return this.expandedTopNodes;
    }

    @Override
    public void visit(TreeImageSet node) {
        Object userObject = node.getUserObject();
        node.setToRefresh(false);
        if (userObject instanceof DatasetData && node.isChildrenLoaded() && node.isExpanded()) {
            TreeImageDisplay parent = node.getParentDisplay();
            if (parent.isExpanded()) {
                this.foundNodes.add(userObject);
            }
            if (!(parent.getUserObject() instanceof ProjectData)) {
                long id = ((DataObject)userObject).getId();
                List<Long> l = this.expandedTopNodes.get(DatasetData.class);
                if (l == null) {
                    l = new ArrayList<Long>();
                    this.expandedTopNodes.put(DatasetData.class, l);
                }
                l.add(id);
            }
        } else if (userObject instanceof TagAnnotationData && node.isChildrenLoaded() && node.isExpanded()) {
            TreeImageDisplay parent = node.getParentDisplay();
            TagAnnotationData tag = (TagAnnotationData)userObject;
            String ns = tag.getNameSpace();
            if (parent.isExpanded() && !"openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                this.foundNodes.add(userObject);
            }
            if (!(parent.getUserObject() instanceof TagAnnotationData)) {
                long id = ((DataObject)userObject).getId();
                List<Long> l = this.expandedTopNodes.get(TagAnnotationData.class);
                if (l == null) {
                    l = new ArrayList<Long>();
                    this.expandedTopNodes.put(TagAnnotationData.class, l);
                }
                l.add(id);
            }
        } else if (userObject instanceof ProjectData && node.isExpanded()) {
            long id = ((DataObject)userObject).getId();
            List<Long> l = this.expandedTopNodes.get(ProjectData.class);
            if (l == null) {
                l = new ArrayList<Long>();
                this.expandedTopNodes.put(ProjectData.class, l);
            }
            l.add(id);
        } else if (userObject instanceof ScreenData && node.isExpanded()) {
            long id = ((DataObject)userObject).getId();
            List<Long> l = this.expandedTopNodes.get(ScreenData.class);
            if (l == null) {
                l = new ArrayList<Long>();
                this.expandedTopNodes.put(ScreenData.class, l);
            }
            l.add(id);
        } else if (userObject instanceof PlateData) {
            if (node.hasChildrenDisplay() && node.isExpanded()) {
                long id = ((DataObject)userObject).getId();
                List<Long> l = this.expandedTopNodes.get(PlateData.class);
                if (l == null) {
                    l = new ArrayList<Long>();
                    this.expandedTopNodes.put(PlateData.class, l);
                }
                l.add(id);
            }
        } else if (userObject instanceof GroupData) {
            if (node.isExpanded()) {
                long id = ((DataObject)userObject).getId();
                List<Long> l = this.expandedTopNodes.get(GroupData.class);
                if (l == null) {
                    l = new ArrayList<Long>();
                    this.expandedTopNodes.put(GroupData.class, l);
                }
                l.add(id);
            }
        } else if (node instanceof TreeImageTimeSet && node.isChildrenLoaded() && node.isExpanded() && node.containsImages()) {
            this.foundNodes.add(node);
        } else if (node instanceof TreeFileSet && node.isChildrenLoaded() && node.isExpanded()) {
            this.foundNodes.add(node);
        }
    }
}

