/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.LeavesVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class ViewCmd
implements ActionCmd {
    private TreeViewer model;
    private boolean withThumbnails;

    static Set getImageNodeIDs(TreeImageDisplay node, Browser browser) {
        LeavesVisitor visitor = new LeavesVisitor(browser);
        node.accept(visitor);
        return visitor.getNodeIDs();
    }

    static Set getImageNodes(TreeImageDisplay node, Browser browser) {
        LeavesVisitor visitor = new LeavesVisitor(browser);
        node.accept(visitor);
        return visitor.getNodes();
    }

    public ViewCmd(TreeViewer model, boolean withThumbnails) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.withThumbnails = withThumbnails;
    }

    @Override
    public void execute() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d != null && d.getUserObject() instanceof ImageData) {
            Object uo = d.getUserObject();
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            ViewImageObject vo = new ViewImageObject((DataObject)((ImageData)uo));
            RndProxyDef def = this.model.getSelectedViewedBy();
            if (def != null) {
                vo.setSelectedRndDef(def.getDataID());
            }
            TreeImageDisplay p = d.getParentDisplay();
            TreeImageDisplay gp = null;
            DataObject po = null;
            DataObject gpo = null;
            if (p != null) {
                uo = p.getUserObject();
                gp = p.getParentDisplay();
                if (uo instanceof DataObject) {
                    po = (DataObject)uo;
                }
                if (gp != null && (uo = gp.getUserObject()) instanceof DataObject) {
                    gpo = (DataObject)uo;
                }
            }
            vo.setContext(po, gpo);
            SecurityContext ctx = browser.getSecurityContext(d);
            ViewImage evt = new ViewImage(ctx, vo, this.model.getUI().getBounds());
            evt.setSeparateWindow(true);
            bus.post(evt);
        } else {
            browser.browse(d, null, this.withThumbnails);
        }
    }
}

