/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.treeviewer.SaveResultsEvent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.event.SaveEvent;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SaveResultsDialog
extends JDialog {
    private JCheckBox roi;
    private JCheckBox table;
    private boolean activeWindow;
    private JButton cancelButton;
    private JButton saveButton;
    private JTextField nameField;

    private void initialize(int index) {
        this.activeWindow = true;
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveResultsDialog.this.cancel();
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveResultsDialog.this.save();
            }
        });
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SaveResultsDialog.this.saveButton.setEnabled(SaveResultsDialog.this.roi.isSelected() || SaveResultsDialog.this.table.isSelected());
            }
        };
        this.roi = new JCheckBox("ROI");
        this.roi.addChangeListener(l);
        this.table = new JCheckBox("Measurements");
        this.table.addChangeListener(l);
        this.nameField = new JTextField(15);
        if (index == SaveEvent.ALL) {
            this.roi.setSelected(true);
            this.table.setSelected(true);
        } else if (index == SaveEvent.ROIS) {
            this.roi.setSelected(true);
        } else if (index == SaveEvent.RESULTS) {
            this.table.setSelected(true);
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        ResultsObject result;
        FileObject ff;
        int[] values;
        ArrayList<Object> images = new ArrayList<Object>();
        ArrayList<Object> toImport = new ArrayList<Object>();
        if (this.activeWindow) {
            ImagePlus plus = WindowManager.getCurrentImage();
            if (plus != null) {
                FileObject img = new FileObject(plus);
                if (img.getOMEROID() < 0L || img.isNewImage()) {
                    toImport.add(img);
                    values = WindowManager.getIDList();
                    String path = img.getAbsolutePath();
                    if (path != null) {
                        for (int i = 0; i < values.length; ++i) {
                            plus = WindowManager.getImage((int)values[i]);
                            ff = new FileObject(plus);
                            if (!path.equals(ff.getAbsolutePath())) continue;
                            img.addAssociatedFile(ff);
                        }
                    }
                } else {
                    images.add(img);
                }
            }
        } else {
            values = WindowManager.getIDList();
            if (values != null) {
                ArrayList<String> paths = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    ImagePlus plus = WindowManager.getImage((int)values[i]);
                    FileObject img = new FileObject(plus);
                    if (img.getOMEROID() < 0L || img.isNewImage()) {
                        String path = img.getAbsolutePath();
                        if (paths.contains(path)) continue;
                        paths.add(path);
                        List<FileObject> l = img.getAssociatedFiles();
                        if (CollectionUtils.isEmpty(l)) {
                            toImport.add(img);
                        }
                        int id = plus.getID();
                        for (int j = 0; j < values.length; ++j) {
                            plus = WindowManager.getImage((int)values[j]);
                            if (plus.getID() == id || !path.equals((ff = new FileObject(plus)).getAbsolutePath())) continue;
                            img.addAssociatedFile(ff);
                        }
                        continue;
                    }
                    images.add(img);
                }
            }
        }
        if (toImport.size() > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("Do you wish to import any selected images not already " + CommonsLangUtils.LINE_SEPARATOR + "saved in OMERO to the OMERO server?");
            MessageBox box = new MessageBox(this, "Import images", buf.toString());
            if (box.centerMsgBox() == 1) {
                result = new ResultsObject(toImport);
                result.setROI(this.roi.isSelected());
                result.setTable(this.table.isSelected());
                result.setTableName(this.nameField.getText());
                TreeViewerAgent.getRegistry().getEventBus().post(new SaveResultsEvent(result, true));
            }
        }
        if (images.size() > 0) {
            result = new ResultsObject(images);
            result.setROI(this.roi.isSelected());
            result.setTable(this.table.isSelected());
            result.setTableName(this.nameField.getText());
            ExperimenterData exp = TreeViewerAgent.getUserDetails();
            SecurityContext ctx = new SecurityContext(exp.getGroupId());
            ctx.setExperimenter(exp);
            TreeViewerAgent.getRegistry().getUserNotifier().notifyActivity(ctx, result);
        }
        this.cancel();
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.saveButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private JPanel buildContents() {
        JPanel buttons = new JPanel();
        buttons.add(UIUtilities.setTextFont("Save results for"));
        buttons.setLayout(new BoxLayout(buttons, 1));
        ButtonGroup group = new ButtonGroup();
        JRadioButton b = new JRadioButton("Image from current window");
        b.setSelected(this.activeWindow);
        buttons.add(b);
        group.add(b);
        b.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SaveResultsDialog.this.activeWindow = e.getStateChange() == 1;
            }
        });
        b = new JRadioButton("Images from all image windows");
        b.setSelected(this.activeWindow);
        buttons.add(b);
        group.add(b);
        buttons.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        buttons.add(UIUtilities.setTextFont("Save"));
        buttons.add(this.roi);
        buttons.add(this.table);
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0));
        JLabel l = new JLabel();
        l.setText("Measurements File Name: ");
        row.add(l);
        row.add(this.nameField);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(UIUtilities.buildComponentPanel(buttons));
        p.add(row);
        return p;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        c.add((Component)this.buildContents(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public SaveResultsDialog(JFrame parent, int index) {
        super(parent);
        this.setTitle("Save ImageJ results");
        this.initialize(index);
        this.buildGUI();
        this.pack();
    }
}

