/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateTopContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.MoveToAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewOtherAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;

class PopupMenu
extends JPopupMenu {
    private JMenuItem browse;
    private JMenuItem existingElement;
    private JMenuItem importElement;
    private JMenuItem newElement;
    private JMenuItem cutElement;
    private JMenuItem copyElement;
    private JMenuItem pasteElement;
    private JMenuItem deleteElement;
    private JMenuItem downloadElement;
    private JMenuItem removeExperimenterElement;
    private JMenuItem refreshExperimenterElement;
    private JMenuItem addExperimenterElement;
    private JMenuItem refreshTreeElement;
    private JMenuItem createTopElement;
    private JMenuItem switchUserElement;
    private JMenuItem pasteRndElement;
    private JMenuItem copyRndElement;
    private JMenuItem resetRndElement;
    private JMenuItem setOwnerRndElement;
    private JMenuItem addExistingElement;
    private JMenuItem quitElement;
    private JMenuItem createProject;
    private JMenuItem createDataset;
    private JMenuItem createTag;
    private JMenuItem createScreen;
    private JMenuItem createTagSet;
    private JMenuItem createGroup;
    private JMenuItem createExperimenter;
    private JMenuItem resetPassword;
    private JMenuItem view;
    private JMenuItem tagElement;
    private JMenuItem viewInPlugin;
    private TreeViewerControl controller;
    private TreeViewerModel model;
    private Font fontLabel;
    private int index;
    private JMenu openWithMenu;
    private JCheckBoxMenuItem activatedUser;
    private JMenuItem removeGroupElement;

    private void initMenuItem(JMenuItem item, String name) {
        if (name != null) {
            item.setText(name);
        }
        item.setBorder(null);
        item.setFont(this.fontLabel);
    }

    private void createMenuItems() {
        this.openWithMenu = new JMenu();
        this.initMenuItem(this.openWithMenu, "Open with");
        IconManager icons = IconManager.getInstance();
        this.openWithMenu.setIcon(icons.getIcon(9));
        this.populateMenu();
        switch (this.index) {
            case 9: {
                switch (TreeViewerAgent.runAsPlugin()) {
                    case 1: 
                    case 3: {
                        TreeViewerAction a = this.controller.getAction(TreeViewerControl.VIEW);
                        this.view = new JMenuItem(a);
                        this.initMenuItem(this.view, a.getActionName());
                        a = this.controller.getAction(TreeViewerControl.VIEW_IN_IJ);
                        this.viewInPlugin = new JMenuItem(a);
                        this.initMenuItem(this.viewInPlugin, a.getActionName());
                        break;
                    }
                    case 2: {
                        TreeViewerAction a = this.controller.getAction(TreeViewerControl.VIEW);
                        this.view = new JMenuItem(a);
                        this.initMenuItem(this.view, a.getActionName());
                        a = this.controller.getAction(TreeViewerControl.VIEW_IN_KNIME);
                        this.viewInPlugin = new JMenuItem(a);
                        this.initMenuItem(this.viewInPlugin, a.getActionName());
                    }
                }
                break;
            }
            case 1: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.BROWSE);
                this.browse = new JMenuItem(a);
                this.initMenuItem(this.browse, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.VIEW);
                this.view = new JMenuItem(a);
                this.initMenuItem(this.view, a.getActionName());
                a = null;
                switch (TreeViewerAgent.runAsPlugin()) {
                    case 1: 
                    case 3: {
                        a = this.controller.getAction(TreeViewerControl.VIEW_IN_IJ);
                        break;
                    }
                    case 2: {
                        a = this.controller.getAction(TreeViewerControl.VIEW_IN_KNIME);
                    }
                }
                if (a != null) {
                    this.viewInPlugin = new JMenuItem(a);
                    this.initMenuItem(this.viewInPlugin, a.getActionName());
                }
                a = this.controller.getAction(TreeViewerControl.DOWNLOAD);
                this.downloadElement = new JMenuItem(a);
                this.initMenuItem(this.downloadElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.TAGGING);
                this.tagElement = new JMenuItem(a);
                this.initMenuItem(this.tagElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.IMPORT);
                this.importElement = new JMenuItem(a);
                this.initMenuItem(this.importElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_OBJECT);
                this.newElement = new JMenuItem(a);
                this.initMenuItem(this.newElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CUT_OBJECT);
                this.cutElement = new JMenuItem(a);
                this.initMenuItem(this.cutElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.COPY_OBJECT);
                this.copyElement = new JMenuItem(a);
                this.initMenuItem(this.copyElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.PASTE_OBJECT);
                this.pasteElement = new JMenuItem(a);
                this.initMenuItem(this.pasteElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.DELETE_OBJECT);
                this.deleteElement = new JMenuItem(a);
                this.initMenuItem(this.deleteElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.ADD_OBJECT);
                this.existingElement = new JMenuItem(a);
                this.initMenuItem(this.existingElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.REMOVE_FROM_DISPLAY);
                this.removeExperimenterElement = new JMenuItem(a);
                this.initMenuItem(this.removeExperimenterElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.REMOVE_GROUP);
                this.removeGroupElement = new JMenuItem(a);
                this.initMenuItem(this.removeGroupElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.SWITCH_USER);
                this.addExperimenterElement = new JMenuItem(a);
                this.addExperimenterElement.addMouseListener((SwitchUserAction)a);
                this.initMenuItem(this.addExperimenterElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.REFRESH_EXPERIMENTER);
                this.refreshExperimenterElement = new JMenuItem(a);
                this.initMenuItem(this.refreshExperimenterElement, null);
                a = this.controller.getAction(TreeViewerControl.PASTE_RND_SETTINGS);
                this.pasteRndElement = new JMenuItem(a);
                this.initMenuItem(this.pasteRndElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.COPY_RND_SETTINGS);
                this.copyRndElement = new JMenuItem(a);
                this.initMenuItem(this.copyRndElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.RESET_RND_SETTINGS);
                this.resetRndElement = new JMenuItem(a);
                this.initMenuItem(this.resetRndElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.SET_RND_SETTINGS);
                a = this.controller.getAction(TreeViewerControl.SET_OWNER_RND_SETTINGS);
                this.setOwnerRndElement = new JMenuItem(a);
                this.initMenuItem(this.setOwnerRndElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_PROJECT);
                this.createProject = new JMenuItem(a);
                this.initMenuItem(this.createProject, a.getActionName());
                if (this.controller.isOrphanedImagesSelected()) {
                    a = this.controller.getAction(TreeViewerControl.CREATE_DATASET_FROM_SELECTION);
                } else {
                    a = this.controller.getAction(TreeViewerControl.CREATE_TOP_DATASET);
                    ((CreateTopContainerAction)a).setFromTopMenu(true);
                }
                this.createDataset = new JMenuItem(a);
                this.initMenuItem(this.createDataset, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_SCREEN);
                this.createScreen = new JMenuItem(a);
                this.initMenuItem(this.createScreen, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG_SET);
                this.createTagSet = new JMenuItem(a);
                this.initMenuItem(this.createTagSet, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG);
                this.createTag = new JMenuItem(a);
                this.initMenuItem(this.createTag, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_GROUP);
                break;
            }
            case 2: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.REFRESH_TREE);
                this.refreshTreeElement = new JMenuItem(a);
                this.initMenuItem(this.refreshTreeElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_PROJECT);
                this.createTopElement = new JMenuItem(a);
                this.initMenuItem(this.createTopElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.SWITCH_USER);
                this.switchUserElement = new JMenuItem(a);
                this.initMenuItem(this.switchUserElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.EXIT);
                this.quitElement = new JMenuItem(a);
                this.initMenuItem(this.quitElement, a.getActionName());
                break;
            }
            case 3: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_PROJECT);
                this.createProject = new JMenuItem(a);
                this.initMenuItem(this.createProject, a.getActionName());
                if (this.controller.isOrphanedImagesSelected()) {
                    a = this.controller.getAction(TreeViewerControl.CREATE_DATASET_FROM_SELECTION);
                } else {
                    a = this.controller.getAction(TreeViewerControl.CREATE_TOP_DATASET);
                    ((CreateTopContainerAction)a).setFromTopMenu(true);
                }
                this.createDataset = new JMenuItem(a);
                this.initMenuItem(this.createDataset, a.getActionName());
                break;
            }
            case 8: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_SCREEN);
                this.createScreen = new JMenuItem(a);
                this.initMenuItem(this.createScreen, a.getActionName());
                break;
            }
            case 4: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG);
                ((CreateTopContainerAction)a).setFromTopMenu(true);
                this.createTag = new JMenuItem(a);
                this.initMenuItem(this.createTag, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG_SET);
                this.createTagSet = new JMenuItem(a);
                this.initMenuItem(this.createTagSet, a.getActionName());
                break;
            }
            case 6: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_GROUP);
                this.createGroup = new JMenuItem(a);
                this.initMenuItem(this.createGroup, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CREATE_TOP_EXPERIMENTER);
                this.createExperimenter = new JMenuItem(a);
                this.initMenuItem(this.createExperimenter, a.getActionName());
                break;
            }
            case 7: {
                TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_EXPERIMENTER);
                this.createExperimenter = new JMenuItem(a);
                this.initMenuItem(this.createExperimenter, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.ADD_OBJECT);
                this.addExistingElement = new JMenuItem(a);
                this.initMenuItem(this.addExistingElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.CUT_OBJECT);
                this.cutElement = new JMenuItem(a);
                this.initMenuItem(this.cutElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.COPY_OBJECT);
                this.copyElement = new JMenuItem(a);
                this.initMenuItem(this.copyElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.PASTE_OBJECT);
                this.pasteElement = new JMenuItem(a);
                this.initMenuItem(this.pasteElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.DELETE_OBJECT);
                this.deleteElement = new JMenuItem(a);
                this.initMenuItem(this.deleteElement, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.RESET_PASSWORD);
                this.resetPassword = new JMenuItem(a);
                this.initMenuItem(this.resetPassword, a.getActionName());
                a = this.controller.getAction(TreeViewerControl.USER_ACTIVATED);
                this.activatedUser = new JCheckBoxMenuItem();
                TreeImageDisplay node = this.controller.getLastSelectedDisplay();
                boolean value = false;
                if (node != null) {
                    Object o = node.getUserObject();
                    if (o instanceof ExperimenterData) {
                        ExperimenterData exp = (ExperimenterData)o;
                        ExperimenterData loggedIn = TreeViewerAgent.getUserDetails();
                        value = exp.getId() == loggedIn.getId();
                        this.activatedUser.setSelected(exp.isActive());
                        if (exp.isActive()) {
                            this.activatedUser.setIcon(icons.getIcon(23));
                        } else {
                            this.activatedUser.setIcon(icons.getIcon(124));
                        }
                        this.activatedUser.setEnabled(!value && !this.model.isSystemUser(exp.getId()));
                    }
                    if (!value) {
                        this.activatedUser.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                PopupMenu.this.controller.activateUser();
                            }
                        });
                    }
                } else {
                    this.activatedUser.setEnabled(false);
                }
                this.activatedUser.setAction(a);
                this.initMenuItem(this.activatedUser, a.getActionName());
            }
        }
    }

    private JMenu createMoveToMenu() {
        List<MoveToAction> actions = this.controller.getMoveAction();
        if (actions == null || actions.size() == 0) {
            return null;
        }
        JMenu menu = new JMenu("Move to Group");
        Iterator<MoveToAction> i = actions.iterator();
        while (i.hasNext()) {
            menu.add(new JMenuItem(i.next()));
        }
        return menu;
    }

    private JMenu buildCreateNewMenu() {
        JMenu menu = new JMenu();
        this.initMenuItem(menu, "Create New");
        int type = this.controller.getSelectedBrowserType();
        if (type == 2) {
            menu.add(this.createTagSet);
            menu.add(this.createTag);
        } else if (type == 1) {
            menu.add(this.createScreen);
        } else {
            menu.add(this.createProject);
            menu.add(this.createDataset);
        }
        return menu;
    }

    private JMenu buildEditMenu() {
        JMenu menu = new JMenu();
        this.initMenuItem(menu, "Edit");
        menu.add(this.cutElement);
        menu.add(this.copyElement);
        menu.add(this.pasteElement);
        return menu;
    }

    private JMenu buildRenderingSettingsMenu() {
        JMenu menu = new JMenu();
        this.initMenuItem(menu, "Rendering Settings");
        menu.add(this.copyRndElement);
        menu.add(this.pasteRndElement);
        menu.add(this.resetRndElement);
        menu.add(this.setOwnerRndElement);
        return menu;
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        switch (this.index) {
            case 1: {
                this.add(this.browse);
                if (this.viewInPlugin != null) {
                    JMenu menu = new JMenu();
                    this.initMenuItem(menu, "View");
                    menu.setIcon(this.view.getIcon());
                    menu.add(this.view);
                    menu.add(this.viewInPlugin);
                    this.add(menu);
                } else {
                    this.add(this.view);
                }
                this.add(this.openWithMenu);
                this.add(this.downloadElement);
                this.add(new JSeparator(0));
                this.add(this.importElement);
                this.add(this.buildCreateNewMenu());
                this.add(this.buildEditMenu());
                this.add(this.deleteElement);
                JMenu m = this.createMoveToMenu();
                if (m != null) {
                    this.add(m);
                }
                this.add(new JSeparator(0));
                this.add(this.tagElement);
                this.add(new JSeparator(0));
                this.add(this.buildRenderingSettingsMenu());
                this.add(this.removeGroupElement);
                this.add(this.refreshExperimenterElement);
                this.add(this.removeExperimenterElement);
                break;
            }
            case 2: {
                this.add(this.refreshTreeElement);
                this.add(this.createTopElement);
                this.add(this.switchUserElement);
                this.add(this.quitElement);
                break;
            }
            case 3: {
                this.add(this.createProject);
                this.add(this.createDataset);
                break;
            }
            case 8: {
                this.add(this.createScreen);
                break;
            }
            case 4: {
                this.add(this.createTagSet);
                this.add(this.createTag);
                break;
            }
            case 6: {
                this.add(this.createGroup);
                this.add(this.createExperimenter);
                break;
            }
            case 7: {
                this.add(this.createExperimenter);
                this.add(this.addExistingElement);
                this.add(new JSeparator(0));
                this.add(this.resetPassword);
                this.add(this.activatedUser);
                this.add(this.buildEditMenu());
                this.add(this.deleteElement);
                break;
            }
            case 9: {
                if (this.viewInPlugin == null) break;
                this.add(this.view);
                this.add(this.viewInPlugin);
            }
        }
    }

    private void populateMenu() {
        JMenuItem item;
        List<ViewOtherAction> l = this.controller.getApplicationActions();
        if (l.size() > 0) {
            for (TreeViewerAction treeViewerAction : l) {
                item = new JMenuItem(treeViewerAction);
                this.initMenuItem(item, treeViewerAction.getActionName());
                this.openWithMenu.add(item);
            }
            this.openWithMenu.add(new JSeparator());
        }
        TreeViewerAction treeViewerAction = this.controller.getAction(TreeViewerControl.VIEWER_WITH_OTHER);
        item = new JMenuItem(treeViewerAction);
        this.initMenuItem(item, treeViewerAction.getActionName());
        this.openWithMenu.add(item);
    }

    PopupMenu(TreeViewerControl controller, TreeViewerModel model, int index) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.index = index;
        this.controller = controller;
        this.model = model;
        this.fontLabel = (Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Labels");
        this.createMenuItems();
        this.buildGUI();
    }
}

