/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class StatusBar
extends JPanel {
    static final String CANCEL_PROPERTY = "cancel";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private static final Dimension PROGRESSBAR_SIZE = new Dimension(30, 8);
    private JProgressBar progressBar;
    private JLabel status;
    private JLabel progressLabel;
    private JButton statusButton;
    private boolean buttonEnabled;
    private TreeViewerControl controller;
    private IconManager icons;

    private void initComponents() {
        this.icons = IconManager.getInstance();
        this.progressLabel = new JLabel(this.icons.getIcon(32));
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.status = new JLabel();
        this.statusButton = new JButton(this.icons.getIcon(43));
        this.statusButton.setContentAreaFilled(false);
        this.statusButton.setBorder(null);
        UIUtilities.unifiedButtonLookAndFeel(this.statusButton);
        this.statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StatusBar.this.buttonEnabled) {
                    StatusBar.this.controller.cancel();
                }
            }
        });
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEtchedBorder());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.status);
        this.add(UIUtilities.buildComponentPanel(p));
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        progressPanel.add(this.progressBar);
        progressPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        progressPanel.add(this.progressLabel);
        progressPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.add(UIUtilities.buildComponentPanelRight(progressPanel));
        this.progressBar.setPreferredSize(PROGRESSBAR_SIZE);
        this.progressBar.setSize(PROGRESSBAR_SIZE);
    }

    StatusBar(TreeViewerControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.initComponents();
        this.buildUI();
    }

    void setStatus(String s) {
        this.status.setText(s);
    }

    void setStatusIcon(boolean b) {
        if (b) {
            this.statusButton.setIcon(this.icons.getIcon(43));
        } else {
            this.statusButton.setIcon(this.icons.getIcon(32));
        }
        this.buttonEnabled = b;
    }

    void setProgress(boolean hide) {
        this.progressBar.setVisible(!hide);
        this.progressLabel.setEnabled(!hide);
        if (hide) {
            this.progressLabel.setIcon(this.icons.getIcon(32));
        } else {
            this.progressLabel.setIcon(this.icons.getIcon(48));
        }
    }
}

