/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import com.google.common.math.DoubleMath;
import java.awt.Color;
import java.awt.Font;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ome.formats.model.UnitsFactory;
import ome.model.units.BigResult;
import ome.units.UNITS;
import ome.units.unit.Unit;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DetectorData;
import omero.gateway.model.DichroicData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FilterData;
import omero.gateway.model.FilterSetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.model.InstrumentData;
import omero.gateway.model.LightSourceData;
import omero.gateway.model.ObjectiveData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.model.ElectricPotential;
import omero.model.Frequency;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.PlaneInfo;
import omero.model.Power;
import omero.model.Pressure;
import omero.model.Temperature;
import omero.model.Time;
import omero.model.enums.UnitsLength;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.CppFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JavaFilter;
import org.openmicroscopy.shoola.util.filter.file.MatlabFilter;
import org.openmicroscopy.shoola.util.filter.file.PythonFilter;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMEComboBoxUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class EditorUtil {
    public static final NumberFormat NF = new DecimalFormat("0.##");
    public static final int MAX_CHAR = 256;
    public static final int LENGHT_CHAR = 50;
    public static final String LASER_TYPE = "Laser";
    public static final String ARC_TYPE = "Arc";
    public static final String FILAMENT_TYPE = "Filament";
    public static final String EMITTING_DIODE_TYPE = "Light Emitting Diode";
    public static final int DEFAULT_SCALE = 5;
    public static final String DATE_NOT_AVAILABLE = "Not available";
    public static final String DEFAULT_GROUP = "Default Group";
    public static final String MANDATORY_SYMBOL = " *";
    public static final String MANDATORY_DESCRIPTION = "* indicates the required fields.";
    public static final String GROUP_OWNER = "Group's owner";
    public static final String ADMINISTRATOR = "Administrator";
    public static final String ACTIVE = "Active";
    public static final String DISPLAY_NAME = "Login Name";
    public static final String LAST_NAME = "Last Name";
    public static final String FIRST_NAME = "First Name";
    public static final String MIDDLE_NAME = "Middle Name";
    public static final String INSTITUTION = "Institution";
    public static final String OWNER = "Owner: ";
    public static final String GROUP = "Group: ";
    public static final String WORLD = "Others: ";
    public static final String READ = "Read";
    public static final String WRITE = "Write";
    public static final String PUBLIC = "Public";
    public static final String GROUP_VISIBLE = "Collaborative";
    public static final String PRIVATE = "Private";
    public static final String GROUPS = "Belongs to the following groups: ";
    public static final String EMAIL = "E-mail";
    public static final String MICRONS_NO_BRACKET = LengthI.lookupSymbol((UnitsLength)UnitsLength.MICROMETER);
    public static final String MICRONS = "(" + MICRONS_NO_BRACKET + ")";
    public static final String CELSIUS = "(\u2103)";
    public static final String PERCENT = "(%)";
    public static final String MILLIBARS = "(mb)";
    public static final String SIZE_X = "Size X";
    public static final String SIZE_Y = "Size Y";
    public static final String PIXEL_SIZE_X = "Pixel size X ";
    public static final String PIXEL_SIZE_Y = "Pixel size Y ";
    public static final String PIXEL_SIZE_Z = "Pixel size Z ";
    public static final String SECTIONS = "Number of sections";
    public static final String TIMEPOINTS = "Number of timepoints";
    public static final String CHANNELS = "Channels";
    public static final String PIXEL_TYPE = "Pixel Type";
    public static final String NAME = "Name";
    public static final String ACQUISITION_DATE = "Acquisition Date";
    public static final String IMPORTED_DATE = "Import Date";
    public static final String ARCHIVED = "Archived";
    public static final String XY_DIMENSION = "Dimensions (XY)";
    public static final String Z_T_FIELDS = "Z-sections/Timepoints";
    public static final String SMALL_T_VARIABLE = "t";
    public static final String EMISSION = "Emission";
    public static final String EXCITATION = "Excitation";
    public static final String PIN_HOLE_SIZE = "Pinhole size";
    public static final String ND_FILTER = "NDFilter (%)";
    public static final String FLUOR = "Fluor";
    public static final String ILLUMINATION = "Illumination";
    public static final String CONTRAST_METHOD = "Contrast Method";
    public static final String MODE = "Mode";
    public static final String POCKEL_CELL_SETTINGS = "Pockel Cell";
    public static final String NOMINAL_MAGNIFICATION = "Nominal Magnification";
    public static final String CALIBRATED_MAGNIFICATION = "Calibrated Magnification";
    public static final String LENSNA = "Lens NA";
    public static final String WORKING_DISTANCE = "Working Distance";
    public static final String IMMERSION = "Immersion";
    public static final String CORRECTION = "Correction";
    public static final String CORRECTION_COLLAR = "Correction Collar";
    public static final String MEDIUM = "Medium";
    public static final String REFRACTIVE_INDEX = "Refractive index";
    public static final String TEMPERATURE = "Temperature";
    public static final String AIR_PRESSURE = "Air Pressure";
    public static final String HUMIDITY = "Humidity";
    public static final String CO2_PERCENT = "CO2 Percent";
    public static final String MODEL = "Model";
    public static final String MANUFACTURER = "Manufacturer";
    public static final String SERIAL_NUMBER = "Serial Number";
    public static final String LOT_NUMBER = "Lot Number";
    public static final String POSITION_X = "Position X";
    public static final String POSITION_Y = "Position Y";
    public static final String POSITION_Z = "Position Z";
    public static final String TYPE = "Type";
    public static final String VOLTAGE = "Voltage";
    public static final String GAIN = "Gain";
    public static final String OFFSET = "Offset";
    public static final String READ_OUT_RATE = "Read out rate";
    public static final String BINNING = "Binning";
    public static final String AMPLIFICATION = "Amplification Gain";
    public static final String ZOOM = "Zoom";
    public static final String EXPOSURE_TIME = "Exposure Time";
    public static final String DELTA_T = "DeltaT";
    public static final String POWER = "Power";
    public static final String LIGHT_TYPE = "Light";
    public static final String TUNEABLE = "Tuneable";
    public static final String PULSE = "Pulse";
    public static final String POCKEL_CELL = "PockelCell";
    public static final String REPETITION_RATE = "Repetition Rate";
    public static final String PUMP = "Pump";
    public static final String WAVELENGTH = "Wavelength";
    public static final String FREQUENCY_MULTIPLICATION = "Frequency Multiplication";
    public static final String IRIS = "Iris";
    public static final String NOT_SET = "NotSet";
    public static final String ROI_COUNT = "ROI Count";
    public static final String EXTERNAL_IDENTIFIER = "External Identifier";
    public static final String EXTERNAL_DESCRIPTION = "External Description";
    public static final String STATUS = "Status";
    public static final Map<String, String> PIXELS_TYPE_DESCRIPTION;
    public static final Map<String, String> PIXELS_TYPE;
    public static final String FILTER = "Filter";
    public static final String FILTER_WHEEL = "FilterWheel";
    public static final String TRANSMITTANCE = "Transmittance";
    public static final String CUT_IN = "Cut In";
    public static final String CUT_IN_TOLERANCE = "Cut In Tolerance";
    public static final String CUT_OUT = "Cut Out";
    public static final String CUT_OUT_TOLERANCE = "Cut Out Tolerance";
    public static final String ATTENUATION = "Attenuation (%)";
    public static final int MAX_FIELDS_DETECTOR_AND_SETTINGS = 12;
    public static final int MAX_FIELDS_DETECTOR = 10;
    public static final int MAX_FIELDS_FILTER = 11;
    public static final int MAX_FIELDS_OBJECTIVE_AND_SETTINGS = 14;
    public static final int MAX_FIELDS_OBJECTIVE = 11;
    public static final int MAX_FIELDS_LASER = 15;
    public static final int MAX_FIELDS_LIGHT = 7;
    public static final int MAX_FIELDS_LIGHT_AND_SETTINGS = 9;
    public static final int MAX_FIELDS_LASER_AND_SETTINGS = 15;
    public static final int MAX_FIELDS_DICHROIC = 4;
    public static final int MAX_FIELDS_CHANNEL = 10;
    public static final int MAX_FIELDS_STAGE_LABEL = 4;
    public static final int MAX_FIELDS_ENVIRONMENT = 4;
    public static final int MAX_FIELDS_MICROSCOPE = 5;
    public static final int MAX_FIELDS_PLANE_INFO = 5;
    public static final String TIME_UNIT = "s";
    private static final Color INDIGO;
    private static final Color VIOLET;
    public static final String NONBRSPACE = "\u00a0";
    public static final String DATE_PICKER_FORMAT = "yyyy-MM-dd";
    private static final int PERCENT_FRACTION = 100;
    public static final Map<Color, String> COLORS_BAR;
    public static final List<CustomizedFileFilter> SCRIPTS_FILTERS;

    private static String formatPixelsSize(Map details) {
        UnitsLength unit = null;
        Length x = (Length)details.get(PIXEL_SIZE_X);
        Length y = (Length)details.get(PIXEL_SIZE_Y);
        Length z = (Length)details.get(PIXEL_SIZE_Z);
        Double dx = null;
        Double dy = null;
        Double dz = null;
        DecimalFormat nf = new DecimalFormat("0.00");
        try {
            x = UIUtilities.transformSize(x);
            unit = x.getUnit();
            dx = x.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (unit == null) {
                y = UIUtilities.transformSize(y);
                dy = y.getValue();
                unit = y.getUnit();
            } else {
                y = new LengthI(y, unit);
                dy = y.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (unit == null) {
                z = UIUtilities.transformSize(z);
                dz = z.getValue();
                unit = z.getUnit();
            } else {
                z = new LengthI(z, unit);
                dz = z.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String label = "<b>Pixels Size (";
        String value = "";
        if (dx != null && dx > 0.0) {
            value = value + nf.format(dx);
            label = label + "X";
        }
        if (dy != null && dy > 0.0) {
            value = value.length() == 0 ? value + nf.format(dy) : value + "x" + nf.format(dy);
            label = label + "Y";
        }
        if (dz != null && dz > 0.0) {
            value = value.length() == 0 ? value + nf.format(dz) : value + "x" + nf.format(dz);
            label = label + "Z";
        }
        label = label + ") ";
        if (value.length() == 0) {
            return null;
        }
        if (unit == null) {
            unit = UnitsLength.MICROMETER;
        }
        return label + LengthI.lookupSymbol((UnitsLength)unit) + ": </b>" + value;
    }

    private static double roundValue(double v) {
        if (v <= 0.0) {
            return UIUtilities.roundTwoDecimals(v);
        }
        int decimal = UIUtilities.findDecimal(v, 1);
        if (decimal <= 2) {
            return UIUtilities.roundTwoDecimals(v);
        }
        return UIUtilities.ceil(v, decimal + 1);
    }

    public static Map<String, String> transformExperimenterData(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(2);
        if (data == null) {
            details.put(OWNER, "");
            details.put(EMAIL, "");
        } else {
            try {
                details.put(OWNER, data.getFirstName() + " " + data.getLastName());
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(OWNER, "");
                details.put(EMAIL, "");
            }
        }
        return details;
    }

    public static Map<String, Object> transformPixelsData(PixelsData data) {
        LengthI nullLength = new LengthI(0.0, UnitsLength.PIXEL);
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(9);
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, nullLength);
            details.put(PIXEL_SIZE_Y, nullLength);
            details.put(PIXEL_SIZE_Z, nullLength);
            details.put(PIXEL_TYPE, "");
            details.put(CHANNELS, "");
        } else {
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            details.put(CHANNELS, "" + data.getSizeC());
            Length l = null;
            try {
                l = data.getPixelSizeX(UnitsLength.MICROMETER);
            }
            catch (BigResult e) {
                details.put(PIXEL_SIZE_X, (Object)e);
            }
            details.put(PIXEL_SIZE_X, l == null ? nullLength : l);
            try {
                l = data.getPixelSizeY(UnitsLength.MICROMETER);
            }
            catch (BigResult e) {
                details.put(PIXEL_SIZE_Y, (Object)e);
            }
            details.put(PIXEL_SIZE_Y, l == null ? nullLength : l);
            try {
                l = data.getPixelSizeZ(UnitsLength.MICROMETER);
            }
            catch (BigResult e) {
                details.put(PIXEL_SIZE_Z, (Object)e);
            }
            details.put(PIXEL_SIZE_Z, l == null ? nullLength : l);
            details.put(PIXEL_TYPE, data.getPixelType());
        }
        details.put("Emission Wavelengths", "");
        return details;
    }

    public static Map<String, Object> transformImageData(ImageData image) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(10);
        if (image == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
            details.put("Emission Wavelengths", "");
            details.put(ACQUISITION_DATE, DATE_NOT_AVAILABLE);
            return details;
        }
        PixelsData data = image.getDefaultPixels();
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, NF.format(data.getPixelSizeX(UnitsLength.MICROMETER)));
            }
            catch (BigResult e) {
                details.put(PIXEL_SIZE_X, (Object)e);
            }
            try {
                details.put(PIXEL_SIZE_Y, NF.format(data.getPixelSizeY(UnitsLength.MICROMETER)));
            }
            catch (BigResult e) {
                details.put(PIXEL_SIZE_Y, (Object)e);
            }
            try {
                details.put(PIXEL_SIZE_Z, NF.format(data.getPixelSizeZ(UnitsLength.MICROMETER)));
            }
            catch (BigResult e) {
                details.put(PIXEL_SIZE_Z, (Object)e);
            }
            details.put(PIXEL_TYPE, PIXELS_TYPE_DESCRIPTION.get("" + data.getPixelType()));
        }
        details.put("Emission Wavelengths", "");
        Timestamp date = EditorUtil.getAcquisitionTime(image);
        if (date == null) {
            details.put(ACQUISITION_DATE, DATE_NOT_AVAILABLE);
        } else {
            details.put(ACQUISITION_DATE, UIUtilities.formatTime(date));
        }
        return details;
    }

    public static Timestamp getAcquisitionTime(ImageData image) {
        if (image == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = image.getAcquisitionDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String formatExperimenter(ExperimenterData exp) {
        if (exp == null) {
            return "";
        }
        try {
            String s1 = exp.getFirstName();
            String s2 = exp.getLastName();
            if (s1.trim().length() == 0 && s2.trim().length() == 0) {
                return exp.getUserName();
            }
            if (s1.length() == 0) {
                return s2;
            }
            if (s2.length() == 0) {
                return s1;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(s1);
            buf.append(" ");
            buf.append(s2);
            return buf.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String formatExperimenterInitial(ExperimenterData exp, boolean capitalize) {
        if (exp == null) {
            return "";
        }
        try {
            String s1 = exp.getFirstName();
            String s2 = exp.getLastName();
            if (s1.trim().length() == 0 && s2.trim().length() == 0) {
                return exp.getUserName();
            }
            if (s1.length() == 0) {
                return s2;
            }
            if (s2.length() == 0) {
                return s1;
            }
            StringBuffer buf = new StringBuffer();
            if (capitalize) {
                buf.append(Character.toUpperCase(s1.charAt(0)));
            } else {
                buf.append(Character.toLowerCase(s1.charAt(0)));
            }
            buf.append(". ");
            buf.append(s2);
            return buf.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Map<String, String> convertExperimenter(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(3);
        if (data == null) {
            details.put(FIRST_NAME, "");
            details.put(MIDDLE_NAME, "");
            details.put(LAST_NAME, "");
            details.put(EMAIL, "");
            details.put(INSTITUTION, "");
        } else {
            try {
                details.put(FIRST_NAME, data.getFirstName());
            }
            catch (Exception e) {
                details.put(FIRST_NAME, "");
            }
            try {
                details.put(MIDDLE_NAME, data.getMiddleName());
            }
            catch (Exception e) {
                details.put(MIDDLE_NAME, "");
            }
            try {
                details.put(LAST_NAME, data.getLastName());
            }
            catch (Exception e) {
                details.put(LAST_NAME, "");
            }
            try {
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(EMAIL, "");
            }
            try {
                details.put(INSTITUTION, data.getInstitution());
            }
            catch (Exception e) {
                details.put(INSTITUTION, "");
            }
        }
        return details;
    }

    public static boolean isAnnotated(Object object) {
        return EditorUtil.isAnnotated(object, 0);
    }

    public static boolean isAnnotated(Object object, int count) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else {
            if (object instanceof ImageData) {
                ImageData image = (ImageData)object;
                counts = image.getAnnotationsCounts();
                if (counts == null || counts.size() <= 0) {
                    return count > 0;
                }
                Iterator i = counts.entrySet().iterator();
                long value = 0L;
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    value += ((Long)entry.getValue()).longValue();
                }
                return (value += (long)count) > 0L;
            }
            if (object instanceof ScreenData) {
                counts = ((ScreenData)object).getAnnotationsCounts();
            } else if (object instanceof PlateData) {
                counts = ((PlateData)object).getAnnotationsCounts();
            } else if (object instanceof WellData) {
                counts = ((WellData)object).getAnnotationsCounts();
            } else if (object instanceof PlateAcquisitionData) {
                counts = ((PlateAcquisitionData)object).getAnnotationsCounts();
            }
        }
        if (counts == null || counts.size() <= 0) {
            return count > 0;
        }
        return counts.size() + count > 0;
    }

    public static boolean isAnnotatedByCurrentUser(Object object, long userID) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        } else if (object instanceof PlateAcquisitionData) {
            counts = ((PlateAcquisitionData)object).getAnnotationsCounts();
        }
        if (counts == null || counts.size() == 0) {
            return false;
        }
        return counts.keySet().contains(userID);
    }

    public static boolean isAnnotatedByOtherUser(Object object, long userID) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        } else if (object instanceof PlateAcquisitionData) {
            counts = ((PlateAcquisitionData)object).getAnnotationsCounts();
        }
        if (counts == null || counts.size() == 0) {
            return false;
        }
        Set set = counts.keySet();
        if (set.size() > 1) {
            return true;
        }
        return !set.contains(userID);
    }

    public static String getPartialName(String originalName) {
        return UIUtilities.getPartialName(originalName);
    }

    public static String truncate(String name) {
        return EditorUtil.truncate(name, 50);
    }

    public static String truncate(String name, int maxLength, boolean start) {
        if (name == null || maxLength < 0) {
            return "";
        }
        int v = maxLength + "...".length();
        int n = name.length();
        if (n > v) {
            if (start) {
                return "..." + name.substring(n - maxLength, n);
            }
            return name.substring(0, maxLength) + "...";
        }
        return name;
    }

    public static String truncate(String name, int maxLength) {
        return EditorUtil.truncate(name, maxLength, true);
    }

    public static final String getObjectName(String originalName) {
        int n;
        if (originalName == null) {
            return null;
        }
        String[] l = UIUtilities.splitString(originalName);
        if (l != null && (n = l.length) > 0) {
            return l[n - 1];
        }
        return originalName;
    }

    public static boolean isReadable(Object ho) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        return ho instanceof DataObject;
    }

    public static boolean isUserOwner(Object ho, long userID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        try {
            if (userID == data.getOwner().getId()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isUserGroupOwner(GroupData group, long userID) {
        if (group == null) {
            return false;
        }
        Set owners = group.getLeaders();
        if (owners == null) {
            return false;
        }
        for (ExperimenterData exp : owners) {
            if (exp.getId() != userID) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> transformChannelData(ChannelData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(10);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(NAME, "");
        details.put(EXCITATION, 0);
        details.put(EMISSION, 0);
        details.put(ND_FILTER, NF.format(Float.valueOf(0.0f)));
        details.put(PIN_HOLE_SIZE, NF.format(Float.valueOf(0.0f)));
        details.put(FLUOR, "");
        details.put(ILLUMINATION, "");
        details.put(CONTRAST_METHOD, "");
        details.put(MODE, "");
        details.put(POCKEL_CELL_SETTINGS, 0);
        if (data == null) {
            notSet.add(NAME);
            notSet.add(EMISSION);
            notSet.add(EXCITATION);
            notSet.add(ND_FILTER);
            notSet.add(PIN_HOLE_SIZE);
            notSet.add(FLUOR);
            notSet.add(ILLUMINATION);
            notSet.add(CONTRAST_METHOD);
            notSet.add(MODE);
            notSet.add(POCKEL_CELL_SETTINGS);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getName();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(NAME);
        }
        details.put(NAME, s);
        Length wl = null;
        try {
            wl = data.getEmissionWavelength(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (wl == null) {
            notSet.add(EMISSION);
        } else {
            double wave = wl.getValue();
            if (wave <= 100.0) {
                notSet.add(EMISSION);
            } else if (DoubleMath.isMathematicalInteger((double)wave)) {
                details.put(EMISSION, (int)wave + NONBRSPACE + wl.getSymbol());
            } else {
                details.put(EMISSION, NF.format(wave) + NONBRSPACE + wl.getSymbol());
            }
        }
        try {
            wl = data.getExcitationWavelength(null);
        }
        catch (BigResult wave) {
            // empty catch block
        }
        if (wl == null) {
            notSet.add(EXCITATION);
        } else {
            double wave = wl.getValue();
            if (wave <= 100.0) {
                notSet.add(EXCITATION);
            } else if (DoubleMath.isMathematicalInteger((double)wave)) {
                details.put(EXCITATION, (int)wave + NONBRSPACE + wl.getSymbol());
            } else {
                details.put(EXCITATION, NF.format(wave) + NONBRSPACE + wl.getSymbol());
            }
        }
        double f = data.getNDFilter();
        if (f < 0.0) {
            notSet.add(ND_FILTER);
        } else {
            details.put(ND_FILTER, NF.format(f * 100.0));
        }
        Length ph = null;
        try {
            ph = data.getPinholeSize(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (ph == null) {
            notSet.add(PIN_HOLE_SIZE);
        } else {
            f = ph.getValue();
            details.put(PIN_HOLE_SIZE, NF.format(f) + NONBRSPACE + ph.getSymbol());
        }
        s = data.getFluor();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(FLUOR);
        }
        details.put(FLUOR, s);
        s = data.getIllumination();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(ILLUMINATION);
        }
        details.put(ILLUMINATION, s);
        s = data.getContrastMethod();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(CONTRAST_METHOD);
        }
        details.put(CONTRAST_METHOD, s);
        s = data.getMode();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODE);
        }
        details.put(MODE, s);
        int i = data.getPockelCell();
        if (i < 0) {
            i = 0;
            notSet.add(POCKEL_CELL_SETTINGS);
        }
        details.put(POCKEL_CELL_SETTINGS, i);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDichroic(DichroicData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformMicroscope(InstrumentData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(TYPE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(TYPE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getMicroscopeModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getMicroscopeManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getMicroscopeSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getMicroscopeLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        s = data.getMicroscopeType();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformObjective(ObjectiveData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(NOMINAL_MAGNIFICATION, 0);
        details.put(CALIBRATED_MAGNIFICATION, Float.valueOf(0.0f));
        details.put(LENSNA, Float.valueOf(0.0f));
        details.put(IMMERSION, "");
        details.put(CORRECTION, "");
        details.put(WORKING_DISTANCE, Float.valueOf(0.0f));
        details.put(IRIS, null);
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(NOMINAL_MAGNIFICATION);
            notSet.add(CALIBRATED_MAGNIFICATION);
            notSet.add(LENSNA);
            notSet.add(IMMERSION);
            notSet.add(CORRECTION);
            notSet.add(WORKING_DISTANCE);
            notSet.add(IRIS);
            details.put(NOT_SET, notSet);
            return details;
        }
        Object o = data.hasIris();
        if (o == null) {
            notSet.add(IRIS);
        }
        details.put(IRIS, o);
        String s = data.getModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        double f = data.getNominalMagnification();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(NOMINAL_MAGNIFICATION);
        }
        details.put(NOMINAL_MAGNIFICATION, NF.format(f));
        f = data.getCalibratedMagnification();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(CALIBRATED_MAGNIFICATION);
        }
        details.put(CALIBRATED_MAGNIFICATION, NF.format(f));
        f = data.getLensNA();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(LENSNA);
        }
        details.put(LENSNA, f);
        s = data.getImmersion();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(IMMERSION);
        }
        details.put(IMMERSION, s);
        s = data.getCorrection();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(CORRECTION);
        }
        details.put(CORRECTION, s);
        Length wd = null;
        try {
            wd = data.getWorkingDistance(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (wd == null) {
            notSet.add(WORKING_DISTANCE);
        } else {
            f = wd.getValue();
            details.put(WORKING_DISTANCE, NF.format(f) + NONBRSPACE + wd.getSymbol());
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformObjectiveAndSettings(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(9);
        Map<String, Object> m = data == null ? EditorUtil.transformObjective(null) : EditorUtil.transformObjective(data.getObjective());
        List notSet = (List)m.get(NOT_SET);
        m.remove(NOT_SET);
        details.putAll(m);
        details.put(CORRECTION_COLLAR, Float.valueOf(0.0f));
        details.put(MEDIUM, "");
        details.put(REFRACTIVE_INDEX, Float.valueOf(0.0f));
        details.put(IRIS, null);
        if (data == null) {
            notSet.add(CORRECTION_COLLAR);
            notSet.add(MEDIUM);
            notSet.add(REFRACTIVE_INDEX);
            details.put(NOT_SET, notSet);
            return details;
        }
        double f = data.getCorrectionCollar();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(CORRECTION_COLLAR);
        }
        details.put(CORRECTION_COLLAR, NF.format(f));
        String s = data.getMedium();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MEDIUM);
        }
        details.put(MEDIUM, s);
        f = data.getRefractiveIndex();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(REFRACTIVE_INDEX);
        }
        details.put(REFRACTIVE_INDEX, NF.format(f));
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformImageEnvironment(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(TEMPERATURE, 0.0);
        details.put(AIR_PRESSURE, 0.0);
        details.put(HUMIDITY, 0.0);
        details.put(CO2_PERCENT, 0.0);
        if (data == null) {
            notSet.add(TEMPERATURE);
            notSet.add(AIR_PRESSURE);
            notSet.add(HUMIDITY);
            notSet.add(CO2_PERCENT);
            details.put(NOT_SET, notSet);
            return details;
        }
        Temperature t = null;
        try {
            t = data.getTemperature(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        double f = 0.0;
        if (t == null) {
            notSet.add(TEMPERATURE);
        } else {
            f = t.getValue();
            details.put(TEMPERATURE, NF.format(f) + NONBRSPACE + t.getSymbol());
        }
        Pressure p = null;
        try {
            p = data.getAirPressure(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (p == null) {
            notSet.add(AIR_PRESSURE);
        } else {
            f = p.getValue();
            details.put(AIR_PRESSURE, NF.format(f) + NONBRSPACE + p.getSymbol());
        }
        f = data.getHumidity();
        if (f < 0.0) {
            notSet.add(HUMIDITY);
        } else {
            details.put(HUMIDITY, NF.format(f * 100.0) + NONBRSPACE + "%");
        }
        f = data.getCo2Percent();
        if (f < 0.0) {
            notSet.add(CO2_PERCENT);
        } else {
            details.put(CO2_PERCENT, NF.format(f * 100.0) + NONBRSPACE + "%");
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformStageLabel(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(NAME, "");
        details.put(POSITION_X, new LengthI(0.0, UnitsLength.REFERENCEFRAME));
        details.put(POSITION_Y, new LengthI(0.0, UnitsLength.REFERENCEFRAME));
        details.put(POSITION_Z, new LengthI(0.0, UnitsLength.REFERENCEFRAME));
        if (data == null) {
            notSet.add(NAME);
            notSet.add(POSITION_X);
            notSet.add(POSITION_Y);
            notSet.add(POSITION_Z);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getLabelName();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(NAME);
        }
        details.put(NAME, s);
        try {
            Length l = data.getPositionX(null);
            if (l == null) {
                notSet.add(POSITION_X);
            } else {
                details.put(POSITION_X, l);
            }
            l = data.getPositionY(null);
            if (l == null) {
                notSet.add(POSITION_Y);
            } else {
                details.put(POSITION_Y, l);
            }
            l = data.getPositionZ(null);
            if (l == null) {
                notSet.add(POSITION_Z);
            } else {
                details.put(POSITION_Z, l);
            }
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformFilterSetManufacturer(FilterSetData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformFilter(FilterData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(TYPE, "");
        details.put(FILTER_WHEEL, "");
        details.put(CUT_IN, "");
        details.put(CUT_OUT, "");
        details.put(CUT_IN_TOLERANCE, "");
        details.put(CUT_OUT_TOLERANCE, "");
        details.put(TRANSMITTANCE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(TYPE);
            notSet.add(FILTER_WHEEL);
            notSet.add(CUT_IN);
            notSet.add(CUT_OUT);
            notSet.add(CUT_IN_TOLERANCE);
            notSet.add(CUT_OUT_TOLERANCE);
            notSet.add(TRANSMITTANCE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        s = data.getType();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        s = data.getFilterWheel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(FILTER_WHEEL);
        }
        details.put(FILTER_WHEEL, s);
        Length wl = null;
        try {
            wl = data.getCutIn(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        int i = 0;
        if (wl == null) {
            notSet.add(CUT_IN);
        } else {
            i = (int)wl.getValue();
            details.put(CUT_IN, i + NONBRSPACE + wl.getSymbol());
        }
        try {
            wl = data.getCutOut(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (wl == null) {
            notSet.add(CUT_OUT);
        } else {
            i = (int)wl.getValue();
            details.put(CUT_OUT, i + NONBRSPACE + wl.getSymbol());
        }
        try {
            wl = data.getCutInTolerance(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (wl == null) {
            notSet.add(CUT_IN_TOLERANCE);
        } else {
            i = (int)wl.getValue();
            details.put(CUT_IN_TOLERANCE, i + NONBRSPACE + wl.getSymbol());
        }
        try {
            wl = data.getCutOutTolerance(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (wl == null) {
            notSet.add(CUT_OUT_TOLERANCE);
        } else {
            i = (int)wl.getValue();
            details.put(CUT_OUT_TOLERANCE, i + NONBRSPACE + wl.getSymbol());
        }
        Double d = data.getTransmittance();
        double dv = 0.0;
        if (d == null) {
            notSet.add(TRANSMITTANCE);
        } else {
            dv = d;
        }
        details.put(TRANSMITTANCE, NF.format(dv));
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformLightSourceAndSetting(ChannelAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        Map<String, Object> m = data == null ? EditorUtil.transformLightSource(null) : EditorUtil.transformLightSource(data.getLightSource());
        List notSet = (List)m.get(NOT_SET);
        m.remove(NOT_SET);
        details.putAll(m);
        details.put(ATTENUATION, 0.0);
        if (data == null) {
            details.put(WAVELENGTH, Float.valueOf(0.0f));
            notSet.add(ATTENUATION);
            notSet.add(WAVELENGTH);
            details.put(NOT_SET, notSet);
            return details;
        }
        Double f = data.getLightSettingsAttenuation();
        double v = 0.0;
        if (f == null) {
            notSet.add(ATTENUATION);
        } else {
            v = f;
        }
        details.put(ATTENUATION, NF.format(v * 100.0));
        Length wl = null;
        try {
            wl = data.getLightSettingsWavelength(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (details.containsKey(WAVELENGTH)) {
            if (wl != null) {
                details.put(WAVELENGTH, NF.format(wl.getValue()) + NONBRSPACE + wl.getSymbol());
                notSet.remove(WAVELENGTH);
            }
        } else {
            Double vi = 0.0;
            if (wl == null) {
                notSet.add(WAVELENGTH);
            } else {
                vi = wl.getValue();
                details.put(WAVELENGTH, NF.format(vi) + NONBRSPACE + wl.getSymbol());
                notSet.remove(WAVELENGTH);
            }
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformLightSource(LightSourceData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(LIGHT_TYPE, "");
        details.put(POWER, 0.0);
        details.put(TYPE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(LIGHT_TYPE);
            notSet.add(POWER);
            notSet.add(TYPE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getLightSourceModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        s = data.getKind();
        details.put(LIGHT_TYPE, s);
        Power p = null;
        try {
            p = data.getPower(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        double f = 0.0;
        if (p == null) {
            notSet.add(POWER);
        } else {
            f = p.getValue();
            details.put(POWER, NF.format(f) + NONBRSPACE + p.getSymbol());
        }
        s = data.getType();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        s = data.getKind();
        if (LightSourceData.LASER.equals(s)) {
            LightSourceData pump = data.getLaserPump();
            if (pump != null) {
                String value = EditorUtil.getLightSourceType(pump.getKind());
                s = pump.getLightSourceModel();
                if (CommonsLangUtils.isBlank(s) && CommonsLangUtils.isBlank(s = pump.getManufacturer())) {
                    s = pump.getSerialNumber();
                    if (CommonsLangUtils.isBlank(s)) {
                        s = pump.getLotNumber();
                    }
                    if (CommonsLangUtils.isBlank(s)) {
                        s = "" + pump.getId();
                    }
                }
                details.put(PUMP, value + ": " + s);
            } else {
                notSet.add(PUMP);
            }
            s = data.getLaserMedium();
            if (CommonsLangUtils.isBlank(s)) {
                notSet.add(MEDIUM);
            }
            details.put(MEDIUM, s);
            Length wl = null;
            try {
                wl = data.getLaserWavelength(null);
            }
            catch (BigResult bigResult) {
                // empty catch block
            }
            double wave = 0.0;
            if (wl == null) {
                notSet.add(WAVELENGTH);
            } else {
                wave = wl.getValue();
                details.put(WAVELENGTH, NF.format(wave) + NONBRSPACE + wl.getSymbol());
            }
            int i = data.getLaserFrequencyMultiplication();
            if (i < 0) {
                notSet.add(FREQUENCY_MULTIPLICATION);
            } else {
                details.put(FREQUENCY_MULTIPLICATION, i);
            }
            Object o = data.getLaserTuneable();
            if (o == null) {
                notSet.add(TUNEABLE);
            }
            details.put(TUNEABLE, o);
            s = data.getLaserPulse();
            if (CommonsLangUtils.isBlank(s)) {
                notSet.add(PULSE);
            }
            details.put(PULSE, s);
            Frequency freq = null;
            try {
                freq = data.getLaserRepetitionRate(null);
            }
            catch (BigResult bigResult) {
                // empty catch block
            }
            if (freq == null) {
                notSet.add(REPETITION_RATE);
            } else {
                f = freq.getValue();
                details.put(REPETITION_RATE, NF.format(f) + NONBRSPACE + freq.getSymbol());
            }
            o = data.getLaserPockelCell();
            if (o == null) {
                notSet.add(POCKEL_CELL);
            }
            details.put(POCKEL_CELL, o);
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDetector(DetectorData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(TYPE, "");
        details.put(GAIN, 0.0);
        details.put(VOLTAGE, 0.0);
        details.put(OFFSET, 0.0);
        details.put(ZOOM, 0.0);
        details.put(AMPLIFICATION, "");
        ArrayList<String> notSet = new ArrayList<String>();
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(GAIN);
            notSet.add(VOLTAGE);
            notSet.add(ZOOM);
            notSet.add(AMPLIFICATION);
            notSet.add(TYPE);
            notSet.add(OFFSET);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        Double f = data.getGain();
        double v = 0.0;
        if (f == null) {
            notSet.add(GAIN);
        } else {
            v = f;
        }
        details.put(GAIN, NF.format(v));
        ElectricPotential p = null;
        try {
            p = data.getVoltage(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (p == null) {
            notSet.add(VOLTAGE);
        } else {
            v = p.getValue();
            details.put(VOLTAGE, NF.format(v) + NONBRSPACE + p.getSymbol());
        }
        f = data.getOffset();
        if (f == null) {
            notSet.add(OFFSET);
        } else {
            v = f;
            details.put(OFFSET, NF.format(v));
        }
        f = data.getZoom();
        if (f == null) {
            notSet.add(ZOOM);
        } else {
            v = f;
            details.put(ZOOM, NF.format(v));
        }
        f = data.getAmplificationGain();
        if (f == null) {
            notSet.add(AMPLIFICATION);
        } else {
            v = f;
            details.put(AMPLIFICATION, NF.format(v));
        }
        s = data.getType();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(TYPE);
        } else {
            details.put(TYPE, s);
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDetectorAndSettings(ChannelAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(11);
        Map<String, Object> m = data == null ? EditorUtil.transformDetector(null) : EditorUtil.transformDetector(data.getDetector());
        List notSet = (List)m.get(NOT_SET);
        m.remove(NOT_SET);
        details.putAll(m);
        details.put(READ_OUT_RATE, 0.0);
        details.put(BINNING, "");
        if (data == null) {
            notSet.add(READ_OUT_RATE);
            notSet.add(BINNING);
            details.put(NOT_SET, notSet);
            return details;
        }
        Double f = data.getDetectorSettingsGain();
        if (f != null) {
            details.put(GAIN, NF.format(f));
            notSet.remove(GAIN);
        }
        ElectricPotential p = null;
        try {
            p = data.getDetectorSettingsVoltage(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (p != null) {
            f = p.getValue();
            notSet.remove(VOLTAGE);
            details.put(VOLTAGE, NF.format(f) + NONBRSPACE + p.getSymbol());
        }
        if ((f = data.getDetectorSettingsOffset()) != null) {
            notSet.remove(OFFSET);
            details.put(OFFSET, NF.format(f));
        }
        Frequency freq = null;
        try {
            freq = data.getDetectorSettingsReadOutRate(null);
        }
        catch (BigResult bigResult) {
            // empty catch block
        }
        if (freq == null) {
            notSet.add(READ_OUT_RATE);
        } else {
            details.put(READ_OUT_RATE, NF.format(freq.getValue()) + NONBRSPACE + freq.getSymbol());
        }
        String s = data.getDetectorSettingsBinning();
        if (CommonsLangUtils.isBlank(s)) {
            notSet.add(BINNING);
        }
        details.put(BINNING, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static String formatTimeInSeconds(Double value) {
        if (value == null) {
            return "";
        }
        return UIUtilities.formatTimeInSeconds(value.intValue());
    }

    public static Map<String, Object> transformPlaneInfo(PlaneInfo plane) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        details.put(DELTA_T, 0.0);
        details.put(EXPOSURE_TIME, 0.0);
        details.put(POSITION_X, new LengthI(0.0, UnitsLength.REFERENCEFRAME));
        details.put(POSITION_Y, new LengthI(0.0, UnitsLength.REFERENCEFRAME));
        details.put(POSITION_Z, new LengthI(0.0, UnitsLength.REFERENCEFRAME));
        ArrayList<String> notSet = new ArrayList<String>(5);
        notSet.add(DELTA_T);
        notSet.add(EXPOSURE_TIME);
        notSet.add(POSITION_X);
        notSet.add(POSITION_Y);
        notSet.add(POSITION_Z);
        details.put(NOT_SET, notSet);
        if (plane != null) {
            Length o;
            Time t = plane.getDeltaT();
            if (t != null) {
                notSet.remove(DELTA_T);
                try {
                    details.put(DELTA_T, UnitsFactory.convertTime((Time)t, (Unit)UNITS.SECOND).getValue());
                }
                catch (BigResult e) {
                    details.put(DELTA_T, (Object)e);
                }
            }
            if ((t = plane.getExposureTime()) != null) {
                notSet.remove(EXPOSURE_TIME);
                try {
                    details.put(EXPOSURE_TIME, UnitsFactory.convertTime((Time)t, (Unit)UNITS.SECOND).getValue());
                }
                catch (BigResult e) {
                    details.put(EXPOSURE_TIME, (Object)e);
                }
            }
            if ((o = plane.getPositionX()) != null) {
                notSet.remove(POSITION_X);
                details.put(POSITION_X, o);
            }
            if ((o = plane.getPositionY()) != null) {
                notSet.remove(POSITION_Y);
                details.put(POSITION_Y, o);
            }
            if ((o = plane.getPositionZ()) != null) {
                notSet.remove(POSITION_Z);
                details.put(POSITION_Z, o);
            }
        }
        return details;
    }

    public static OMEComboBox createComboBox(Object[] values, int decrement, Color backgoundColor) {
        OMEComboBox box = new OMEComboBox(values);
        box.setOpaque(true);
        if (backgoundColor != null) {
            box.setBackground(backgoundColor);
        }
        OMEComboBoxUI ui = new OMEComboBoxUI();
        ui.setBackgroundColor(box.getBackground());
        ui.installUI(box);
        box.setUI(ui);
        Font f = box.getFont();
        int size = f.getSize() - decrement;
        box.setBorder(null);
        box.setFont(f.deriveFont(2, size));
        return box;
    }

    public static OMEComboBox createComboBox(Object[] values, int decrement) {
        return EditorUtil.createComboBox(values, decrement, UIUtilities.BACKGROUND_COLOR);
    }

    public static OMEComboBox createComboBox(Object[] values) {
        return EditorUtil.createComboBox(values, 3);
    }

    public static OMEComboBox createComboBox(List values) {
        if (values == null) {
            return null;
        }
        Iterator i = values.iterator();
        Object[] array = new Object[values.size()];
        int index = 0;
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return EditorUtil.createComboBox(array, 3);
    }

    public static JXTaskPane createTaskPane(String title) {
        return UIUtilities.createTaskPane(title, UIUtilities.BACKGROUND_COLOR);
    }

    public static JComponent getLabel(String value, boolean required) {
        if (required) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            JLabel l = UIUtilities.setTextFont(value);
            p.add(l);
            l = UIUtilities.setTextFont(MANDATORY_SYMBOL);
            l.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
            p.add(l);
            return p;
        }
        return UIUtilities.setTextFont(value);
    }

    public static String getWorkflowForDisplay(String value) {
        if (value == null) {
            return value;
        }
        String result = value;
        if (value.contains("/")) {
            String[] list = value.split("/");
            result = list[list.length - 1];
        }
        return result;
    }

    public static String formatDate(DataObject object) {
        String date = "";
        Timestamp time = null;
        if (object == null) {
            return date;
        }
        time = object instanceof AnnotationData ? ((AnnotationData)object).getLastModified() : (object instanceof ImageData ? EditorUtil.getAcquisitionTime((ImageData)object) : object.getCreated());
        if (time != null && time.getTime() > 0L) {
            date = UIUtilities.formatDefaultDate(time);
        }
        return date;
    }

    public static List<String> formatObjectTooltip(DataObject object) {
        String v;
        if (object == null) {
            return null;
        }
        if (!(object instanceof ImageData || object instanceof WellSampleData || object instanceof PlateData || object instanceof WellData)) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        ImageData img = null;
        if (object instanceof ImageData) {
            img = (ImageData)object;
        } else if (object instanceof WellSampleData) {
            img = ((WellSampleData)object).getImage();
        } else if (object instanceof PlateData) {
            PlateData plate = (PlateData)object;
            v = plate.getPlateType();
            if (v != null && v.trim().length() > 0) {
                v = "<b>Type: </b>" + v;
                l.add(v);
            }
            if ((v = plate.getExternalIdentifier()) != null && v.trim().length() > 0) {
                v = "<b>External Identifier: </b>" + v;
                l.add(v);
            }
            if ((v = plate.getStatus()) != null && v.trim().length() > 0) {
                v = "<b>Status: </b>" + v;
                l.add(v);
            }
        } else if (object instanceof WellData) {
            WellData well = (WellData)object;
            v = well.getWellType();
            if (v != null && v.trim().length() > 0) {
                v = "<b>Type: </b>" + v;
                l.add(v);
            }
            if ((v = well.getExternalDescription()) != null && v.trim().length() > 0) {
                v = "<b>External Identifier: </b>" + v;
                l.add(v);
            }
            if ((v = well.getStatus()) != null && v.trim().length() > 0) {
                v = "<b>Status: </b>" + v;
                l.add(v);
            }
        }
        if (img == null) {
            return l;
        }
        v = "<b>Acquisition Date: </b>" + EditorUtil.formatDate((DataObject)img);
        l.add(v);
        try {
            v = "<b>Import Date: </b>" + UIUtilities.formatDefaultDate(img.getInserted());
            l.add(v);
        }
        catch (Exception well) {
            // empty catch block
        }
        PixelsData data = null;
        try {
            data = img.getDefaultPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data == null) {
            return l;
        }
        Map<String, Object> details = EditorUtil.transformPixelsData(data);
        v = "<b>Dimensions (XY): </b>";
        v = v + (String)details.get(SIZE_X);
        v = v + " x ";
        v = v + (String)details.get(SIZE_Y);
        l.add(v);
        v = "<b>Pixel Type: </b>" + details.get(PIXEL_TYPE);
        l.add(v);
        v = EditorUtil.formatPixelsSize(details);
        if (v != null) {
            l.add(v);
        }
        v = "<b>ZxTxC: </b>";
        v = v + (String)details.get(SECTIONS);
        v = v + " x ";
        v = v + (String)details.get(TIMEPOINTS);
        v = v + " x ";
        v = v + (String)details.get(CHANNELS);
        l.add(v);
        return l;
    }

    public static String getLightSourceType(String kind) {
        if (LightSourceData.LASER.equals(kind)) {
            return LASER_TYPE;
        }
        if (LightSourceData.ARC.equals(kind)) {
            return ARC_TYPE;
        }
        if (LightSourceData.FILAMENT.equals(kind)) {
            return FILAMENT_TYPE;
        }
        if (LightSourceData.LIGHT_EMITTING_DIODE.equals(kind)) {
            return EMITTING_DIODE_TYPE;
        }
        return "Light Source";
    }

    public static TreeImageDisplay getDataOwner(TreeImageDisplay node) {
        if (node == null) {
            return null;
        }
        TreeImageDisplay parent = node.getParentDisplay();
        if (parent == null) {
            Object ho = node.getUserObject();
            if (ho instanceof ExperimenterData) {
                return node;
            }
            return null;
        }
        Object ho = parent.getUserObject();
        if (ho instanceof ExperimenterData) {
            return parent;
        }
        return EditorUtil.getDataOwner(parent);
    }

    public static TreeImageDisplay getDataGroup(TreeImageDisplay node) {
        if (node == null) {
            return null;
        }
        TreeImageDisplay parent = node.getParentDisplay();
        if (parent == null) {
            Object ho = node.getUserObject();
            if (ho instanceof GroupData) {
                return node;
            }
            return null;
        }
        Object ho = parent.getUserObject();
        if (ho instanceof GroupData) {
            return parent;
        }
        return EditorUtil.getDataGroup(parent);
    }

    public static boolean isTransferable(Object target, Object src, long userID) {
        if (target instanceof ProjectData && src instanceof DatasetData) {
            return true;
        }
        if (target instanceof DatasetData && src instanceof ImageData) {
            return true;
        }
        if (target instanceof ScreenData && src instanceof PlateData) {
            return true;
        }
        if (target instanceof GroupData) {
            if (src instanceof ExperimenterData) {
                return true;
            }
            if (src instanceof DataObject) {
                GroupData g = (GroupData)target;
                DataObject data = (DataObject)src;
                return g.getId() != data.getGroupId();
            }
        } else {
            if (target instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)target;
                return exp.getId() == userID;
            }
            if (target instanceof TagAnnotationData && src instanceof TagAnnotationData) {
                TagAnnotationData tagSet = (TagAnnotationData)target;
                TagAnnotationData tag = (TagAnnotationData)src;
                if ("openmicroscopy.org/omero/insight/tagset".equals(tagSet.getNameSpace())) {
                    return !"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace());
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isInternalNS(String ns) {
        return ns.startsWith("openmicroscopy.org") || ns.startsWith("omero.");
    }

    static {
        INDIGO = new Color(75, 0, 130);
        VIOLET = new Color(238, 130, 238);
        SCRIPTS_FILTERS = new ArrayList<CustomizedFileFilter>();
        SCRIPTS_FILTERS.add(new CppFilter());
        SCRIPTS_FILTERS.add(new JavaFilter());
        SCRIPTS_FILTERS.add(new MatlabFilter());
        SCRIPTS_FILTERS.add(new PythonFilter());
        PIXELS_TYPE_DESCRIPTION = new LinkedHashMap<String, String>();
        PIXELS_TYPE_DESCRIPTION.put("int8", "Signed 8-bit (1 byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint8", "Unsigned 8-bit (1 byte)");
        PIXELS_TYPE_DESCRIPTION.put("int16", "Signed 16-bit (2 byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint16", "Unsigned 16-bit (2 byte)");
        PIXELS_TYPE_DESCRIPTION.put("int32", "Signed 32-bit (4 byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint32", "Unsigned 32-bit (4 byte)");
        PIXELS_TYPE_DESCRIPTION.put("float", "Float");
        PIXELS_TYPE_DESCRIPTION.put("double", "Double");
        PIXELS_TYPE = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : PIXELS_TYPE_DESCRIPTION.entrySet()) {
            PIXELS_TYPE.put(entry.getValue(), entry.getKey());
        }
        COLORS_BAR = new LinkedHashMap<Color, String>();
        COLORS_BAR.put(ImagePaintingFactory.UNIT_BAR_COLOR, "Gray");
        COLORS_BAR.put(Color.ORANGE, "Orange");
        COLORS_BAR.put(Color.YELLOW, "Yellow");
        COLORS_BAR.put(Color.BLACK, "Black");
        COLORS_BAR.put(INDIGO, "Indigo");
        COLORS_BAR.put(VIOLET, "Violet");
        COLORS_BAR.put(Color.RED, "Red");
        COLORS_BAR.put(Color.GREEN, "Green");
        COLORS_BAR.put(Color.BLUE, "Blue");
        COLORS_BAR.put(Color.WHITE, "White");
    }
}

