/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.tagging.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagItem;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class TagCellRenderer
extends DefaultListCellRenderer {
    private static final Icon TAG_OTHER_OWNER_ICON;
    private static final Icon TAG_ICON;
    private long userID;

    public TagCellRenderer() {
        this(-1L);
    }

    public TagCellRenderer(long userID) {
        this.userID = userID;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof TagItem) {
            TagItem v = (TagItem)value;
            this.setText(v.getObjectName());
            if (this.userID == v.getOwnerID()) {
                this.setIcon(TAG_ICON);
            } else {
                this.setIcon(TAG_OTHER_OWNER_ICON);
            }
        }
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        TAG_ICON = icons.getIcon(64);
        TAG_OTHER_OWNER_ICON = icons.getIcon(88);
    }
}

