/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButtonPopupMenu;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.ColouredButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ChannelButton
extends ColouredButton
implements ActionListener {
    public static final Dimension DEFAULT_MIN_SIZE = new Dimension(30, 30);
    public static final Dimension DEFAULT_MAX_SIZE = new Dimension(60, 30);
    public static final String CHANNEL_SELECTED_PROPERTY = "channelSelected";
    public static final String CHANNEL_OVERLAY_PROPERTY = "channelOverlay";
    public static final String CHANNEL_COLOUR_PROPERTY = "channelColour";
    public static final int MIN_FONT_SIZE = 10;
    private static final String DESCRIPTION = "Toggle channel on/off.";
    protected final int index;
    private ChannelButtonPopupMenu popupMenu;
    private boolean rightClickSupported;
    private boolean overlay;
    private Font originalFont = this.getFont();
    private boolean trimEnd = true;

    private final void setChannelSelected() {
        if (!this.isEnabled()) {
            return;
        }
        Boolean value = true;
        if (this.isSelected()) {
            value = false;
        }
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>(1);
        map.put(this.index, value);
        if (this.overlay) {
            this.firePropertyChange(CHANNEL_OVERLAY_PROPERTY, null, map);
        } else {
            this.firePropertyChange(CHANNEL_SELECTED_PROPERTY, null, map);
        }
    }

    private void onClick(MouseEvent e) {
        boolean mask;
        boolean bl = mask = e.isControlDown() || e.isMetaDown();
        if (e.getButton() == 1 && !mask) {
            this.setChannelSelected();
        } else if (e.getButton() == 2 || mask) {
            this.onReleased(e);
        }
    }

    private void onReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.rightClickSupported) {
            if (this.popupMenu == null) {
                this.popupMenu = new ChannelButtonPopupMenu(this);
            }
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    private Dimension setComponentSize(int dimWidth) {
        Font f = this.getFont();
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(f);
        int width = fm.stringWidth(text);
        Dimension d = DEFAULT_MIN_SIZE;
        if (width > ChannelButton.DEFAULT_MIN_SIZE.width && width <= dimWidth) {
            d = new Dimension(width + 10, ChannelButton.DEFAULT_MIN_SIZE.height);
        } else if (width > dimWidth) {
            int size = fm.stringWidth("...");
            width += size;
            String s = "";
            int n = this.trimEnd ? 0 : text.length() - 1;
            ArrayList<Character> l = new ArrayList<Character>();
            while (fm.stringWidth(s) + size < dimWidth - size) {
                char ch = text.charAt(n);
                s = s + ch;
                l.add(Character.valueOf(ch));
                n = this.trimEnd ? n + 1 : n - 1;
            }
            if (!this.trimEnd) {
                Collections.reverse(l);
            }
            Iterator i = l.iterator();
            String string = s = this.trimEnd ? "" : "...";
            while (i.hasNext()) {
                s = s + i.next();
            }
            if (this.trimEnd) {
                s = s + "...";
            }
            super.setText(s);
            width = fm.stringWidth(s);
            d = new Dimension(width + 10, ChannelButton.DEFAULT_MIN_SIZE.height);
        }
        return d;
    }

    private String parseText(String text) {
        if (CommonsLangUtils.isBlank(text)) {
            return "";
        }
        String[] values = text.split("\\(");
        if (values == null || values.length == 0) {
            return text;
        }
        return values[0].trim();
    }

    private void setTextValue(String text) {
        super.setText(this.parseText(text));
        ArrayList<String> l = new ArrayList<String>(2);
        if (CommonsLangUtils.isNotBlank(text)) {
            l.add(text);
        }
        l.add(DESCRIPTION);
        this.setToolTipText(UIUtilities.formatToolTipText(l));
    }

    public ChannelButton(String text, Color color, int index, boolean selected, boolean trimEnd) {
        super(text, color);
        this.setTextValue(text);
        this.index = index;
        this.rightClickSupported = true;
        this.trimEnd = trimEnd;
        this.setSelected(selected);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ChannelButton.this.onClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChannelButton.this.onReleased(e);
            }
        });
        this.setPreferredSize(this.setComponentSize(ChannelButton.DEFAULT_MAX_SIZE.width));
    }

    public ChannelButton(String text, BufferedImage img, int index, boolean selected, boolean trimEnd) {
        super(text, img);
        this.setTextValue(text);
        this.index = index;
        this.rightClickSupported = true;
        this.trimEnd = trimEnd;
        this.setSelected(selected);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ChannelButton.this.onClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChannelButton.this.onReleased(e);
            }
        });
        this.setPreferredSize(this.setComponentSize(ChannelButton.DEFAULT_MAX_SIZE.width));
    }

    public ChannelButton(String text, Color color, int index, boolean selected) {
        this(text, color, index, selected, true);
    }

    public ChannelButton(String text, BufferedImage img, int index, boolean selected) {
        this(text, img, index, selected, true);
    }

    public ChannelButton(String text, Color color, int index) {
        this(text, color, index, false);
    }

    public ChannelButton(String text, BufferedImage img, int index) {
        this(text, img, index, false);
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    void showColorPicker() {
        this.firePropertyChange(CHANNEL_COLOUR_PROPERTY, null, (Object)this.index);
    }

    public int getChannelIndex() {
        return this.index;
    }

    public void setRightClickSupported(boolean value) {
        this.rightClickSupported = value;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    @Override
    public void setText(String text) {
        this.setTextValue(text);
        if (this.originalFont != null) {
            this.setFont(this.originalFont);
            if (CommonsLangUtils.isNotBlank(text)) {
                int width = this.getFontMetrics(this.getFont()).stringWidth(text);
                if (width > ChannelButton.DEFAULT_MAX_SIZE.width) {
                    width = ChannelButton.DEFAULT_MAX_SIZE.width;
                }
                if (width < this.getPreferredSize().width) {
                    width = this.getPreferredSize().width;
                }
                Dimension d = this.setComponentSize(width);
                this.setSize(d);
                this.setPreferredSize(d);
            }
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setChannelSelected();
    }
}

