/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnail;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class RollOverThumbnailCanvas
extends JComponent {
    private final RollOverThumbnail model;

    RollOverThumbnailCanvas(RollOverThumbnail md) {
        if (md == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = md;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createBevelBorder(1, UIUtilities.INNER_BORDER_HIGHLIGHT, UIUtilities.INNER_BORDER_SHADOW));
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                RollOverThumbnailCanvas.this.model.magnifyImage(e.getWheelRotation());
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.model.getImage() != null) {
            Insets i = this.getInsets();
            int x = i.left + 1;
            int y = i.top + 1;
            g2D.drawImage(this.model.getImage(), null, x, y);
        }
    }
}

