/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.util.ui.ComplexParamPane;
import org.openmicroscopy.shoola.agents.util.ui.IdentifierParamPane;
import org.openmicroscopy.shoola.agents.util.ui.ScriptingDialog;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ScriptComponent
extends JPanel
implements ChangeListener {
    static int COLUMNS = 10;
    private static final int TAB = 15;
    private static final String DEFAULT_TEXT = "";
    private JComponent component;
    private JLabel label;
    private JLabel requireLabel;
    private JLabel unitLabel;
    private JLabel info;
    private boolean required;
    private String parentIndex;
    private String nameLabel;
    private String name;
    private String grouping;
    private List<ScriptComponent> children;
    private ScriptComponent parent;

    private void setComponentColor(JComponent c, Color background) {
        c.setBackground(background);
        if (c.getComponentCount() > 0) {
            Component[] components = c.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof JComponent)) continue;
                this.setComponentColor((JComponent)components[i], background);
            }
        }
    }

    private JPanel createRow() {
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0, 0, 0));
        row.add(this.getLabel());
        row.add(this.getComponent());
        this.setComponentColor(row, ScriptingDialog.BG_COLOR);
        return row;
    }

    private int getTabulationLevel() {
        if (this.parentIndex == null || this.parentIndex.length() == 0) {
            return 0;
        }
        String[] values = this.parentIndex.split("\\.");
        return values.length;
    }

    private JComponent getLabel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        if (this.requireLabel != null) {
            JPanel lp = new JPanel();
            lp.setLayout(new BoxLayout(lp, 0));
            lp.add(this.label);
            lp.add(this.requireLabel);
            p.add(lp);
        } else {
            p.add(this.label);
        }
        if (this.info != null) {
            p.add(this.info);
        }
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JComponent getComponent() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0, 0, 0));
        p.add(this.component);
        if (this.unitLabel != null) {
            p.add(this.unitLabel);
        }
        return p;
    }

    private void handleSelection() {
        if (this.children == null) {
            return;
        }
        if (this.component instanceof JCheckBox) {
            Iterator<ScriptComponent> i = this.children.iterator();
            JCheckBox box = (JCheckBox)this.component;
            boolean selected = box.isSelected();
            while (i.hasNext()) {
                ScriptComponent c = i.next();
                c.setEnabled(selected);
            }
        }
    }

    ScriptComponent() {
        this(new JLabel(), DEFAULT_TEXT);
    }

    ScriptComponent(JComponent component, String name) {
        if (component == null) {
            throw new IllegalArgumentException("No component specified.");
        }
        if (name == null) {
            name = DEFAULT_TEXT;
        }
        if (component instanceof NumericalTextField) {
            ((NumericalTextField)component).setHorizontalAlignment(2);
        }
        this.component = component;
        this.name = name;
        this.parentIndex = null;
        if (!name.equals(DEFAULT_TEXT)) {
            name = " " + name + ":";
        }
        this.label = name.contains("_") ? UIUtilities.setTextFont(name.replace("_", " ")) : UIUtilities.setTextFont(name);
        this.label.setToolTipText(component.getToolTipText());
        this.required = false;
    }

    void setParameterName(String name) {
        this.name = name;
    }

    String getParameterName() {
        return this.name;
    }

    void setInfo(String text) {
        if (CommonsLangUtils.isBlank(text)) {
            return;
        }
        this.info = new JLabel();
        Font f = this.info.getFont();
        this.info.setFont(f.deriveFont(2, f.getSize() - 2));
    }

    void setRequired(boolean required) {
        this.required = required;
        if (required) {
            this.requireLabel = UIUtilities.setTextFont(" *");
            this.requireLabel.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
            this.requireLabel.setToolTipText(this.label.getToolTipText());
        }
    }

    void setUnit(String text) {
        if (CommonsLangUtils.isBlank(text)) {
            return;
        }
        if (this.unitLabel == null) {
            this.unitLabel = new JLabel();
        }
        this.unitLabel.setText(text);
    }

    boolean isRequired() {
        return this.required;
    }

    void buildUI() {
        int width = 15 * this.getTabulationLevel();
        if (DEFAULT_TEXT.equals(this.name) || CommonsLangUtils.isNumber(this.name)) {
            width = 0;
        }
        if (CollectionUtils.isEmpty(this.children)) {
            double[][] size = new double[][]{{width, -2.0, 5.0, -1.0}, {-2.0}};
            this.setLayout(new TableLayout(size));
            this.add(Box.createHorizontalStrut(width), "0, 0");
            this.add((Component)this.getLabel(), "1, 0");
            this.add((Component)this.getComponent(), "3, 0");
        } else {
            double[][] size = new double[][]{{-1.0}, {-2.0}};
            TableLayout layout = new TableLayout(size);
            this.setLayout(layout);
            Iterator<ScriptComponent> i = this.children.iterator();
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.add((Component)this.createRow(), "0, 0");
            int index = 1;
            while (i.hasNext()) {
                ScriptComponent child = i.next();
                String v = child.parentIndex;
                if (this.name != null && this.name.equals(v)) {
                    child.parentIndex = null;
                }
                child.buildUI();
                child.parentIndex = v;
                layout.insertRow(index, -2.0);
                this.add((Component)child, "0, " + index);
                ++index;
            }
        }
    }

    Object getValue() {
        boolean b;
        Object v;
        if (this.parent != null && (v = this.parent.getValue()) instanceof Boolean && !(b = ((Boolean)v).booleanValue())) {
            return null;
        }
        return ScriptComponent.getComponentValue(this.component);
    }

    static Object getComponentValue(JComponent c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JCheckBox) {
            JCheckBox box = (JCheckBox)c;
            return box.isSelected();
        }
        if (c instanceof NumericalTextField) {
            return ((NumericalTextField)c).getValueAsNumber();
        }
        if (c instanceof JTextField) {
            JTextField field = (JTextField)c;
            String value = field.getText();
            if (CommonsLangUtils.isBlank(value)) {
                return null;
            }
            return value;
        }
        if (c instanceof JComboBox) {
            JComboBox box = (JComboBox)c;
            return box.getSelectedItem();
        }
        if (c instanceof ComplexParamPane) {
            return ((ComplexParamPane)c).getValue();
        }
        if (c instanceof IdentifierParamPane) {
            return ((IdentifierParamPane)c).isReady();
        }
        return null;
    }

    void setParentIndex(String parentIndex) {
        if (parentIndex != null) {
            parentIndex = parentIndex.trim();
        }
        this.parentIndex = parentIndex;
    }

    String getParentIndex() {
        return this.parentIndex;
    }

    void setGrouping(String grouping) {
        this.grouping = grouping;
    }

    String getGrouping() {
        return this.grouping;
    }

    void setChildren(List<ScriptComponent> children) {
        this.children = children;
        if (this.component instanceof JCheckBox) {
            JCheckBox box = (JCheckBox)this.component;
            box.addChangeListener(this);
            Iterator<ScriptComponent> i = children.iterator();
            while (i.hasNext()) {
                i.next().setParent(this);
            }
        }
        this.handleSelection();
    }

    void setParent(ScriptComponent parent) {
        if (this.children != null) {
            return;
        }
        this.parent = parent;
    }

    boolean hasChildren() {
        return CollectionUtils.isNotEmpty(this.children);
    }

    void setNameLabel(String nameLabel) {
        this.nameLabel = nameLabel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.handleSelection();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.parentIndex == null) {
            return;
        }
        this.component.setEnabled(enabled);
    }

    @Override
    public String toString() {
        return this.nameLabel;
    }
}

