/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.cache;

import java.io.InputStream;
import omero.gateway.cache.CacheService;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.cache.CacheServiceImpl;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.file.IOUtil;

public class CacheServiceFactory {
    public static final String CACHE_CONFIG_FILE = "ehcache.xml";

    public static CacheService makeNew(Container container) {
        if (container == null) {
            return null;
        }
        Registry reg = container.getRegistry();
        Boolean isCachingOn = (Boolean)reg.lookup("/services/CACHE/on");
        if (!isCachingOn.booleanValue()) {
            return CacheServiceFactory.makeNoOpCache();
        }
        InputStream config = CacheServiceFactory.loadConfig(container.getConfigFileRelative(CACHE_CONFIG_FILE));
        if (config == null) {
            return CacheServiceFactory.makeNoOpCache();
        }
        CacheServiceImpl cache = new CacheServiceImpl(config, container.getRegistry().getLogger());
        try {
            config.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cache;
    }

    public static void shutdown(Container container) {
        if (container == null) {
            return;
        }
        Registry reg = container.getRegistry();
        ((CacheServiceImpl)reg.getCacheService()).shutDown();
    }

    private static CacheService makeNoOpCache() {
        return new CacheService(){

            public void addElement(int cacheID, Object key, Object element) {
            }

            public int createCache() {
                return -1;
            }

            public int createCache(int type) {
                return -1;
            }

            public int createCache(int type, int size) {
                return -1;
            }

            public Object getElement(int cacheID, Object key) {
                return null;
            }

            public void removeCache(int cacheID) {
            }

            public void clearCache(int cacheID) {
            }

            public void setCacheEntries(int cacheID, int size) {
            }

            public void clearAllCaches() {
            }

            public void shutDown() {
            }
        };
    }

    private static InputStream loadConfig(String file) {
        InputStream stream;
        try {
            stream = IOUtil.readConfigFile(file);
        }
        catch (Exception e) {
            return null;
        }
        return stream;
    }
}

