/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.AgentsEntry;
import org.openmicroscopy.shoola.env.config.BooleanEntry;
import org.openmicroscopy.shoola.env.config.ColorEntry;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.DoubleEntry;
import org.openmicroscopy.shoola.env.config.FloatEntry;
import org.openmicroscopy.shoola.env.config.FontEntry;
import org.openmicroscopy.shoola.env.config.IconFactoryEntry;
import org.openmicroscopy.shoola.env.config.IntegerEntry;
import org.openmicroscopy.shoola.env.config.LongEntry;
import org.openmicroscopy.shoola.env.config.MapEntry;
import org.openmicroscopy.shoola.env.config.OMEROEntry;
import org.openmicroscopy.shoola.env.config.PluginEntry;
import org.openmicroscopy.shoola.env.config.StringEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class Entry {
    static String ENTRY = "entry";
    static String STRUCT_ENTRY = "structuredEntry";
    private static String NAME = "name";
    private static String TYPE = "type";
    private static String DEFAULT_ENTRY = "string";
    private static String DEFAULT_STRUCT_ENTRY = "map";
    private static Map<String, Class<?>> contentHandlers = new HashMap();
    private String name;

    Entry() {
    }

    static Entry createEntryFor(Node tag) throws ConfigException {
        Entry entry = null;
        if (!tag.hasAttributes()) {
            throw new ConfigException("Missing tag's attributes.");
        }
        NameTypePair ntp = Entry.retrieveEntryAttributes(tag);
        Class<?> handler = contentHandlers.get(ntp.type);
        try {
            if (handler == null) {
                handler = Class.forName(ntp.type);
            }
            entry = (Entry)handler.newInstance();
        }
        catch (Exception e) {
            Entry.rethrow(ntp, e);
        }
        entry.name = ntp.name;
        entry.setContent(tag);
        return entry;
    }

    private static void rethrow(NameTypePair ntp, Exception e) throws ConfigException {
        StringBuffer msg = new StringBuffer("Can't instantiate tag's handler. Tag name: ");
        msg.append(ntp.name);
        msg.append(", type: ");
        msg.append(ntp.type);
        msg.append(".");
        throw new ConfigException(msg.toString(), e);
    }

    private static NameTypePair retrieveEntryAttributes(Node tag) throws ConfigException {
        NameTypePair ntp = new NameTypePair();
        NamedNodeMap attrList = tag.getAttributes();
        for (int i = 0; i < attrList.getLength(); ++i) {
            Node attribute = attrList.item(i);
            if (NAME.equals(attribute.getNodeName())) {
                ntp.name = attribute.getNodeValue();
                continue;
            }
            if (!TYPE.equals(attribute.getNodeName())) continue;
            ntp.type = attribute.getNodeValue();
        }
        if (ntp.name == null || ntp.name.length() == 0) {
            throw new ConfigException("Missing name attribute");
        }
        if (ntp.type == null) {
            ntp.type = ENTRY.equals(tag.getNodeName()) ? DEFAULT_ENTRY : DEFAULT_STRUCT_ENTRY;
        }
        return ntp;
    }

    protected void rethrow(String message, Exception e) throws ConfigException {
        StringBuffer msg = new StringBuffer();
        if (message == null || message.length() == 0) {
            message = "An error occurred.";
        }
        msg.append(message);
        String explanation = e.getMessage();
        if (explanation != null && explanation.length() != 0) {
            msg.append(" (");
            msg.append(explanation);
            msg.append(")");
        }
        throw new ConfigException(msg.toString(), e);
    }

    protected abstract void setContent(Node var1) throws ConfigException;

    abstract Object getValue();

    String getName() {
        return this.name;
    }

    static {
        contentHandlers.put("map", MapEntry.class);
        contentHandlers.put("string", StringEntry.class);
        contentHandlers.put("integer", IntegerEntry.class);
        contentHandlers.put("float", FloatEntry.class);
        contentHandlers.put("long", LongEntry.class);
        contentHandlers.put("double", DoubleEntry.class);
        contentHandlers.put("boolean", BooleanEntry.class);
        contentHandlers.put("OMERODS", OMEROEntry.class);
        contentHandlers.put("font", FontEntry.class);
        contentHandlers.put("color", ColorEntry.class);
        contentHandlers.put("icons", IconFactoryEntry.class);
        contentHandlers.put("agents", AgentsEntry.class);
        contentHandlers.put("agents", AgentsEntry.class);
        contentHandlers.put("plugins", PluginEntry.class);
    }

    private static class NameTypePair {
        String name;
        String type;

        private NameTypePair() {
        }
    }
}

