/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

public class PluginInfo {
    public static final int OR = 0;
    public static final int AND = 1;
    private String info;
    private String dependencies;
    private String directory;
    private String name;
    private int id;
    private int conjunction;

    public PluginInfo(String id, String dependencies, String directory) {
        if (id != null) {
            try {
                this.id = Integer.parseInt(id);
            }
            catch (Exception e) {
                this.id = -1;
            }
        }
        this.dependencies = dependencies;
        this.directory = directory;
        this.conjunction = 0;
    }

    public void setConjunction(String value) {
        if (value == null) {
            this.conjunction = 0;
        } else {
            String v = value.toLowerCase().trim();
            if (v.equals("and")) {
                this.conjunction = 1;
            } else if (v.equals("or")) {
                this.conjunction = 0;
            }
        }
    }

    public int getConjunction() {
        return this.conjunction;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    public String formatDependencies() {
        String[] values = this.getDependenciesAsArray();
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        String text = "";
        switch (this.conjunction) {
            case 1: {
                text = " and ";
                break;
            }
            default: {
                text = " or ";
            }
        }
        int n = values.length - 1;
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            buf.append(values[i]);
            if (j != n) {
                buf.append(text);
            }
            ++j;
        }
        return buf.toString();
    }

    public String getFirstDependency() {
        if (this.conjunction == 1) {
            return this.formatDependencies();
        }
        String[] values = this.getDependenciesAsArray();
        if (values == null || values.length == 0) {
            return "";
        }
        return values[0];
    }

    public String[] getDependenciesAsArray() {
        if (this.dependencies == null) {
            return null;
        }
        return this.dependencies.split(",");
    }

    public String getInfo() {
        return this.info;
    }

    public String getDirectory() {
        return this.directory;
    }

    public int getId() {
        return this.id;
    }
}

