/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.File;
import java.net.URI;

public class FSFile
extends File {
    private URI uri;

    public FSFile(URI uri) {
        super(uri == null ? null : uri.toString());
        this.uri = uri;
    }

    @Override
    public long lastModified() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        if (this.uri == null) {
            return false;
        }
        return this.uri.getPath().endsWith("/");
    }

    @Override
    public String getPath() {
        if (this.uri == null) {
            return null;
        }
        return this.uri.getPath();
    }

    @Override
    public String getAbsolutePath() {
        return this.getPath();
    }

    @Override
    public String getName() {
        if (this.uri == null) {
            return null;
        }
        File f = new File(this.getPath());
        return f.getName();
    }

    @Override
    public String getParent() {
        if (this.uri == null) {
            return null;
        }
        File realFile = new File(this.getPath());
        return realFile.getParent();
    }

    @Override
    public boolean equals(Object object) {
        FSFile to;
        if (object instanceof FSFile && (to = (FSFile)object).getPath().equals(this.getPath())) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int compareTo(File file) {
        String path = file.getPath();
        if (file instanceof FSFile) {
            FSFile f = (FSFile)file;
            path = f.getPath();
        }
        return this.getPath().compareTo(path) - 1;
    }
}

