/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import java.util.List;
import javax.swing.Icon;
import omero.gateway.model.DataObject;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SaveAsParam {
    public static final String SAVE_AS_SCRIPT = "/omero/export_scripts/Batch_Image_Export.py";
    private File folder;
    private List<DataObject> objects;
    private int index;
    private Icon icon;
    private boolean deleteWhenFinished = false;
    private String batchExportFilename;

    public SaveAsParam(File folder, List<DataObject> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            throw new IllegalArgumentException("No objects specified.");
        }
        this.objects = objects;
        if (folder == null) {
            folder = UIUtilities.getDefaultFolder();
        }
        this.folder = folder;
        this.index = 0;
    }

    public void setIndex(int index) {
        if (!FigureParam.FORMATS.containsKey(index)) {
            index = 0;
        }
        this.index = index;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getIndex() {
        return this.index;
    }

    public String getIndexAsString() {
        return FigureParam.FORMATS.get(this.index);
    }

    public File getFolder() {
        return this.folder;
    }

    public List<DataObject> getObjects() {
        return this.objects;
    }

    public boolean isDeleteWhenFinished() {
        return this.deleteWhenFinished;
    }

    public void setDeleteWhenFinished(boolean deleteWhenFinished) {
        this.deleteWhenFinished = deleteWhenFinished;
    }

    public String getBatchExportFilename() {
        return this.batchExportFilename;
    }

    public void setBatchExportFilename(String batchExportFilename) {
        this.batchExportFilename = batchExportFilename;
    }
}

