/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import omero.RType;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.grid.JobParams;
import omero.grid.Param;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.env.data.model.ParamData;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ScriptObject {
    public static final String PARAMETER_SEPARATOR = "_";
    public static final String PARAMETER_UI_SEPARATOR = " ";
    public static final String FIGURE_PATH = "/omero/figure_scripts/";
    public static final String EXPORT_PATH = "/omero/export_scripts/";
    public static final String REGION_PATH = "/omero/region_scripts/";
    public static final String IMPORT_PATH = "/omero/import_scripts/";
    public static final String UTIL_PATH = "/omero/util_scripts/";
    public static final String SETUP_PATH = "/omero/setup_scripts/";
    public static final String ANALYSIS_PATH = "/omero/analysis_scripts/";
    public static final int EXPORT = 0;
    public static final int FIGURE = 1;
    public static final int REGION = 2;
    public static final int UTIL = 3;
    public static final int IMPORT = 4;
    public static final int OTHER = 5;
    private static final String VERSION = "1.0";
    private static final String DATA_TYPE = "Data_Type";
    private static final String IMAGE_TYPE = "image";
    private static final String DATASET_TYPE = "dataset";
    private static final String PROJECT_TYPE = "project";
    private static final String SCREEN_TYPE = "screen";
    private static final String PLATE_TYPE = "plate";
    private static final List<String> IDENTIFIER_KEYS = new ArrayList<String>();
    private long scriptID;
    private String name;
    private String path;
    private String description;
    private String journalRef;
    private String contact;
    private String version;
    private Map<String, ParamData> inputs;
    private Map<String, ParamData> outputs;
    private Icon icon;
    private Icon iconLarge;
    private JobParams parameters;
    private String mimeType;
    private int category;
    private String folder;
    private boolean official;
    private List<Class<?>> dataTypes;
    private long groupID;

    private void populateDataTypes(List<Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        this.dataTypes = new ArrayList();
        for (Object object : values) {
            if (!(object instanceof String)) continue;
            String value = (String)object;
            value = value.toLowerCase();
            this.dataTypes.add(this.convertDataType(value));
        }
    }

    private void convertJobParameters() {
        Param p;
        if (this.parameters == null) {
            return;
        }
        String[] authors = this.parameters.authors;
        if (authors != null && authors.length > 0) {
            for (int i = 0; i < authors.length; ++i) {
                ExperimenterData exp = new ExperimenterData();
                exp.setLastName(authors[i]);
            }
        }
        Map map = this.parameters.inputs;
        this.inputs = new HashMap<String, ParamData>();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                p = (Param)entry.getValue();
                String key = (String)entry.getKey();
                ParamData param = new ParamData(p);
                this.inputs.put(key, param);
                if (!DATA_TYPE.equals(key)) continue;
                this.populateDataTypes(param.getValues());
            }
        }
        map = this.parameters.outputs;
        this.outputs = new HashMap<String, ParamData>();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                p = (Param)entry.getValue();
                this.outputs.put((String)entry.getKey(), new ParamData(p));
            }
        }
    }

    private void setCategory() {
        this.category = FIGURE_PATH.equals(this.path) ? 1 : (EXPORT_PATH.equals(this.path) ? 0 : (REGION_PATH.equals(this.path) ? 2 : (UTIL_PATH.equals(this.path) ? 3 : 5)));
    }

    public ScriptObject(long scriptID, String path, String name) {
        this.scriptID = scriptID;
        this.path = path;
        this.name = name;
        this.setCategory();
        this.description = "";
        this.journalRef = "";
        this.mimeType = null;
        this.official = true;
        this.groupID = -1L;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public boolean isOfficialScript() {
        return this.official;
    }

    public String getScriptLabel() {
        return UIUtilities.toUnix(this.path + this.name);
    }

    public String getPath() {
        return this.path;
    }

    public String getFolder() {
        if (CommonsLangUtils.isEmpty(this.folder)) {
            return this.getPath();
        }
        return File.separator + this.folder + File.separator + this.name;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setJobParams(JobParams parameters) {
        this.parameters = parameters;
        this.convertJobParameters();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJournalRef(String journalRef) {
        this.journalRef = journalRef;
    }

    public String[] getAuthors() {
        if (this.parameters != null) {
            return this.parameters.authors;
        }
        return null;
    }

    public String getDescription() {
        if (this.parameters != null) {
            return this.parameters.description;
        }
        return this.description;
    }

    public String getJournalRef() {
        return this.journalRef;
    }

    public long getScriptID() {
        return this.scriptID;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayedName() {
        int lastDotIndex = this.name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return this.name;
        }
        String value = this.name.substring(0, lastDotIndex);
        if (!value.contains(PARAMETER_SEPARATOR)) {
            return value;
        }
        return value.replace(PARAMETER_SEPARATOR, PARAMETER_UI_SEPARATOR);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setIconLarge(Icon icon) {
        this.iconLarge = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getIconLarge() {
        return this.iconLarge;
    }

    public String getContact() {
        if (this.parameters != null) {
            return this.parameters.contact;
        }
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getVersion() {
        if (this.parameters != null) {
            return this.parameters.version;
        }
        this.version = VERSION;
        return this.version;
    }

    public Map<String, ParamData> getInputs() {
        return this.inputs;
    }

    public Map<String, RType> getValueToPass() {
        HashMap<String, RType> map = new HashMap<String, RType>();
        if (this.inputs == null) {
            return map;
        }
        for (Map.Entry<String, ParamData> entry : this.inputs.entrySet()) {
            ParamData p = entry.getValue();
            RType type = p.getValueToPassAsRType();
            if (type == null) continue;
            map.put(entry.getKey(), type);
        }
        return map;
    }

    public boolean allRequiredValuesPopulated() {
        if (this.inputs == null) {
            return true;
        }
        for (Map.Entry<String, ParamData> entry : this.inputs.entrySet()) {
            RType type;
            ParamData p = entry.getValue();
            if (p.isOptional() || (type = p.getValueToPassAsRType()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isParametersLoaded() {
        return this.parameters != null;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getCategory() {
        return this.category;
    }

    public JobParams getParameters() {
        return this.parameters;
    }

    public List<Class<?>> getDataTypes() {
        return this.dataTypes;
    }

    public Class<?> convertDataType(String value) {
        if (value == null) {
            return null;
        }
        if (IMAGE_TYPE.equals(value = value.toLowerCase())) {
            return ImageData.class;
        }
        if (DATASET_TYPE.equals(value)) {
            return DatasetData.class;
        }
        if (PROJECT_TYPE.equals(value)) {
            return ProjectData.class;
        }
        if (SCREEN_TYPE.equals(value)) {
            return ScreenData.class;
        }
        if (PLATE_TYPE.equals(value)) {
            return PlateData.class;
        }
        return null;
    }

    public boolean isIdentifier(String key) {
        if (CommonsLangUtils.isBlank(key)) {
            return false;
        }
        key = key.trim().toLowerCase();
        return IDENTIFIER_KEYS.contains(key);
    }

    public boolean isDataType(String key) {
        return DATA_TYPE.equals(key);
    }

    public void setGroupID(long groupID) {
        this.groupID = groupID;
    }

    public long getGroupID() {
        return this.groupID;
    }

    public boolean isSupportedType(DataObject data) {
        return this.getDataTypes().contains(data.getClass());
    }

    public String toString() {
        return this.getScriptLabel();
    }

    static {
        IDENTIFIER_KEYS.add("id");
        IDENTIFIER_KEYS.add("ids");
        IDENTIFIER_KEYS.add("image_id");
    }
}

