/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TextualAnnotationData;

public class FilterContext {
    public static final int RATE = 0;
    public static final int TAG = 1;
    public static final int COMMENT = 2;
    public static final int MULTI = 3;
    public static final int NONE = 4;
    public static final int NAME = 5;
    public static final int ROI = 6;
    public static final int GREATER_EQUAL = 0;
    public static final int LOWER_EQUAL = 1;
    public static final int EQUAL = 2;
    public static final int UNION = 100;
    public static final int INTERSECTION = 101;
    private int rate = -1;
    private int rois = -1;
    private int rateIndex = -1;
    private int roiIndex = 0;
    private Map<Class, List<String>> annotationType = new HashMap<Class, List<String>>();
    private Timestamp fromDate;
    private Timestamp toDate;
    private int resultType = 101;
    private List<Integer> type = new ArrayList<Integer>();
    private List<String> names;
    private int timeType;

    public boolean isNameOnly() {
        int size = this.type.size();
        if (size > 1) {
            return false;
        }
        return this.type.contains(5);
    }

    public boolean isTagsOnly() {
        int size = this.type.size();
        if (size > 1) {
            return false;
        }
        return this.type.contains(1);
    }

    public int getContext() {
        int size = this.type.size();
        if (size == 0) {
            return 4;
        }
        if (size > 1) {
            return 3;
        }
        return this.type.get(0);
    }

    public List<Integer> getContextList() {
        return this.type;
    }

    public void setResultType(int type) {
        switch (type) {
            case 100: 
            case 101: {
                this.resultType = type;
                break;
            }
            default: {
                this.resultType = 101;
            }
        }
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setRate(int index, int rate) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.rateIndex = index;
                break;
            }
            default: {
                this.rateIndex = 0;
            }
        }
        this.rate = rate;
        this.type.add(0);
    }

    public void setRois(int index, int rois) {
        this.roiIndex = index;
        this.rois = rois;
        this.type.add(6);
    }

    public void setTimeInterval(Timestamp fromDate, Timestamp toDate) {
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            this.fromDate = toDate;
            this.toDate = fromDate;
        } else {
            this.fromDate = fromDate;
            this.toDate = toDate;
        }
    }

    public void setTimeType(int type) {
        this.timeType = type;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public Timestamp getFromDate() {
        return this.fromDate;
    }

    public Timestamp getToDate() {
        return this.toDate;
    }

    public int getRate() {
        return this.rate;
    }

    public int getROIs() {
        return this.rois;
    }

    public int getRateIndex() {
        return this.rateIndex;
    }

    public int getRoiIndex() {
        return this.roiIndex;
    }

    public Map<Class, List<String>> getAnnotationType() {
        return this.annotationType;
    }

    public List<String> getAnnotation(Class klass) {
        return this.annotationType.get(klass);
    }

    public void addAnnotationType(Class klass, List<String> terms) {
        if (klass != null && terms != null && terms.size() > 0) {
            if (klass.equals(TagAnnotationData.class)) {
                this.type.add(1);
            } else if (klass.equals(TextualAnnotationData.class)) {
                this.type.add(2);
            }
            this.annotationType.put(klass, terms);
        }
    }

    public void addName(List<String> terms) {
        if (terms == null || terms.size() == 0) {
            return;
        }
        this.type.add(5);
        this.names = terms;
    }

    public List<String> getNames() {
        return this.names;
    }
}

