/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorHandler;
import omero.cmd.CmdCallback;
import omero.gateway.model.DataObject;
import omero.gateway.model.FilesetData;
import omero.gateway.model.PixelsData;
import omero.gateway.util.PojoMapper;
import org.apache.commons.io.FileUtils;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class Status
implements IObserver {
    public static final String CANCELLED_PROPERTY = "markedAsCancelled";
    public static final String DUPLICATE_PROPERTY = "markedAsDuplicate";
    public static final String IMPORT_EVENT = "importEvenPassThrough";
    public static final String NO_CONTAINER_PROPERTY = "noContainer";
    public static final String FILES_SET_PROPERTY = "filesSet";
    public static final String FILE_RESET_PROPERTY = "fileReset";
    public static final String FILE_IMPORT_STARTED_PROPERTY = "fileImportStarted";
    public static final String CONTAINER_FROM_FOLDER_PROPERTY = "containerFromFolder";
    public static final String CANCELLABLE_IMPORT_PROPERTY = "cancellableImport";
    public static final String DEBUG_TEXT_PROPERTY = "debugText";
    public static final String IMPORT_DONE_PROPERTY = "importDone";
    public static final String UPLOAD_DONE_PROPERTY = "uploadDone";
    public static final String SCANNING_PROPERTY = "scanning";
    public static final String PROCESSING_ERROR_PROPERTY = "processingError";
    public static final String STEP_PROPERTY = "step";
    public static final Map<Integer, String> STEPS = new HashMap<Integer, String>();
    public static final Map<Integer, String> STEP_FAILURES;
    private ImportContainer ic;
    private int seriesCount;
    private boolean markedAsCancel;
    private boolean cancellable;
    private boolean markedAsDuplicate;
    private String fileSize;
    private String units;
    private long totalUploadedSize;
    private long sizeUpload;
    private ImportEvent.FILESET_UPLOAD_END checksumEvent;
    private ImportException exception;
    private Collection<PixelsData> pixels;
    private FilesetData fileset;
    private Object callback;
    private long logFileID;
    private int step;
    private boolean uploadStarted;
    private FileObject sourceFile;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    private String formatUpload(long value) {
        StringBuffer buffer = new StringBuffer();
        String v = FileUtils.byteCountToDisplaySize((long)value);
        String[] values = v.split(" ");
        if (values.length > 1) {
            String u = values[1];
            if (this.units.equals(u)) {
                buffer.append(values[0]);
            } else {
                buffer.append(v);
            }
        } else {
            buffer.append(v);
        }
        buffer.append("/");
        buffer.append(this.fileSize);
        return buffer.toString();
    }

    private void initialize() {
        this.step = 0;
        this.sizeUpload = 0L;
        this.fileSize = "";
        this.seriesCount = 0;
        this.markedAsCancel = false;
        this.cancellable = true;
        this.totalUploadedSize = 0L;
    }

    private void handleProcessingError(String text, boolean fire) {
        if (this.isMarkedAsCancel()) {
            return;
        }
        this.cancellable = false;
        this.firePropertyChange(PROCESSING_ERROR_PROPERTY, null, this);
    }

    public Status(FileObject sourceFile) {
        this.sourceFile = sourceFile;
        this.initialize();
    }

    public void setFilesetData(FilesetData fileset) {
        this.fileset = fileset;
    }

    public boolean isHCS() {
        if (this.ic == null) {
            return false;
        }
        Boolean b = this.ic.getIsSPW();
        if (b == null) {
            return false;
        }
        return b;
    }

    public FilesetData getFileset() {
        return this.fileset;
    }

    public void setUsedFiles(String[] usedFiles) {
        if (usedFiles == null) {
            return;
        }
        for (int i = 0; i < usedFiles.length; ++i) {
            this.sizeUpload += new File(usedFiles[i]).length();
        }
        this.fileSize = FileUtils.byteCountToDisplaySize((long)this.sizeUpload);
        String[] values = this.fileSize.split(" ");
        if (values.length > 1) {
            this.units = values[1];
        }
    }

    public void setCallback(Object cmd) {
        if (cmd instanceof ImportException) {
            this.exception = (ImportException)cmd;
        } else if (cmd instanceof CmdCallback || cmd instanceof Boolean) {
            this.callback = cmd;
        }
        this.firePropertyChange(UPLOAD_DONE_PROPERTY, null, this);
    }

    public void markedAsCancel() {
        this.markedAsCancel = true;
        this.firePropertyChange(CANCELLED_PROPERTY, null, CANCELLED_PROPERTY);
    }

    public boolean isMarkedAsCancel() {
        return this.markedAsCancel;
    }

    public void markedAsDuplicate() {
        this.markedAsDuplicate = true;
        this.firePropertyChange(DUPLICATE_PROPERTY, null, DUPLICATE_PROPERTY);
    }

    public boolean isMarkedAsDuplicate() {
        return this.markedAsDuplicate;
    }

    public String getErrorText() {
        return "";
    }

    public List<String> getChecksums() {
        if (!this.hasChecksum()) {
            return null;
        }
        return this.checksumEvent.checksums;
    }

    public Map<Integer, String> getFailingChecksums() {
        if (!this.hasChecksum()) {
            return null;
        }
        return this.checksumEvent.failingChecksums;
    }

    public String[] getChecksumFiles() {
        if (!this.hasChecksum()) {
            return null;
        }
        return this.checksumEvent.srcFiles;
    }

    public boolean hasChecksum() {
        return this.checksumEvent != null;
    }

    public void setFiles(Map<File, Status> files) {
        if (this.isMarkedAsCancel()) {
            return;
        }
        this.firePropertyChange(FILES_SET_PROPERTY, null, files);
    }

    public void setNoContainer() {
        this.firePropertyChange(NO_CONTAINER_PROPERTY, false, true);
    }

    public void setContainerFromFolder(DataObject container) {
        this.firePropertyChange(CONTAINER_FROM_FOLDER_PROPERTY, null, container);
    }

    public void resetFile(File file) {
        this.firePropertyChange(FILE_RESET_PROPERTY, null, file);
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public Object getImportResult() {
        if (this.exception != null) {
            return this.exception;
        }
        if (this.pixels != null) {
            return this.pixels;
        }
        return this.callback;
    }

    public int getNumberOfImportedFiles() {
        if (this.pixels != null) {
            return this.pixels.size();
        }
        return 0;
    }

    public long getSizeUpload() {
        return this.sizeUpload;
    }

    public long getLogFileID() {
        return this.logFileID;
    }

    public boolean didUploadStart() {
        return this.uploadStarted;
    }

    public ImportContainer getImportContainer() {
        return this.ic;
    }

    public void setImportContainer(ImportContainer ic) {
        this.ic = ic;
    }

    public void update(IObservable observable, ImportEvent event) {
        if (event == null) {
            return;
        }
        this.cancellable = false;
        if (event instanceof ImportEvent.IMPORT_DONE) {
            this.setStep(6);
            this.pixels = PojoMapper.convertToDataObjects((Collection)((ImportEvent.IMPORT_DONE)event).pixels);
            this.firePropertyChange(IMPORT_DONE_PROPERTY, null, this);
        } else if (event instanceof ImportCandidates.SCANNING) {
            if (!this.markedAsCancel) {
                this.cancellable = true;
            }
            if (this.exception == null) {
                this.firePropertyChange(SCANNING_PROPERTY, null, this);
            }
        } else if (event instanceof ErrorHandler.MISSING_LIBRARY) {
            this.exception = new ImportException("Missing library to decode the file.", ((ErrorHandler.MISSING_LIBRARY)event).exception);
            this.handleProcessingError("Missing library to decode the file.", false);
        } else if (event instanceof ErrorHandler.UNKNOWN_FORMAT) {
            this.exception = new ImportException("Unknown format", ((ErrorHandler.UNKNOWN_FORMAT)event).exception);
            if (this.sourceFile != null && !this.sourceFile.isDirectory()) {
                this.handleProcessingError("Unknown format", true);
            }
        } else if (event instanceof ErrorHandler.FILE_EXCEPTION) {
            ErrorHandler.FILE_EXCEPTION e = (ErrorHandler.FILE_EXCEPTION)event;
            this.exception = new ImportException(e.exception);
            String text = "File Not Valid";
            if (this.sourceFile != null && this.sourceFile.isDirectory()) {
                text = "";
            }
            this.handleProcessingError(text, false);
        } else if (event instanceof ErrorHandler.INTERNAL_EXCEPTION) {
            ErrorHandler.INTERNAL_EXCEPTION e = (ErrorHandler.INTERNAL_EXCEPTION)event;
            this.exception = new ImportException(e.exception);
            this.handleProcessingError("", true);
        } else if (event instanceof ImportEvent.FILE_UPLOAD_BYTES) {
            ImportEvent.FILE_UPLOAD_BYTES e = (ImportEvent.FILE_UPLOAD_BYTES)event;
            long v = this.totalUploadedSize + e.uploadedBytes;
            StringBuffer buffer = new StringBuffer();
            if (v != this.sizeUpload) {
                buffer.append(this.formatUpload(v));
            } else {
                buffer.append(this.fileSize);
            }
            buffer.append(" ");
            if (e.timeLeft != 0L) {
                String s = UIUtilities.calculateHMSFromMilliseconds(e.timeLeft, true);
                buffer.append(s);
                if (CommonsLangUtils.isNotBlank(s)) {
                    buffer.append(" Left");
                } else {
                    buffer.append("complete");
                }
            }
        } else if (event instanceof ImportEvent.FILE_UPLOAD_COMPLETE) {
            ImportEvent.FILE_UPLOAD_COMPLETE e = (ImportEvent.FILE_UPLOAD_COMPLETE)event;
            this.totalUploadedSize += e.uploadedBytes.longValue();
        } else if (event instanceof ImportEvent.FILESET_UPLOAD_END) {
            this.checksumEvent = (ImportEvent.FILESET_UPLOAD_END)event;
            if (this.exception == null) {
                this.setStep(1);
            }
        } else if (event instanceof ImportEvent.METADATA_IMPORTED) {
            this.setStep(2);
        } else if (event instanceof ImportEvent.PIXELDATA_PROCESSED) {
            this.setStep(3);
        } else if (event instanceof ImportEvent.THUMBNAILS_GENERATED) {
            this.setStep(4);
        } else if (event instanceof ImportEvent.METADATA_PROCESSED) {
            this.setStep(5);
        } else if (event instanceof ImportEvent.FILESET_UPLOAD_START) {
            this.uploadStarted = true;
            this.firePropertyChange(FILE_IMPORT_STARTED_PROPERTY, null, this);
        } else if (event instanceof ImportEvent.IMPORT_STARTED) {
            ImportEvent.IMPORT_STARTED e = (ImportEvent.IMPORT_STARTED)event;
            if (e.logFileId != null) {
                this.logFileID = e.logFileId;
            }
        } else if (event instanceof ImportEvent.POST_UPLOAD_EVENT) {
            ImportEvent.POST_UPLOAD_EVENT e = (ImportEvent.POST_UPLOAD_EVENT)event;
            this.ic = e.container;
        }
        this.firePropertyChange(IMPORT_EVENT, null, event);
    }

    public void setStep(int step) {
        int old = this.step;
        this.step = step;
        int id = this.sourceFile.hashCode();
        this.firePropertyChange(STEP_PROPERTY, id + "_" + old, id + "_" + this.step);
    }

    public String getUnits() {
        return this.units;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public int getStep() {
        return this.step;
    }

    public long getTotalUploadedSize() {
        return this.totalUploadedSize;
    }

    static {
        STEPS.put(1, "Importing Metadata");
        STEPS.put(2, "Reading Pixels");
        STEPS.put(3, "Generating Thumbnails");
        STEPS.put(4, "Reading Metadata");
        STEPS.put(5, "Generating Objects");
        STEPS.put(6, "Complete");
        STEP_FAILURES = new HashMap<Integer, String>();
        STEP_FAILURES.put(1, "Failed to Import Metadata");
        STEP_FAILURES.put(2, "Failed to Read Pixels");
        STEP_FAILURES.put(3, "Failed to Generate Thumbnails");
        STEP_FAILURES.put(4, "Failed to Read Metadata");
        STEP_FAILURES.put(5, "Failed to Generate Objects");
    }
}

