/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.events.DSCallOutcomeEvent;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.util.concur.tasks.ExecMonitor;

class BatchCallMonitor
implements ExecMonitor {
    private BatchCallTree tree;
    private AgentEventListener adaptee;

    BatchCallMonitor(BatchCallTree tree, AgentEventListener observer) {
        if (tree == null) {
            throw new NullPointerException("No tree.");
        }
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.tree = tree;
        this.adaptee = observer;
    }

    protected void deliver(final AgentEvent ae) {
        Runnable notification = new Runnable(){

            @Override
            public void run() {
                BatchCallMonitor.this.adaptee.eventFired(ae);
            }
        };
        SwingUtilities.invokeLater(notification);
    }

    @Override
    public void onStart() {
        this.update(0);
    }

    @Override
    public void update(int step) {
        int calls = this.tree.countCalls();
        int perc = 0 < calls ? step * 100 / calls : -1;
        BatchCall curCall = this.tree.getCurCall();
        DSCallFeedbackEvent feedback = curCall != null ? new DSCallFeedbackEvent(perc, curCall.getDescription(), this.tree.getPartialResult()) : new DSCallFeedbackEvent(100, null, this.tree.getPartialResult());
        this.deliver(feedback);
    }

    @Override
    public void onCancel() {
        DSCallOutcomeEvent cancelEvent = new DSCallOutcomeEvent();
        this.deliver(cancelEvent);
    }

    @Override
    public void onAbort(Throwable cause) {
        DSCallOutcomeEvent errorEvent = new DSCallOutcomeEvent(cause);
        this.deliver(errorEvent);
    }

    @Override
    public void onEnd(Object result) {
        Object finalResult = this.tree.getResult();
        DSCallOutcomeEvent resultEvent = new DSCallOutcomeEvent(finalResult);
        this.deliver(resultEvent);
    }
}

