/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.PixelsData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.roi.ROIAnalyser;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class Analyser
extends BatchCallTree {
    private final PixelsData pixels;
    private final Collection channels;
    private Object result;
    private BatchCall loadCall;
    private Coord3D plane;

    private BatchCall analyseShapes(final SecurityContext ctx, final ROIShape[] shapes) {
        return new BatchCall("Analysing shapes"){

            @Override
            public void doCall() throws Exception {
                ROIAnalyser analyser = new ROIAnalyser(Analyser.this.context.getGateway(), Analyser.this.pixels);
                try {
                    Analyser.this.result = analyser.analyze(ctx, shapes, Analyser.this.channels, Analyser.this.plane);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public Analyser(SecurityContext ctx, PixelsData pixels, Collection channels, List shapes, Coord3D plane) {
        if (pixels == null) {
            throw new IllegalArgumentException("No Pixels specified.");
        }
        if (channels == null || channels.size() == 0) {
            throw new IllegalArgumentException("No channels specified.");
        }
        if (shapes == null || shapes.size() == 0) {
            throw new IllegalArgumentException("No shapes specified.");
        }
        this.pixels = pixels;
        this.channels = channels;
        this.plane = plane;
        Iterator i = shapes.iterator();
        ROIShape[] data = new ROIShape[shapes.size()];
        int index = 0;
        while (i.hasNext()) {
            data[index] = (ROIShape)i.next();
            ++index;
        }
        this.loadCall = this.analyseShapes(ctx, data);
    }
}

