/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.util.file.IOUtil;

public class ArchivedImageLoader
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;
    private boolean override;
    private boolean zip = true;
    private boolean keepOriginalPaths = false;

    private File copyFile(File f, File folder) throws Exception {
        File[] files = folder.listFiles();
        int count = 0;
        String fname = f.getName();
        String extension = FilenameUtils.getExtension((String)fname);
        String baseName = FilenameUtils.getBaseName((String)FilenameUtils.removeExtension((String)fname));
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String v = files[i].getName();
                String value = baseName + "_(" + count + ")." + extension;
                if (!v.equals(fname) && !v.equals(value)) continue;
                ++count;
            }
        }
        if (count > 0) {
            if (this.override) {
                File to = new File(folder, f.getName());
                to.delete();
            } else {
                File to = new File(f.getParentFile(), baseName + "_(" + count + ")." + extension);
                FileUtils.copyFile((File)f, (File)to);
                f = to;
            }
        }
        FileUtils.moveFileToDirectory((File)f, (File)folder, (boolean)false);
        return new File(folder, f.getName());
    }

    private BatchCall makeBatchCall(final SecurityContext ctx, final List<DataObject> objects, final File folder) {
        return new BatchCall("Download the files. "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = ArchivedImageLoader.this.context.getDataService();
                ArrayList<Long> imageIDs = new ArrayList<Long>();
                if (objects.get(0) instanceof ImageData) {
                    for (Object obj : objects) {
                        imageIDs.add(obj.getId());
                    }
                }
                if (objects.get(0) instanceof PlateData) {
                    ArrayList<Long> filesetIds = new ArrayList<Long>();
                    for (Object obj : objects) {
                        Collection wells = os.loadPlateWells(ctx, obj.getId(), -1L, ArchivedImageLoader.this.context.getGateway().getLoggedInUser().getId());
                        for (Object well : wells) {
                            for (WellSampleData ws : ((WellData)well).getWellSamples()) {
                                if (filesetIds.contains(ws.getImage().getFilesetId())) continue;
                                filesetIds.add(ws.getImage().getFilesetId());
                                imageIDs.add(ws.getImage().getId());
                            }
                        }
                    }
                }
                File tmpFolder = null;
                try {
                    tmpFolder = ArchivedImageLoader.this.zip ? Files.createTempDir() : folder;
                    ArrayList files = new ArrayList();
                    for (Long imageID : imageIDs) {
                        Map<Boolean, Object> r = os.getArchivedImage(ctx, tmpFolder, imageID, ArchivedImageLoader.this.keepOriginalPaths);
                        files.addAll((List)r.get(Boolean.TRUE));
                    }
                    ArchivedImageLoader.this.result = new HashMap();
                    if (CollectionUtils.isEmpty(files)) {
                        return;
                    }
                    if (ArchivedImageLoader.this.zip) {
                        File f = IOUtil.zipDirectory(tmpFolder, false);
                        String baseName = FilenameUtils.getBaseName((String)FilenameUtils.removeExtension((String)folder.getName()));
                        File to = new File(f.getParentFile(), baseName + "." + FilenameUtils.getExtension((String)f.getName()));
                        Files.move((File)f, (File)to);
                        f = ArchivedImageLoader.this.copyFile(to, folder.getParentFile());
                        ((Map)ArchivedImageLoader.this.result).put(Boolean.TRUE, Arrays.asList(f));
                    } else {
                        ((Map)ArchivedImageLoader.this.result).put(Boolean.TRUE, files);
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
                finally {
                    if (ArchivedImageLoader.this.zip && tmpFolder != null) {
                        FileUtils.deleteDirectory((File)tmpFolder);
                    }
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ArchivedImageLoader(SecurityContext ctx, List<DataObject> objects, File folderPath, boolean override) {
        if (CollectionUtils.isEmpty(objects)) {
            throw new IllegalArgumentException("No objects provided.");
        }
        this.override = override;
        this.loadCall = this.makeBatchCall(ctx, objects, folderPath);
    }

    public ArchivedImageLoader(SecurityContext ctx, List<DataObject> objects, File folderPath, boolean override, boolean zip, boolean keepOriginalPaths) {
        if (CollectionUtils.isEmpty(objects)) {
            throw new IllegalArgumentException("No objects provided.");
        }
        this.override = override;
        this.zip = zip;
        this.keepOriginalPaths = keepOriginalPaths;
        this.loadCall = this.makeBatchCall(ctx, objects, folderPath);
    }
}

