/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class DMRefreshLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private void retrieveData(Class rootNodeType, Map<SecurityContext, List> nodes, Map<SecurityContext, Object> mapResult) throws Exception {
        OmeroDataService os = this.context.getDataService();
        for (Map.Entry<SecurityContext, List> entry : nodes.entrySet()) {
            Object result;
            SecurityContext ctx = entry.getKey();
            long userID = ctx.getExperimenter();
            List containers = entry.getValue();
            if (CollectionUtils.isEmpty((Collection)containers)) {
                result = os.loadContainerHierarchy(ctx, rootNodeType, null, false, ctx.getExperimenter());
                if (mapResult.containsKey(ctx)) {
                    Collection s = (Collection)mapResult.get(userID);
                    s.addAll(result);
                    continue;
                }
                mapResult.put(ctx, result);
                continue;
            }
            HashMap<TimeRefObject, Object> topNodes = new HashMap<TimeRefObject, Object>();
            Iterator i = containers.iterator();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof TimeRefObject) {
                    TimeRefObject ref = (TimeRefObject)object;
                    if (ref.getFileType() == 100) {
                        ref.setResults(os.getExperimenterImages(ctx, userID, true));
                    }
                    topNodes.put(ref, ref);
                    continue;
                }
                ids.add(((DataObject)object).getId());
            }
            Collection<DataObject> set = os.loadContainerHierarchy(ctx, rootNodeType, null, false, userID);
            Iterator<DataObject> j = set.iterator();
            HashSet<DataObject> children = null;
            Class<DatasetData> klass = null;
            while (j.hasNext()) {
                HashSet<DataObject> newChildren = new HashSet<DataObject>();
                DataObject parent = j.next();
                if (parent instanceof ProjectData) {
                    children = ((ProjectData)parent).getDatasets();
                    klass = DatasetData.class;
                } else if (parent instanceof ScreenData) {
                    children = null;
                    klass = ScreenData.class;
                } else if (parent instanceof DatasetData) {
                    children = new HashSet<DataObject>(1);
                    children.add(parent);
                    klass = DatasetData.class;
                }
                topNodes.put((TimeRefObject)parent, newChildren);
                if (children == null) continue;
                for (DataObject child : children) {
                    Long id = child.getId();
                    if (ids.contains(id)) {
                        Collection<DataObject> r = os.loadContainerHierarchy(ctx, klass, Arrays.asList(id), true, userID);
                        Iterator<DataObject> k = r.iterator();
                        while (k.hasNext()) {
                            newChildren.add(k.next());
                        }
                        continue;
                    }
                    newChildren.add(child);
                }
            }
            result = topNodes;
            if (mapResult.containsKey(ctx)) {
                Map map = (Map)mapResult.get(userID);
                map.putAll((Map)result);
                continue;
            }
            mapResult.put(ctx, result);
        }
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final Map<SecurityContext, List> nodes) {
        return new BatchCall("Loading container tree: "){

            @Override
            public void doCall() throws Exception {
                HashMap r = new HashMap(nodes.size());
                DMRefreshLoader.this.results = r;
                DMRefreshLoader.this.retrieveData(rootNodeType, nodes, r);
            }
        };
    }

    private BatchCall makeImagesBatchCall(final Map<SecurityContext, List> nodes) {
        return new BatchCall("Loading images: "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = DMRefreshLoader.this.context.getDataService();
                for (Map.Entry entry : nodes.entrySet()) {
                    SecurityContext ctx = (SecurityContext)entry.getKey();
                    long userID = ctx.getExperimenter();
                    List containers = (List)entry.getValue();
                    for (TimeRefObject ref : containers) {
                        ref.setResults(os.getImagesPeriod(ctx, ref.getStartTime(), ref.getEndTime(), userID, true));
                    }
                }
                DMRefreshLoader.this.results = nodes;
            }
        };
    }

    private Collection getAllGroups() {
        return (Collection)this.context.lookup("/userGroup/details");
    }

    public Set getGroupsLeaderOf() {
        HashSet<GroupData> values = new HashSet<GroupData>();
        Collection groups = this.getAllGroups();
        Iterator i = groups.iterator();
        ExperimenterData exp2 = (ExperimenterData)this.context.lookup("/current_user/details");
        long id = exp2.getId();
        block0: while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            Set leaders = g.getLeaders();
            if (leaders == null || leaders.size() <= 0) continue;
            for (ExperimenterData exp2 : leaders) {
                if (exp2.getId() != id) continue;
                values.add(g);
                continue block0;
            }
        }
        return values;
    }

    private BatchCall makeGroupsBatchCall(final Map<SecurityContext, List> nodes) {
        return new BatchCall("Loading groups: "){

            @Override
            public void doCall() throws Exception {
                AdminService svc = DMRefreshLoader.this.context.getAdminService();
                Boolean admin = (Boolean)DMRefreshLoader.this.context.lookup("/users/administrator");
                if (admin != null && admin.booleanValue()) {
                    for (Map.Entry e : nodes.entrySet()) {
                        SecurityContext ctx = (SecurityContext)e.getKey();
                        List<GroupData> groups = svc.loadGroups(ctx, -1L);
                        ArrayList<GroupData> r = new ArrayList<GroupData>();
                        ArrayList<Long> toRemove = new ArrayList<Long>();
                        List list = (List)e.getValue();
                        Iterator j = list.iterator();
                        while (j.hasNext()) {
                            long groupID = (Long)j.next();
                            List<GroupData> l = svc.loadGroups(ctx, groupID);
                            toRemove.add(groupID);
                            if (l.size() != 1) continue;
                            r.add(l.get(0));
                        }
                        for (GroupData g : groups) {
                            if (toRemove.contains(g.getId())) continue;
                            r.add(g);
                        }
                        DMRefreshLoader.this.results = r;
                    }
                } else {
                    Collection allgroups = DMRefreshLoader.this.getAllGroups();
                    Set groups = DMRefreshLoader.this.getGroupsLeaderOf();
                    Iterator i = groups.iterator();
                    ArrayList<GroupData> l = new ArrayList<GroupData>();
                    while (i.hasNext()) {
                        GroupData group = (GroupData)i.next();
                        SecurityContext ctx = new SecurityContext(group.getId());
                        l.addAll(svc.loadGroups(ctx, group.getId()));
                        allgroups.remove(group);
                    }
                    ArrayList<GroupData> all = new ArrayList<GroupData>();
                    all.addAll(l);
                    all.addAll(allgroups);
                    DMRefreshLoader.this.context.bind("/userGroup/details", all);
                    List agents = (List)DMRefreshLoader.this.context.lookup("/agents");
                    for (AgentInfo agentInfo : agents) {
                        if (!agentInfo.isActive()) continue;
                        Registry reg = agentInfo.getRegistry();
                        reg.bind("/userGroup/details", all);
                    }
                    DMRefreshLoader.this.results = l;
                }
            }
        };
    }

    private BatchCall makeFilesBatchCall(final Map<SecurityContext, List> nodes) {
        return new BatchCall("Loading files: "){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = DMRefreshLoader.this.context.getMetadataService();
                for (Map.Entry entry : nodes.entrySet()) {
                    SecurityContext ctx = (SecurityContext)entry.getKey();
                    long userID = ctx.getExperimenter();
                    List containers = (List)entry.getValue();
                    for (TimeRefObject ref : containers) {
                        ref.setResults(os.loadFiles(ctx, ref.getFileType(), userID));
                    }
                }
                DMRefreshLoader.this.results = nodes;
            }
        };
    }

    private BatchCall makeTagsBatchCall(final Map<SecurityContext, List> nodes) {
        return new BatchCall("Loading files: "){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = DMRefreshLoader.this.context.getMetadataService();
                OmeroDataService ds = DMRefreshLoader.this.context.getDataService();
                HashMap<SecurityContext, Collection> r = new HashMap<SecurityContext, Collection>(nodes.size());
                for (Map.Entry entry : nodes.entrySet()) {
                    SecurityContext ctx = (SecurityContext)entry.getKey();
                    long userID = ctx.getExperimenter();
                    List l = (List)entry.getValue();
                    Collection tags = os.loadTags(ctx, -1L, true, userID, ctx.getGroupID());
                    ArrayList<TimeRefObject> tagResults = new ArrayList<TimeRefObject>();
                    HashMap<DataObject, Collection<DataObject>> mapForDataObject = new HashMap<DataObject, Collection<DataObject>>();
                    if (CollectionUtils.isEmpty((Collection)l)) {
                        r.put(ctx, tags);
                        continue;
                    }
                    HashMap<Long, Collection> values = new HashMap<Long, Collection>();
                    Iterator k = l.iterator();
                    ArrayList refTags = new ArrayList();
                    while (k.hasNext()) {
                        Object ob = k.next();
                        if (ob instanceof TagAnnotationData) {
                            TagAnnotationData tag = (TagAnnotationData)ob;
                            values.put(tag.getId(), os.loadTags(ctx, tag.getId(), false, userID, ctx.getGroupID()));
                            continue;
                        }
                        if (ob instanceof TimeRefObject) {
                            TimeRefObject ref = (TimeRefObject)ob;
                            ref.setResults(os.loadFiles(ctx, ref.getFileType(), userID));
                            refTags.addAll(ref.getResults());
                            tagResults.add(ref);
                            continue;
                        }
                        if (!(ob instanceof DataObject)) continue;
                        DataObject ho = (DataObject)ob;
                        mapForDataObject.put(ho, ds.loadContainerHierarchy(ctx, ob.getClass(), Arrays.asList(ho.getId()), true, userID));
                    }
                    DMRefreshLoader.this.handleTags(tags, tagResults, values, mapForDataObject);
                    if (refTags.size() > 0) {
                        DMRefreshLoader.this.handleTags(refTags, null, values, mapForDataObject);
                    }
                    r.put(ctx, tagResults);
                }
                DMRefreshLoader.this.results = r;
            }
        };
    }

    private void handleTags(Collection<TagAnnotationData> tags, List<Object> tagResults, Map<Long, Collection<?>> values, Map<DataObject, Collection<?>> mapForDataObject) {
        for (TagAnnotationData tag : tags) {
            String ns;
            if (tagResults != null) {
                tagResults.add(tag);
            }
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns = tag.getNameSpace())) {
                Set set = tag.getTags();
                for (TagAnnotationData child : set) {
                    if (!values.containsKey(child.getId())) continue;
                    this.populateTag(child, values, mapForDataObject);
                }
                continue;
            }
            if (!values.containsKey(tag.getId())) continue;
            this.populateTag(tag, values, mapForDataObject);
        }
    }

    private void populateTag(TagAnnotationData tag, Map<Long, Collection<?>> values, Map<DataObject, Collection<?>> mapForDataObject) {
        if (mapForDataObject.isEmpty()) {
            HashSet objs = new HashSet();
            objs.addAll(values.get(tag.getId()));
            tag.setDataObjects(objs);
        } else {
            Collection<?> objects = values.get(tag.getId());
            HashSet<DataObject> newList = new HashSet<DataObject>(objects.size());
            Iterator<?> kk = objects.iterator();
            while (kk.hasNext()) {
                newList.add(this.getLoadedObject(mapForDataObject, (DataObject)kk.next()));
            }
            tag.setDataObjects(newList);
        }
    }

    private DataObject getLoadedObject(Map<DataObject, Collection<?>> map, DataObject ho) {
        Set<DataObject> sets = map.keySet();
        for (DataObject object : sets) {
            Collection<?> s;
            if (object.getClass().equals(ho.getClass()) && object.getId() == ho.getId()) {
                s = map.get(object);
                return (DataObject)s.iterator().next();
            }
            if (!(ho instanceof ProjectData)) continue;
            ProjectData p = (ProjectData)ho;
            Set datasets = p.getDatasets();
            Iterator j = datasets.iterator();
            HashSet<DatasetData> loaded = new HashSet<DatasetData>();
            boolean modified = false;
            while (j.hasNext()) {
                DataObject data = (DataObject)j.next();
                if (object.getClass().equals(data.getClass()) && object.getId() == data.getId()) {
                    s = map.get(object);
                    loaded.add((DatasetData)s.iterator().next());
                    modified = true;
                    continue;
                }
                loaded.add((DatasetData)data);
            }
            if (!modified) continue;
            p.setDatasets(loaded);
            return p;
        }
        return ho;
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public DMRefreshLoader(Class rootNodeType, Map<SecurityContext, List> nodes) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No container with images.");
        }
        if (ImageData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeImagesBatchCall(nodes);
        } else if (ProjectData.class.equals((Object)rootNodeType) || ScreenData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeBatchCall(rootNodeType, nodes);
        } else if (FileAnnotationData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeFilesBatchCall(nodes);
        } else if (TagAnnotationData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeTagsBatchCall(nodes);
        } else if (GroupData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeGroupsBatchCall(nodes);
        }
    }
}

