/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ExistingObjectsSaver
extends BatchCallTree {
    private BatchCall call;
    private Object result;
    private SecurityContext ctx;

    private BatchCall makeBatchCall(final Collection parent, final Collection children, boolean admin) {
        return new BatchCall("Loading container tree: "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = ExistingObjectsSaver.this.context.getDataService();
                for (Object obj : parent) {
                    if (!(obj instanceof DataObject)) continue;
                    os.addExistingObjects(ExistingObjectsSaver.this.ctx, (DataObject)obj, children);
                }
                ExistingObjectsSaver.this.result = parent;
            }
        };
    }

    private BatchCall makeBatchCall(final Map toPaste) {
        return new BatchCall("Copy and paste: "){

            @Override
            public void doCall() throws Exception {
                AdminService as = ExistingObjectsSaver.this.context.getAdminService();
                OmeroDataService os = ExistingObjectsSaver.this.context.getDataService();
                for (Map.Entry entry : toPaste.entrySet()) {
                    Object p = entry.getKey();
                    if (p instanceof GroupData) {
                        as.copyExperimenters(ExistingObjectsSaver.this.ctx, (GroupData)p, (Collection)entry.getValue());
                        continue;
                    }
                    if (!(p instanceof DataObject)) continue;
                    os.addExistingObjects(ExistingObjectsSaver.this.ctx, (DataObject)p, (Collection)entry.getValue());
                }
                ExistingObjectsSaver.this.result = toPaste;
            }
        };
    }

    private BatchCall makeBatchCall(final Map toPaste, final Map toRemove, final boolean admin) {
        return new BatchCall("Cut and paste: "){

            @Override
            public void doCall() throws Exception {
                if (admin) {
                    AdminService as = ExistingObjectsSaver.this.context.getAdminService();
                    as.cutAndPasteExperimenters(ExistingObjectsSaver.this.ctx, toPaste, toRemove);
                    ExistingObjectsSaver.this.result = toPaste;
                } else {
                    OmeroDataService os = ExistingObjectsSaver.this.context.getDataService();
                    os.cutAndPaste(ExistingObjectsSaver.this.ctx, toPaste, toRemove);
                    ExistingObjectsSaver.this.result = toPaste;
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.call);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ExistingObjectsSaver(SecurityContext ctx, Collection parent, Collection children, boolean admin) {
        if (children == null || children.size() == 0) {
            throw new IllegalArgumentException("No item to add.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent to update.");
        }
        this.ctx = ctx;
        this.call = this.makeBatchCall(parent, children, admin);
    }

    public ExistingObjectsSaver(SecurityContext ctx, Map toPaste, Map toRemove, boolean admin) {
        this.ctx = ctx;
        if (toPaste == null) {
            toPaste = new HashMap();
        }
        this.call = toRemove == null ? this.makeBatchCall(toPaste) : this.makeBatchCall(toPaste, toRemove, admin);
    }
}

