/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ImagesImporter
extends BatchCallTree {
    private Map<ImportableFile, Object> partialResult;
    private ImportableObject object;

    private void importFile(ImportableFile importable, boolean close) {
        this.partialResult = new HashMap<ImportableFile, Object>();
        OmeroImageService os = this.context.getImageService();
        try {
            this.partialResult.put(importable, os.importFile(this.object, importable, close));
        }
        catch (Exception e) {
            this.partialResult.put(importable, e);
        }
    }

    @Override
    protected void buildTree() {
        List<ImportableFile> files = this.object.getFiles();
        Iterator<ImportableFile> i = files.iterator();
        int index = 0;
        int n = files.size() - 1;
        while (i.hasNext()) {
            ImportableFile io;
            final ImportableFile f = io = i.next();
            final boolean b = index == n;
            ++index;
            this.add(new BatchCall("Importing file"){

                @Override
                public void doCall() {
                    ImagesImporter.this.importFile(f, b);
                }
            });
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.partialResult;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ImagesImporter(ImportableObject object) {
        if (object == null || CollectionUtils.isEmpty(object.getFiles())) {
            throw new IllegalArgumentException("No Files to import.");
        }
        this.object = object;
    }
}

