/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import ij.IJ;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.PluginInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;

public final class ContainerConfigInit
extends InitializationTask {
    private static final String FIJI = "fiji";
    private static final String IMAGE_J2 = "imagej2";

    private boolean handlePluginDependencies(PluginInfo info) {
        int count;
        String[] values;
        block10: {
            values = info.getDependenciesAsArray();
            if (values == null || values.length == 0) {
                return true;
            }
            count = 0;
            try {
                File parent = new File(this.container.getHomeDir());
                File pp = parent.getParentFile();
                if (pp == null) {
                    pp = parent;
                }
                File dir = pp.getName().equals(info.getDirectory()) ? pp : new File(pp, info.getDirectory());
                File[] l = dir.listFiles();
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    if (value != null) {
                        value = value.trim();
                    }
                    if (l == null) continue;
                    value = FilenameUtils.removeExtension((String)value);
                    for (int i = 0; i < l.length; ++i) {
                        if (!l[i].getName().startsWith(value)) continue;
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                if (info.getId() != 1 && info.getId() != 3 || !IJ.debugMode) break block10;
                String msg = "An error occurred while checking if the dependencies are installed." + e.toString();
                IJ.log((String)msg);
            }
        }
        switch (info.getConjunction()) {
            case 1: {
                return values.length == count;
            }
        }
        return count > 0;
    }

    @Override
    String getName() {
        return "Loading Container configuration";
    }

    @Override
    void configure() {
    }

    @Override
    void execute() throws StartupException {
        String file = this.container.getConfigFileRelative();
        Registry reg = this.container.getRegistry();
        try {
            File files;
            RegistryFactory.fillFromFile(file, reg);
            String name = (String)reg.lookup("/services/OMERO/home");
            String omeroDir = System.getProperty("user.home") + File.separator + name;
            reg.bind("/user/home/omero", omeroDir);
            String tmp = (String)reg.lookup("/services/OMERO/files/home");
            File home = new File(omeroDir);
            if (!home.exists()) {
                home.mkdir();
            }
            if (!(files = home.isDirectory() ? new File(home, tmp) : new File(this.container.getHomeDir(), tmp)).exists()) {
                files.mkdir();
                files.deleteOnExit();
            }
            List infos = (List)reg.lookup("/plugins");
            Integer v = (Integer)reg.lookup("Plugin");
            if (infos == null || infos.size() == 0 || v == null || v < 0) {
                return;
            }
            boolean b = false;
            Iterator i = infos.iterator();
            switch (v) {
                case 1: 
                case 3: {
                    String title = IJ.getInstance().getTitle();
                    title = title.toLowerCase();
                    if (title != null && (title.contains(FIJI) || title.equals(IMAGE_J2))) break;
                    while (i.hasNext()) {
                        PluginInfo info = (PluginInfo)i.next();
                        b = this.handlePluginDependencies(info);
                        if (b) continue;
                        StartupException ex = new StartupException("OMERO.insight as ImageJ plugin");
                        ex.setPluginInfo(info);
                        throw ex;
                    }
                    break;
                }
            }
        }
        catch (ConfigException ce) {
            throw new StartupException("Unable to load Container configuration", ce);
        }
    }

    @Override
    void rollback() {
    }
}

