/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.LoginConfig;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.init.InitializationListener;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public final class SplashScreenInit
extends InitializationTask
implements InitializationListener {
    private SplashScreen splashScreen;
    private int totalTasks;

    SplashScreenInit() {
    }

    @Override
    String getName() {
        return "";
    }

    @Override
    void configure() {
        this.initializer.register(this);
    }

    @Override
    void execute() throws StartupException {
        this.splashScreen = UIFactory.makeSplashScreen(this.container);
        this.splashScreen.open();
        this.splashScreen.setTotalTasks(this.totalTasks);
    }

    @Override
    void rollback() {
    }

    @Override
    public void onStart(int totalTasks) {
        this.totalTasks = totalTasks;
    }

    @Override
    public void onExecute(String taskName) {
        if (this.splashScreen != null) {
            this.splashScreen.updateProgress(taskName);
        }
    }

    @Override
    public void onEnd() {
        this.splashScreen.updateProgress("");
        Registry reg = this.container.getRegistry();
        boolean b = false;
        Integer v = (Integer)reg.lookup("/application/entryPoint");
        if (v != null) {
            boolean bl = b = v == 0 || v == 2;
        }
        if (!b) {
            this.splashScreen.close();
            return;
        }
        LoginConfig cfg = new LoginConfig(reg);
        int max = cfg.getMaxRetry();
        LoginService loginSvc = (LoginService)reg.lookup("/services/Login");
        int index = max;
        UserNotifier un = UIFactory.makeUserNotifier(this.container);
        while (0 < max--) {
            UserCredentials uc = this.splashScreen.getUserCredentials(max == index - 1);
            reg.bind("/user/credentials", uc);
            switch (loginSvc.login(uc)) {
                case 1: {
                    max = 0;
                    break;
                }
                case 2: {
                    loginSvc.notifyLoginTimeout();
                    break;
                }
                case 0: {
                    if (max != 0) {
                        loginSvc.notifyLoginFailure();
                        this.splashScreen.onLoginFailure();
                        break;
                    }
                    if (max != 0) break;
                    un.notifyError("Login Failure", "A valid connection to the OMERO server could not be established. \nThe application will exit.");
                    this.container.exit();
                }
            }
        }
        this.splashScreen.close();
    }
}

