/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.log;

import java.io.File;
import omero.log.LogMessage;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.LoggerImpl;
import org.openmicroscopy.shoola.env.log.PluginLoggerImpl;

public class LoggerFactory {
    private static final String LOG_CONFIG_FILE = "logback.xml";

    public static Logger makeNew(Container c) {
        File logFile;
        if (c == null) {
            return null;
        }
        Registry reg = c.getRegistry();
        Boolean isLoggingOn = (Boolean)reg.lookup("/services/LOG/on");
        if (!isLoggingOn.booleanValue()) {
            return LoggerFactory.makeNoOpLogger();
        }
        String relPathName = c.getConfigFileRelative(LOG_CONFIG_FILE);
        File configFile = new File(relPathName);
        if (!configFile.exists() || !configFile.isFile()) {
            return LoggerFactory.makeNoOpLogger();
        }
        String logDirName = (String)reg.lookup("/services/LOG/dir");
        String logFileName = (String)reg.lookup("/services/LOG/file");
        String name = (String)reg.lookup("/services/OMERO/home");
        String omeroDir = System.getProperty("user.home") + File.separator + name;
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        if (home.isDirectory()) {
            File logDir = new File(home, logDirName);
            logDir.mkdir();
            logFile = logDir.isDirectory() ? new File(logDir, logFileName) : new File(home, logFileName);
        } else {
            File logDir = new File(c.getHomeDir(), logDirName);
            logDir.mkdir();
            logFile = logDir.isDirectory() ? new File(logDir, logFileName) : new File(c.getHomeDir(), logFileName);
        }
        Integer v = (Integer)reg.lookup("Plugin");
        int value = -1;
        if (v != null) {
            value = v;
        }
        if (value < 0) {
            return new LoggerImpl(relPathName, logFile.getAbsolutePath());
        }
        return new PluginLoggerImpl(value);
    }

    private static Logger makeNoOpLogger() {
        return new Logger(){

            public void debug(Object c, String logMsg) {
            }

            public void debug(Object c, LogMessage msg) {
            }

            public void error(Object c, String logMsg) {
            }

            public void error(Object c, LogMessage msg) {
            }

            public void fatal(Object c, String logMsg) {
            }

            public void fatal(Object c, LogMessage msg) {
            }

            public void info(Object c, String logMsg) {
            }

            public void info(Object c, LogMessage msg) {
            }

            public void warn(Object c, String logMsg) {
            }

            public void warn(Object c, LogMessage msg) {
            }

            public String getLogFile() {
                return null;
            }
        };
    }
}

