/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import omero.log.LogMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggerImpl
implements omero.log.Logger {
    private static final String LOG_FILE_NAME = "logFileName";
    private String absFile;

    private Logger getAdaptee(Object target) {
        if (target != null) {
            return LoggerFactory.getLogger(target.getClass());
        }
        return LoggerFactory.getLogger((String)"ROOT");
    }

    LoggerImpl(String configFile, String absFile) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            context.putProperty(LOG_FILE_NAME, absFile);
            configurator.doConfigure(configFile);
        }
        catch (JoranException je) {
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
    }

    public void debug(Object c, String logMsg) {
        this.getAdaptee(c).debug(logMsg);
    }

    public void debug(Object c, LogMessage msg) {
        this.getAdaptee(c).debug(msg == null ? null : msg.toString());
    }

    public void error(Object c, String logMsg) {
        this.getAdaptee(c).error(logMsg);
    }

    public void error(Object c, LogMessage msg) {
        this.getAdaptee(c).error(msg == null ? null : msg.toString());
    }

    public void fatal(Object c, String logMsg) {
        this.getAdaptee(c).error(logMsg);
    }

    public void fatal(Object c, LogMessage msg) {
        this.getAdaptee(c).error(msg == null ? null : msg.toString());
    }

    public void info(Object c, String logMsg) {
        this.getAdaptee(c).info(logMsg);
    }

    public void info(Object c, LogMessage msg) {
        this.getAdaptee(c).info(msg == null ? null : msg.toString());
    }

    public void warn(Object c, String logMsg) {
        this.getAdaptee(c).warn(logMsg);
    }

    public void warn(Object c, LogMessage msg) {
        this.getAdaptee(c).warn(msg == null ? null : msg.toString());
    }

    public String getLogFile() {
        return this.absFile;
    }
}

