/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import Ice.OperationNotExistException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.LockTimeout;
import omero.api.RenderingEnginePrx;
import omero.api.ResolutionDescription;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.ChannelData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.PixelsData;
import omero.log.LogMessage;
import omero.model.Family;
import omero.model.IObject;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Pixels;
import omero.model.QuantumDef;
import omero.model.RenderingModel;
import omero.model.ReverseIntensityContext;
import omero.model.enums.UnitsLength;
import omero.romio.CodomainMapContext;
import omero.romio.PlaneDef;
import omero.romio.ReverseIntensityMapContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.ConnectionExceptionHandler;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.data.ResolutionLevel;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPickerUtil;

class RenderingControlProxy
implements RenderingControl {
    private static final String ERROR = "An error occurred while trying to set the ";
    private static final String ERROR_RENDER = "An error occurred while rendering ";
    private static final Integer RED_INDEX = 0;
    private static final Integer GREEN_INDEX = 1;
    private static final Integer BLUE_INDEX = 2;
    private static final Integer NON_PRIMARY_INDEX = -1;
    private static final int MAX_RETRY = 2;
    private List families;
    private List models;
    private Pixels pixs;
    private RenderingEnginePrx servant;
    private int cacheID;
    private ChannelData[] metadata;
    private RndProxyDef rndDef;
    private int compression;
    private Registry context;
    private int cacheSize;
    private int imageSize;
    private Map<String, List<RndProxyDef>> settings;
    private int resolutionLevels;
    private int selectedResolutionLevel;
    private Dimension tileSize;
    private Boolean bigImage;
    private List<RenderingControl> slaves;
    private long lastAction;
    private boolean shutDown;
    private SecurityContext ctx;
    private int retry;
    private Collection<String> lookupTables;

    private Integer colourIndex(int channel) {
        if (this.isChannelBlue(channel)) {
            return BLUE_INDEX;
        }
        if (this.isChannelRed(channel)) {
            return RED_INDEX;
        }
        if (this.isChannelGreen(channel)) {
            return GREEN_INDEX;
        }
        return NON_PRIMARY_INDEX;
    }

    private boolean handleConnectionException(Throwable e) {
        ConnectionExceptionHandler handler = new ConnectionExceptionHandler();
        int index = handler.handleConnectionException(e);
        if (index < 0) {
            return true;
        }
        this.log("Handle Exception:" + index);
        this.context.getTaskBar().sessionExpired(index);
        return index == 0;
    }

    private void log(String error) {
        this.context.getLogger().debug((Object)this, error);
    }

    private void handleException(Throwable e, String message) throws RenderingServiceException, DSOutOfServiceException {
        if (this.shutDown) {
            return;
        }
        this.retry = 0;
        if (e instanceof OperationNotExistException) {
            RenderingServiceException ex = new RenderingServiceException(e);
            ex.setIndex(2);
            throw ex;
        }
        if (!this.handleConnectionException(e)) {
            throw new RenderingServiceException(message + "\n\n" + this.printErrorText(e), e);
        }
    }

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private Object getFromCache(PlaneDef pd) {
        if (pd.slice == 0 && this.cacheID >= 0) {
            int index = pd.z + this.getPixelsDimensionsZ() * pd.t;
            return this.context.getCacheService().getElement(this.cacheID, (Object)index);
        }
        return null;
    }

    private void cache(PlaneDef pd, Object object) {
        if (this.isBigImage()) {
            return;
        }
        if (pd.slice == 0 && this.cacheID >= 0) {
            int n = pd.z + this.getPixelsDimensionsZ() * pd.t;
        }
    }

    private void invalidateCache() {
        if (this.isBigImage()) {
            return;
        }
        if (this.cacheID >= 0) {
            this.context.getCacheService().clearCache(this.cacheID);
        }
    }

    private void eraseCache() {
        if (this.isBigImage()) {
            return;
        }
        this.invalidateCache();
        if (this.cacheID >= 0) {
            this.context.getCacheService().removeCache(this.cacheID);
        }
    }

    private void initializeCache(PlaneDef pDef) {
        if (this.isBigImage()) {
            return;
        }
        if (this.cacheID >= 0) {
            return;
        }
        if (pDef.slice == 0) {
            try {
                this.cacheID = this.context.getCacheService().createCache(2, this.cacheSize / this.imageSize);
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.print("Initialize cache");
                msg.print((Throwable)e);
                this.context.getLogger().error((Object)this, msg);
            }
        }
    }

    private void checkBitResolution(int v) {
        switch (v) {
            case 1: 
            case 3: 
            case 7: 
            case 15: 
            case 31: 
            case 63: 
            case 127: 
            case 255: {
                return;
            }
        }
        throw new IllegalArgumentException("Bit resolution not supported.");
    }

    private boolean isRightColor(int red, int green, int blue) {
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            if (!this.isActive(i) || !this.isRightChannelColor(i, red, green, blue)) continue;
            return true;
        }
        return false;
    }

    private boolean isRightChannelColor(int index, int red, int green, int blue) {
        int[] rgba = this.rndDef.getChannel(index).getRGBA();
        return rgba[0] == red && rgba[1] == green && rgba[2] == blue;
    }

    private Point getSize(PlaneDef pDef) {
        int sizeX2;
        int sizeX1;
        switch (pDef.slice) {
            case 2: {
                sizeX1 = this.pixs.getSizeX().getValue();
                sizeX2 = this.pixs.getSizeZ().getValue();
                break;
            }
            case 1: {
                sizeX1 = this.pixs.getSizeZ().getValue();
                sizeX2 = this.pixs.getSizeY().getValue();
                break;
            }
            default: {
                sizeX1 = this.pixs.getSizeX().getValue();
                sizeX2 = this.pixs.getSizeY().getValue();
                if (pDef.region == null) break;
                sizeX1 = pDef.region.width;
                sizeX2 = pDef.region.height;
            }
        }
        return new Point(sizeX1, sizeX2);
    }

    private void initialize() {
        try {
            this.rndDef.setTypeSigned(this.servant.isPixelsTypeSigned());
            this.rndDef.setDefaultZ(this.servant.getDefaultZ());
            this.rndDef.setDefaultT(this.servant.getDefaultT());
            QuantumDef qDef = this.servant.getQuantumDef();
            this.rndDef.setBitResolution(qDef.getBitResolution().getValue());
            this.rndDef.setColorModel(this.servant.getModel().getValue().getValue());
            this.rndDef.setCodomain(qDef.getCdStart().getValue(), qDef.getCdEnd().getValue());
            block2: for (int i = 0; i < this.metadata.length; ++i) {
                ChannelData channel = this.metadata[i];
                ChannelBindingsProxy cb = this.rndDef.getChannel(channel.getIndex());
                if (cb == null) {
                    cb = new ChannelBindingsProxy();
                    this.rndDef.setChannel(channel.getIndex(), cb);
                }
                cb.setActive(this.servant.isActive(i));
                cb.setInterval(this.servant.getChannelWindowStart(i), this.servant.getChannelWindowEnd(i));
                cb.setQuantization(this.servant.getChannelFamily(i).getValue().getValue(), this.servant.getChannelCurveCoefficient(i), this.servant.getChannelNoiseReduction(i));
                cb.setRGBA(this.servant.getRGBA(i));
                cb.setLowerBound(this.servant.getPixelsTypeLowerBound(i));
                cb.setUpperBound(this.servant.getPixelsTypeUpperBound(i));
                cb.setLookupTable(this.servant.getChannelLookupTable(i));
                cb.setReverseIntensity(false);
                List cdctx = this.servant.getCodomainMapContext(i);
                for (IObject cd : cdctx) {
                    if (!(cd instanceof ReverseIntensityContext)) continue;
                    cb.setReverseIntensity(true);
                    continue block2;
                }
            }
            this.tmpSolutionForNoiseReduction();
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Initialize proxy");
            msg.print((Throwable)e);
            this.context.getLogger().error((Object)this, msg);
        }
    }

    private void tmpSolutionForNoiseReduction() {
        try {
            for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                this.setQuantizationMap(i, this.getChannelFamily(i), this.getChannelCurveCoefficient(i), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setRGBA(int index, int[] rgba) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setRGBA(index, rgba[0], rgba[1], rgba[2], rgba[3]);
            this.rndDef.getChannel(index).setRGBA(rgba[0], rgba[1], rgba[2], rgba[3]);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the color for: " + index + ".");
        }
    }

    private BufferedImage renderCompressedBI(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        try {
            byte[] values = this.servant.renderCompressed(pDef);
            this.imageSize = values.length;
            return WriterImage.bytesToImage(values);
        }
        catch (Throwable e) {
            if (e instanceof LockTimeout && this.retry < 2) {
                ++this.retry;
                return this.renderCompressedBI(pDef);
            }
            this.handleException(e, "An error occurred while rendering the compressed image.");
            return null;
        }
    }

    private BufferedImage renderUncompressed(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        BufferedImage img = (BufferedImage)this.getFromCache(pDef);
        try {
            int[] buf = this.servant.renderAsPackedInt(pDef);
            Point p = this.getSize(pDef);
            this.imageSize = 3 * buf.length;
            this.initializeCache(pDef);
            img = Factory.createImage(buf, 32, p.x, p.y);
            this.cache(pDef, img);
        }
        catch (Throwable e) {
            if (e instanceof LockTimeout && this.retry < 2) {
                ++this.retry;
                return this.renderUncompressed(pDef);
            }
            this.handleException(e, "An error occurred while rendering the uncompressed plane.");
        }
        return img;
    }

    private BufferedImage renderProjectedCompressed(int startZ, int endZ, int stepping, int type) throws RenderingServiceException, DSOutOfServiceException {
        try {
            byte[] values = this.servant.renderProjectedCompressed(ProjectionParam.convertType(type), this.getDefaultT(), stepping, startZ, endZ);
            return WriterImage.bytesToImage(values);
        }
        catch (Throwable e) {
            if (e instanceof LockTimeout && this.retry < 2) {
                ++this.retry;
                return this.renderProjectedCompressed(startZ, endZ, stepping, type);
            }
            this.handleException(e, "An error occurred while rendering the projected selection.");
            return null;
        }
    }

    private BufferedImage renderProjectedUncompressed(int startZ, int endZ, int stepping, int type) throws RenderingServiceException, DSOutOfServiceException {
        BufferedImage img = null;
        try {
            int[] buf = this.servant.renderProjectedAsPackedInt(ProjectionParam.convertType(type), this.getDefaultT(), stepping, startZ, endZ);
            int sizeX1 = this.pixs.getSizeX().getValue();
            int sizeX2 = this.pixs.getSizeY().getValue();
            img = Factory.createImage(buf, 32, sizeX1, sizeX2);
        }
        catch (Throwable e) {
            if (e instanceof LockTimeout && this.retry < 2) {
                ++this.retry;
                return this.renderProjectedUncompressed(startZ, endZ, stepping, type);
            }
            this.handleException(e, "An error occurred while rendering the projected selection.");
        }
        return img;
    }

    private void isSessionAlive() throws RenderingServiceException {
        this.lastAction = System.currentTimeMillis();
        boolean b = false;
        try {
            b = this.context.getImageService().isAlive(this.ctx);
            if (!b) {
                this.context.getTaskBar().sessionExpired(3);
            }
        }
        catch (DSOutOfServiceException e) {
            RenderingServiceException ex = new RenderingServiceException((Throwable)e);
            ex.setIndex(1);
            throw ex;
        }
    }

    private long getUserID() {
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        return exp.getId();
    }

    RenderingControlProxy(Registry context, SecurityContext ctx, RenderingEnginePrx re, Pixels pixels, List<ChannelData> m, int compression, List<RndProxyDef> rndDefs, int cacheSize) {
        if (re == null) {
            throw new NullPointerException("No rendering engine.");
        }
        if (pixels == null) {
            throw new NullPointerException("No pixels set.");
        }
        if (context == null) {
            throw new NullPointerException("No registry.");
        }
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.ctx = ctx;
        this.slaves = new ArrayList<RenderingControl>();
        this.resolutionLevels = -1;
        this.selectedResolutionLevel = -1;
        this.lastAction = System.currentTimeMillis();
        this.shutDown = false;
        this.cacheSize = cacheSize;
        this.context = context;
        this.servant = re;
        this.pixs = pixels;
        this.families = null;
        this.models = null;
        try {
            this.families = this.servant.getAvailableFamilies();
            this.models = this.servant.getAvailableModels();
            this.cacheID = -1;
            this.imageSize = 1;
            this.compression = compression;
            this.metadata = new ChannelData[m.size()];
            Iterator<ChannelData> j = m.iterator();
            while (j.hasNext()) {
                ChannelData cm;
                this.metadata[cm.getIndex()] = cm = j.next();
            }
            if (rndDefs.size() < 1) {
                this.rndDef = context.getImageService().getSettings(ctx, this.servant.getRenderingDefId());
                this.initialize();
            } else {
                this.rndDef = rndDefs.get(0);
                block3: for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                    ChannelBindingsProxy cb = this.rndDef.getChannel(i);
                    cb.setLowerBound(this.servant.getPixelsTypeLowerBound(i));
                    cb.setUpperBound(this.servant.getPixelsTypeUpperBound(i));
                    cb.setLookupTable(this.servant.getChannelLookupTable(i));
                    cb.setReverseIntensity(false);
                    List cdctx = this.servant.getCodomainMapContext(i);
                    for (IObject cd : cdctx) {
                        if (!(cd instanceof ReverseIntensityContext)) continue;
                        cb.setReverseIntensity(true);
                        continue block3;
                    }
                }
            }
            this.tmpSolutionForNoiseReduction();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadRenderingSettings(long rndId) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.loadRenderingDef(rndId);
            this.servant.load();
        }
        catch (Throwable e) {
            this.handleException(e, "An error occurred while loading the settings.");
        }
    }

    boolean isProxyActive(long timeout) {
        long time = System.currentTimeMillis();
        return time - this.lastAction < timeout;
    }

    void setSlaves(List<RenderingControl> slaves) {
        if (slaves == null) {
            return;
        }
        this.slaves = slaves;
    }

    void resetRenderingEngine(RenderingEnginePrx servant, RndProxyDef rndDef) throws RenderingServiceException, DSOutOfServiceException {
        if (servant == null) {
            return;
        }
        try {
            this.servant.close();
        }
        catch (Exception e) {
            this.log("Error while closing the rendering engine " + e);
        }
        this.invalidateCache();
        this.servant = servant;
        this.shutDown = false;
        this.lastAction = System.currentTimeMillis();
        try {
            if (rndDef == null) {
                this.initialize();
            } else {
                this.rndDef = rndDef;
                block4: for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                    ChannelBindingsProxy cb = rndDef.getChannel(i);
                    cb.setLowerBound(servant.getPixelsTypeLowerBound(i));
                    cb.setUpperBound(servant.getPixelsTypeUpperBound(i));
                    cb.setLookupTable(servant.getChannelLookupTable(i));
                    cb.setReverseIntensity(false);
                    List cdctx = servant.getCodomainMapContext(i);
                    for (IObject cd : cdctx) {
                        if (!(cd instanceof ReverseIntensityContext)) continue;
                        cb.setReverseIntensity(true);
                        continue block4;
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering engine.");
        }
    }

    void setRenderingEngine(RenderingEnginePrx servant) throws RenderingServiceException, DSOutOfServiceException {
        if (servant == null) {
            return;
        }
        this.servant = servant;
        this.shutDown = false;
        this.lastAction = System.currentTimeMillis();
        if (this.rndDef == null) {
            return;
        }
        try {
            servant.setDefaultZ(this.rndDef.getDefaultZ());
            servant.setDefaultT(this.rndDef.getDefaultT());
            servant.setQuantumStrategy(this.rndDef.getBitResolution());
            Iterator k = this.models.iterator();
            String value = this.rndDef.getColorModel();
            while (k.hasNext()) {
                RenderingModel model = (RenderingModel)k.next();
                if (!model.getValue().getValue().equals(value)) continue;
                servant.setModel(model);
            }
            servant.setCodomainInterval(this.rndDef.getCdStart(), this.rndDef.getCdEnd());
            for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                ChannelBindingsProxy cb = this.rndDef.getChannel(i);
                servant.setActive(i, cb.isActive());
                servant.setChannelWindow(i, cb.getInputStart(), cb.getInputEnd());
                k = this.families.iterator();
                value = cb.getFamily();
                while (k.hasNext()) {
                    Family family = (Family)k.next();
                    if (!family.getValue().getValue().equals(value)) continue;
                    servant.setQuantizationMap(i, family, cb.getCurveCoefficient(), cb.isNoiseReduction());
                }
                int[] rgba = cb.getRGBA();
                servant.setRGBA(i, rgba[0], rgba[1], rgba[2], rgba[3]);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering engine.");
        }
    }

    boolean shutDown(boolean keepCache) {
        if (this.shutDown) {
            return this.shutDown;
        }
        try {
            if (!keepCache && this.cacheID >= 0) {
                this.context.getCacheService().removeCache(this.cacheID);
            }
            Iterator<RenderingControl> j = this.slaves.iterator();
            while (j.hasNext()) {
                ((RenderingControlProxy)j.next()).shutDown();
            }
        }
        catch (Exception e) {
            this.log(e.toString());
        }
        this.shutDown = true;
        return false;
    }

    void shutDown() {
        this.shutDown(false);
    }

    void setCacheSize(int size) {
        if (this.imageSize == 0) {
            this.imageSize = 1;
        }
        if (this.cacheID >= 0) {
            this.context.getCacheService().setCacheEntries(this.cacheID, size / this.imageSize);
        }
    }

    @Override
    public void setModel(String value) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            for (RenderingModel model : this.models) {
                if (!model.getValue().getValue().equals(value)) continue;
                this.servant.setModel(model);
                this.rndDef.setColorModel(value);
                this.invalidateCache();
            }
            Iterator<RenderingControl> j = this.slaves.iterator();
            while (j.hasNext()) {
                j.next().setModel(value);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the model.");
        }
    }

    @Override
    public String getModel() {
        return this.rndDef.getColorModel();
    }

    @Override
    public int getDefaultZ() {
        return this.rndDef.getDefaultZ();
    }

    @Override
    public int getDefaultT() {
        return this.rndDef.getDefaultT();
    }

    @Override
    public void setDefaultZ(int z) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            int maxZ = this.getPixelsDimensionsZ();
            if (z < 0) {
                z = 0;
            }
            if (z >= maxZ) {
                z = maxZ - 1;
            }
            this.servant.setDefaultZ(z);
            this.rndDef.setDefaultZ(z);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setDefaultZ(z);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the default Z.");
        }
    }

    @Override
    public void setDefaultT(int t) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            int maxT = this.getPixelsDimensionsT();
            if (t < 0) {
                t = 0;
            }
            if (t >= maxT) {
                t = maxT - 1;
            }
            this.servant.setDefaultT(t);
            this.rndDef.setDefaultT(t);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setDefaultT(t);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the default T.");
        }
    }

    @Override
    public void setQuantumStrategy(int bitResolution) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.checkBitResolution(bitResolution);
            this.servant.setQuantumStrategy(bitResolution);
            this.rndDef.setBitResolution(bitResolution);
            this.invalidateCache();
            Iterator<RenderingControl> j = this.slaves.iterator();
            while (j.hasNext()) {
                j.next().setQuantumStrategy(bitResolution);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the bit resolution.");
        }
    }

    @Override
    public void setCodomainInterval(int start, int end) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.setCodomainInterval(start, end);
            this.rndDef.setCodomain(start, end);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setCodomainInterval(start, end);
            }
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the codomain interval.");
        }
    }

    @Override
    public void setQuantizationMap(int index, String value, double coefficient, boolean noiseReduction) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            List list = this.servant.getAvailableFamilies();
            for (Family family : list) {
                if (!family.getValue().getValue().equals(value)) continue;
                this.servant.setQuantizationMap(index, family, coefficient, noiseReduction);
                this.rndDef.getChannel(index).setQuantization(value, coefficient, noiseReduction);
                this.invalidateCache();
            }
            Iterator<RenderingControl> j = this.slaves.iterator();
            while (j.hasNext()) {
                j.next().setQuantizationMap(index, value, coefficient, noiseReduction);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the quantization map.");
        }
    }

    @Override
    public String getChannelFamily(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return "";
        }
        return this.rndDef.getChannel(index).getFamily();
    }

    @Override
    public boolean getChannelNoiseReduction(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return false;
        }
        return channel.isNoiseReduction();
    }

    @Override
    public double getChannelCurveCoefficient(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return 1.0;
        }
        return channel.getCurveCoefficient();
    }

    @Override
    public void setChannelWindow(int index, double start, double end) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.setChannelWindow(index, start, end);
            this.rndDef.getChannel(index).setInterval(start, end);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setChannelWindow(index, start, end);
            }
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the input channel for: " + index + ".");
        }
    }

    @Override
    public double getChannelWindowStart(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return 0.0;
        }
        return channel.getInputStart();
    }

    @Override
    public double getChannelWindowEnd(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return 0.0;
        }
        return channel.getInputEnd();
    }

    @Override
    public void setRGBA(int index, Color c) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.setRGBA(index, c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.rndDef.getChannel(index).setRGBA(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.invalidateCache();
            Iterator<RenderingControl> j = this.slaves.iterator();
            while (j.hasNext()) {
                j.next().setRGBA(index, c);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the color for: " + index + ".");
        }
    }

    @Override
    public Color getRGBA(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return Color.black;
        }
        int[] rgba = channel.getRGBA();
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    @Override
    public void setActive(int index, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.setActive(index, active);
            this.rndDef.getChannel(index).setActive(active);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setActive(index, active);
            }
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the active channel for: " + index + ".");
        }
    }

    @Override
    public boolean isActive(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return false;
        }
        return channel.isActive();
    }

    @Override
    public void addCodomainMap(omero.model.CodomainMapContext mapCtx, int index) throws RenderingServiceException, DSOutOfServiceException {
        if (!(mapCtx instanceof ReverseIntensityContext)) {
            return;
        }
        this.isSessionAlive();
        try {
            ReverseIntensityMapContext c = new ReverseIntensityMapContext();
            this.servant.addCodomainMapToChannel((CodomainMapContext)c, index);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the cannot set the map context.");
        }
    }

    @Override
    public void removeCodomainMap(omero.model.CodomainMapContext mapCtx, int index) throws RenderingServiceException, DSOutOfServiceException {
        if (!(mapCtx instanceof ReverseIntensityContext)) {
            return;
        }
        this.isSessionAlive();
        try {
            ReverseIntensityMapContext c = new ReverseIntensityMapContext();
            this.servant.removeCodomainMapFromChannel((CodomainMapContext)c, index);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the cannot set the map context.");
        }
    }

    @Override
    public List<omero.model.CodomainMapContext> getCodomainMaps(int index) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        ArrayList<omero.model.CodomainMapContext> l = new ArrayList<omero.model.CodomainMapContext>();
        try {
            List ll = this.servant.getCodomainMapContext(index);
            Iterator i = ll.iterator();
            while (i.hasNext()) {
                l.add((omero.model.CodomainMapContext)i.next());
            }
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the cannot set the map context.");
        }
        return l;
    }

    @Override
    public RndProxyDef saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        Iterator<RenderingControl> i = this.slaves.iterator();
        try {
            long userID = this.getUserID();
            long ownerID = this.rndDef.getOwnerID();
            if (userID == ownerID) {
                this.servant.saveCurrentSettings();
                while (i.hasNext()) {
                    i.next().saveCurrentSettings();
                }
                return this.rndDef.copy();
            }
            long id = this.servant.saveAsNewSettings();
            this.rndDef = this.context.getImageService().getSettings(this.ctx, id);
            while (i.hasNext()) {
                ((RenderingControlProxy)i.next()).loadRenderingSettings(id);
            }
            return this.rndDef.copy();
        }
        catch (Throwable e) {
            this.handleException(e, "An error occurred while saving the current settings.");
            return null;
        }
    }

    @Override
    public void resetDefaults() throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.resetDefaultSettings(false);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().resetDefaults();
            }
            this.invalidateCache();
            this.initialize();
        }
        catch (Throwable e) {
            this.handleException(e, "An error occurred while trying to set the default settings.");
        }
    }

    @Override
    public Length getPixelsPhysicalSizeX() {
        if (this.pixs.getPhysicalSizeX() == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return this.pixs.getPhysicalSizeX();
    }

    @Override
    public Length getPixelsPhysicalSizeY() {
        if (this.pixs.getPhysicalSizeY() == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return this.pixs.getPhysicalSizeY();
    }

    @Override
    public Length getPixelsPhysicalSizeZ() {
        if (this.pixs.getPhysicalSizeZ() == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return this.pixs.getPhysicalSizeZ();
    }

    @Override
    public int getPixelsDimensionsX() {
        return this.pixs.getSizeX().getValue();
    }

    @Override
    public int getPixelsDimensionsY() {
        return this.pixs.getSizeY().getValue();
    }

    @Override
    public int getPixelsDimensionsZ() {
        return this.pixs.getSizeZ().getValue();
    }

    @Override
    public int getPixelsDimensionsT() {
        return this.pixs.getSizeT().getValue();
    }

    @Override
    public int getPixelsDimensionsC() {
        return this.pixs.getSizeC().getValue();
    }

    @Override
    public List getFamilies() {
        ArrayList<String> l = new ArrayList<String>(this.families.size());
        Iterator i = this.families.iterator();
        while (i.hasNext()) {
            l.add(((Family)i.next()).getValue().getValue());
        }
        return l;
    }

    @Override
    public ChannelData getChannelData(int index) {
        return this.metadata[index];
    }

    @Override
    public ChannelData[] getChannelData() {
        return this.metadata;
    }

    @Override
    public int getCodomainStart() {
        return this.rndDef.getCdStart();
    }

    @Override
    public int getCodomainEnd() {
        return this.rndDef.getCdEnd();
    }

    @Override
    public int getBitResolution() {
        return this.rndDef.getBitResolution();
    }

    @Override
    public boolean hasActiveChannelBlue() {
        return this.isRightColor(0, 0, 255);
    }

    @Override
    public boolean hasActiveChannelGreen() {
        return this.isRightColor(0, 255, 0);
    }

    @Override
    public boolean hasActiveChannelRed() {
        return this.isRightColor(255, 0, 0);
    }

    @Override
    public boolean isChannelRed(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        return this.isRightChannelColor(index, 255, 0, 0);
    }

    @Override
    public boolean isChannelBlue(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        return this.isRightChannelColor(index, 0, 0, 255);
    }

    @Override
    public boolean isChannelGreen(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        return this.isRightChannelColor(index, 0, 255, 0);
    }

    @Override
    public RndProxyDef getRndSettingsCopy() {
        return this.rndDef.copy();
    }

    @Override
    public void resetSettings(RndProxyDef rndDef) throws RenderingServiceException, DSOutOfServiceException {
        this.resetSettings(rndDef, false);
    }

    @Override
    public void resetSettings(RndProxyDef rndDef, boolean includeZT) throws RenderingServiceException, DSOutOfServiceException {
        if (rndDef == null) {
            throw new IllegalArgumentException("No rendering settings to set");
        }
        if (rndDef.getNumberOfChannels() != this.getPixelsDimensionsC()) {
            throw new IllegalArgumentException("Rendering settings not compatible.");
        }
        if (includeZT) {
            this.setDefaultT(rndDef.getDefaultT());
            this.setDefaultZ(rndDef.getDefaultZ());
        }
        this.setModel(rndDef.getColorModel());
        this.setCodomainInterval(rndDef.getCdStart(), rndDef.getCdEnd());
        this.setQuantumStrategy(rndDef.getBitResolution());
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            ChannelBindingsProxy c = rndDef.getChannel(i);
            if (c == null) continue;
            this.setRGBA(i, c.getRGBA());
            this.setLookupTable(i, c.getLookupTable());
            this.setReverseIntensity(i, c.getReverseIntensity());
            this.setChannelWindow(i, c.getInputStart(), c.getInputEnd());
            this.setQuantizationMap(i, c.getFamily(), c.getCurveCoefficient(), c.isNoiseReduction());
            this.setActive(i, c.isActive());
        }
        Iterator<RenderingControl> i = this.slaves.iterator();
        while (i.hasNext()) {
            i.next().resetSettings(rndDef);
        }
    }

    @Override
    public double getPixelsTypeLowerBound(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return 0.0;
        }
        return channel.getLowerBound();
    }

    @Override
    public double getPixelsTypeUpperBound(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return 0.0;
        }
        return channel.getUpperBound();
    }

    @Override
    public boolean isPixelsTypeSigned() {
        return this.rndDef.isTypeSigned();
    }

    @Override
    public boolean validatePixels(PixelsData pixels) {
        if (pixels == null) {
            return false;
        }
        long id = this.pixs.getDetails().getGroup().getId().getValue();
        if (id != pixels.getGroupId()) {
            return false;
        }
        if (this.getPixelsDimensionsC() != pixels.getSizeC()) {
            return false;
        }
        if (this.getPixelsDimensionsY() != pixels.getSizeY()) {
            return false;
        }
        if (this.getPixelsDimensionsX() != pixels.getSizeX()) {
            return false;
        }
        String s = pixels.getPixelType();
        String value = this.pixs.getPixelsType().getValue().getValue();
        return value.equals(s);
    }

    @Override
    public BufferedImage render(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        return this.render(pDef, this.compression);
    }

    @Override
    public BufferedImage render(PlaneDef pDef, int value) throws RenderingServiceException, DSOutOfServiceException {
        if (pDef == null) {
            throw new IllegalArgumentException("Plane def cannot be null.");
        }
        try {
            this.context.getImageService().isAlive(this.ctx);
            this.servant.ice_ping();
        }
        catch (Exception e) {
            return null;
        }
        this.retry = 0;
        if (value != this.compression) {
            this.setCompression(value);
        }
        BufferedImage img = this.isCompressed() ? this.renderCompressedBI(pDef) : this.renderUncompressed(pDef);
        if (value != this.compression) {
            this.setCompression(this.compression);
        }
        return img;
    }

    @Override
    public void setCompression(int compression) {
        try {
            this.isSessionAlive();
            float f = PixelsServicesFactory.getCompressionQuality(compression);
            this.rndDef.setCompression(f);
            this.servant.setCompressionLevel(f);
            this.compression = compression;
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setCompression(compression);
            }
            this.eraseCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isCompressed() {
        return this.compression != 0;
    }

    @Override
    public int getCompressionLevel() {
        return this.compression;
    }

    @Override
    public void setOriginalRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.resetDefaultSettings(false);
            if (this.getPixelsDimensionsC() > 1) {
                this.setModel("rgb");
            }
            List list = this.servant.getAvailableFamilies();
            for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                for (Family family : list) {
                    String value = family.getValue().getValue();
                    if (!value.equals(this.getChannelFamily(i))) continue;
                    this.servant.setQuantizationMap(i, family, this.getChannelCurveCoefficient(i), false);
                }
                ChannelData m = this.getChannelData(i);
                this.servant.setChannelWindow(i, m.getGlobalMin(), m.getGlobalMax());
            }
            this.invalidateCache();
            this.initialize();
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setOriginalRndSettings();
            }
        }
        catch (Throwable e) {
            this.handleException(e, "An error occurred while trying to set the default settings.");
        }
    }

    @Override
    public BufferedImage renderProjected(int startZ, int endZ, int stepping, int type, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        List<Integer> active = this.getActiveChannels();
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            this.setActive(i, false);
        }
        Iterator<Integer> j = channels.iterator();
        while (j.hasNext()) {
            this.setActive(j.next(), true);
        }
        this.retry = 0;
        BufferedImage img = this.isCompressed() ? this.renderProjectedCompressed(startZ, endZ, stepping, type) : this.renderProjectedUncompressed(startZ, endZ, stepping, type);
        j = active.iterator();
        while (j.hasNext()) {
            this.setActive(j.next(), true);
        }
        return img;
    }

    @Override
    public void copyRenderingSettings(RndProxyDef rndToCopy, List<Integer> indexes) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndDef == null) {
            throw new IllegalArgumentException("No rendering settings to set");
        }
        this.setModel(rndToCopy.getColorModel());
        this.setCodomainInterval(rndToCopy.getCdStart(), rndToCopy.getCdEnd());
        this.setQuantumStrategy(rndToCopy.getBitResolution());
        int defaultT = rndToCopy.getDefaultT();
        int maxT = this.getPixelsDimensionsT();
        if (defaultT >= 0 && defaultT < maxT) {
            this.setDefaultT(rndToCopy.getDefaultT());
        }
        Iterator<Integer> j = indexes.iterator();
        int k = 0;
        while (j.hasNext()) {
            Integer index = j.next();
            ChannelBindingsProxy c = rndToCopy.getChannel(index);
            if (c != null) {
                this.setRGBA(k, c.getRGBA());
                this.setChannelWindow(k, c.getInputStart(), c.getInputEnd());
                this.setQuantizationMap(k, c.getFamily(), c.getCurveCoefficient(), c.isNoiseReduction());
                this.setActive(k, c.isActive());
            }
            ++k;
        }
    }

    @Override
    public List<Integer> getActiveChannels() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            if (!this.isActive(i)) continue;
            active.add(i);
        }
        return active;
    }

    @Override
    public boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        return this.isSameSettings(def, checkPlane, false);
    }

    @Override
    public boolean isSameSettings(RndProxyDef def, boolean checkPlane, boolean checkInactiveChannels) {
        int i;
        ChannelBindingsProxy channel;
        if (def == null) {
            return false;
        }
        if (checkPlane) {
            if (def.getDefaultZ() != this.getDefaultZ()) {
                return false;
            }
            if (def.getDefaultT() != this.getDefaultT()) {
                return false;
            }
        }
        if (def.getBitResolution() != this.getBitResolution()) {
            return false;
        }
        if (def.getCdEnd() != this.getCodomainEnd()) {
            return false;
        }
        if (def.getCdStart() != this.getCodomainStart()) {
            return false;
        }
        if (!def.getColorModel().equals(this.getModel())) {
            return false;
        }
        if (def.getNumberOfChannels() != this.getPixelsDimensionsC()) {
            return false;
        }
        HashMap<Integer, ChannelBindingsProxy> oldChannels = new HashMap<Integer, ChannelBindingsProxy>();
        for (int i2 = 0; i2 < this.getPixelsDimensionsC(); ++i2) {
            channel = def.getChannel(i2);
            if (!channel.isActive()) continue;
            oldChannels.put(i2, channel);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (i = 0; i < this.getPixelsDimensionsC(); ++i) {
            if (!this.isActive(i)) continue;
            indexes.add(i);
        }
        if (indexes.size() != oldChannels.size()) {
            return false;
        }
        if (checkInactiveChannels) {
            for (i = 0; i < this.getPixelsDimensionsC(); ++i) {
                channel = def.getChannel(i);
                oldChannels.put(i, channel);
            }
            for (i = 0; i < this.getPixelsDimensionsC(); ++i) {
                indexes.add(i);
            }
        }
        Iterator j = oldChannels.keySet().iterator();
        while (j.hasNext()) {
            Color color;
            int i3 = (Integer)j.next();
            if (!indexes.contains(i3)) {
                return false;
            }
            channel = (ChannelBindingsProxy)oldChannels.get(i3);
            if (channel.getInputStart() != this.getChannelWindowStart(i3)) {
                return false;
            }
            if (channel.getInputEnd() != this.getChannelWindowEnd(i3)) {
                return false;
            }
            if (channel.getCurveCoefficient() != this.getChannelCurveCoefficient(i3)) {
                return false;
            }
            if (!channel.getFamily().equals(this.getChannelFamily(i3))) {
                return false;
            }
            if (channel.isNoiseReduction() != this.getChannelNoiseReduction(i3)) {
                return false;
            }
            if (!ColourPickerUtil.sameLookuptable(channel.getLookupTable(), this.getLookupTable(i3))) {
                return false;
            }
            int[] rgba = channel.getRGBA();
            if (rgba[0] != (color = this.getRGBA(i3)).getRed()) {
                return false;
            }
            if (rgba[1] != color.getGreen()) {
                return false;
            }
            if (rgba[2] != color.getBlue()) {
                return false;
            }
            if (rgba[3] != color.getAlpha()) {
                return false;
            }
            if (channel.getReverseIntensity() == this.getReverseIntensity(i3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getPixelsID() {
        return this.pixs.getId().getValue();
    }

    @Override
    public boolean isMappedImageRGB(List channels) {
        if (channels == null) {
            channels = this.getActiveChannels();
        }
        if (channels.size() == 0) {
            return false;
        }
        HashSet<Integer> rgb = new HashSet<Integer>();
        for (int index : channels) {
            int cIndex = this.colourIndex(index);
            if (cIndex != NON_PRIMARY_INDEX) {
                if (rgb.contains(cIndex)) {
                    return false;
                }
                rgb.add(cIndex);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public void setOverlays(long tableID, Map<Long, Integer> overlays) throws RenderingServiceException, DSOutOfServiceException {
        if (tableID < 0L) {
            return;
        }
        try {
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the overlays.");
        }
    }

    @Override
    public int getResolutionLevels() {
        try {
            if (this.resolutionLevels < 0) {
                this.resolutionLevels = this.servant.getResolutionLevels();
            }
        }
        catch (Exception e) {
            this.resolutionLevels = 1;
        }
        return this.resolutionLevels;
    }

    @Override
    public int getSelectedResolutionLevel() {
        try {
            if (this.selectedResolutionLevel < 0) {
                this.selectedResolutionLevel = this.servant.getResolutionLevel();
            }
        }
        catch (Exception e) {
            this.selectedResolutionLevel = 0;
        }
        return this.selectedResolutionLevel;
    }

    @Override
    public void setSelectedResolutionLevel(int level) throws RenderingServiceException, DSOutOfServiceException {
        this.tileSize = null;
        if (level > this.getResolutionLevels()) {
            level = this.getResolutionLevels();
        }
        this.isSessionAlive();
        try {
            this.servant.setResolutionLevel(level);
            this.selectedResolutionLevel = level;
            Iterator<RenderingControl> j = this.slaves.iterator();
            while (j.hasNext()) {
                j.next().setSelectedResolutionLevel(level);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the  resolution level: " + level);
        }
    }

    @Override
    public Dimension getTileSize() throws RenderingServiceException, DSOutOfServiceException {
        try {
            if (this.tileSize == null) {
                int[] values = this.servant.getTileSize();
                this.tileSize = new Dimension(values[0], values[1]);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while retrieving the tile size.");
        }
        return this.tileSize;
    }

    @Override
    public boolean isBigImage() {
        if (this.bigImage != null) {
            return this.bigImage;
        }
        try {
            this.bigImage = this.servant.requiresPixelsPyramid();
            return this.bigImage;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public List<RenderingControl> getSlaves() {
        return this.slaves;
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public List<ResolutionLevel> getResolutionDescriptions() throws RenderingServiceException, DSOutOfServiceException {
        ArrayList<ResolutionLevel> levels = new ArrayList<ResolutionLevel>();
        int sizeX = this.getPixelsDimensionsX();
        int sizeY = this.getPixelsDimensionsY();
        if (!this.isBigImage()) {
            Dimension d = new Dimension(sizeX, sizeY);
            levels.add(new ResolutionLevel(0, d, d));
            return levels;
        }
        try {
            int n;
            ResolutionDescription[] v = this.servant.getResolutionDescriptions();
            for (int i = n = v.length - 1; i >= 0; --i) {
                ResolutionDescription r = v[i];
                this.setSelectedResolutionLevel(n - i);
                Dimension d = new Dimension(r.sizeX, r.sizeY);
                ResolutionLevel level = new ResolutionLevel(n - i, this.getTileSize(), d);
                level.setRatio((double)r.sizeX / (double)sizeX, (double)r.sizeY / (double)sizeY);
                levels.add(level);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while retrieving the resolutions.");
        }
        return levels;
    }

    @Override
    public void setAvailableLookupTables(Collection<String> lookupTables) {
        this.lookupTables = lookupTables;
    }

    @Override
    public Collection<String> getAvailableLookupTables() {
        if (this.lookupTables == null) {
            return Collections.EMPTY_LIST;
        }
        return this.lookupTables;
    }

    @Override
    public String getLookupTable(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return null;
        }
        return channel.getLookupTable();
    }

    @Override
    public boolean getReverseIntensity(int index) {
        ChannelBindingsProxy channel = this.rndDef.getChannel(index);
        if (channel == null) {
            return false;
        }
        return channel.getReverseIntensity();
    }

    @Override
    public void setReverseIntensity(int index, boolean revInt) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            boolean currentRevInt = false;
            List cdctx = this.servant.getCodomainMapContext(index);
            for (IObject cd : cdctx) {
                if (!(cd instanceof ReverseIntensityContext)) continue;
                currentRevInt = true;
                break;
            }
            if (currentRevInt == revInt) {
                return;
            }
            if (revInt) {
                this.servant.addCodomainMapToChannel((CodomainMapContext)new ReverseIntensityMapContext(), index);
            } else {
                this.servant.removeCodomainMapFromChannel((CodomainMapContext)new ReverseIntensityMapContext(), index);
            }
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setReverseIntensity(index, revInt);
            }
            this.invalidateCache();
            ChannelBindingsProxy channel = this.rndDef.getChannel(index);
            if (channel != null) {
                channel.setReverseIntensity(revInt);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the  setting reverse intensity for channel: " + index + ".");
        }
    }

    @Override
    public void setLookupTable(int index, String lut) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            this.servant.setChannelLookupTable(index, lut);
            Iterator<RenderingControl> i = this.slaves.iterator();
            while (i.hasNext()) {
                i.next().setLookupTable(index, lut);
            }
            this.invalidateCache();
            ChannelBindingsProxy channel = this.rndDef.getChannel(index);
            if (channel != null) {
                channel.setLookupTable(lut);
            }
        }
        catch (Exception e) {
            this.handleException(e, "An error occurred while trying to set the  lookup up table for channel: " + index + ".");
        }
    }
}

