/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.rnd.NavigationHistory;
import org.openmicroscopy.shoola.util.math.geom2D.Line;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

public class XYCache {
    private final int image_size;
    private int cache_size;
    private int max_entries;
    private Map<PlanePoint, Object> cache;
    private NavigationHistory navigHistory;

    private void ensureCapacity(final PlanePoint p) {
        PlanePoint[] orderedCache = this.cache.keySet().toArray(new PlanePoint[0]);
        Arrays.sort(orderedCache, new Comparator(){

            public int compare(Object o1, Object o2) {
                PlanePoint c1 = (PlanePoint)o1;
                PlanePoint c2 = (PlanePoint)o2;
                return -Double.compare(c1.distance(p), c2.distance(p));
            }
        });
        Line curDir = this.navigHistory.currentDirection();
        PlanePoint candidate = orderedCache[0];
        if (curDir != null) {
            int i;
            ArrayList<PlanePoint> negativeHalf = new ArrayList<PlanePoint>(orderedCache.length);
            for (i = 0; i < orderedCache.length; ++i) {
                if (!curDir.lies(orderedCache[i])) {
                    candidate = orderedCache[i];
                    break;
                }
                if (!curDir.lies(orderedCache[i], false)) continue;
                negativeHalf.add(orderedCache[i]);
            }
            if (i == orderedCache.length && !negativeHalf.isEmpty()) {
                candidate = (PlanePoint)negativeHalf.get(0);
            }
        }
        this.cache.remove(candidate);
    }

    XYCache(int cacheSize, int imageSize, NavigationHistory nh) {
        if (cacheSize < 0) {
            throw new IllegalArgumentException("Cache size must be positive: " + cacheSize + ".");
        }
        if (imageSize <= 0) {
            throw new IllegalArgumentException("Image size must be positive: " + imageSize + ".");
        }
        if (nh == null) {
            throw new NullPointerException("No navigation history.");
        }
        this.cache_size = cacheSize;
        this.image_size = imageSize;
        this.max_entries = this.cache_size / this.image_size;
        this.cache = new HashMap<PlanePoint, Object>(this.max_entries);
        this.navigHistory = nh;
    }

    void add(PlaneDef pd, Object object) {
        if (this.max_entries == 0) {
            return;
        }
        if (pd == null) {
            throw new NullPointerException("No plane def.");
        }
        if (pd.slice != 0) {
            throw new IllegalArgumentException("Can only accept XY planes: " + pd.slice + ".");
        }
        if (object == null) {
            throw new NullPointerException("No image.");
        }
        PlanePoint key = new PlanePoint(pd.z, pd.t);
        if (this.max_entries <= this.cache.size()) {
            this.ensureCapacity(key);
        }
        this.cache.put(key, object);
    }

    Object extract(PlaneDef pd) {
        if (pd == null) {
            throw new NullPointerException("No plane def.");
        }
        if (pd.slice != 0) {
            throw new IllegalArgumentException("Can only accept XY planes: " + pd.slice + ".");
        }
        PlanePoint key = new PlanePoint(pd.z, pd.t);
        return this.cache.get(key);
    }

    boolean contains(PlaneDef pd) {
        if (pd == null) {
            return false;
        }
        PlanePoint key = new PlanePoint(pd.z, pd.t);
        return this.cache.get(key) != null;
    }

    void clear() {
        int oldSize = this.cache.size();
        this.cache = new HashMap<PlanePoint, Object>(oldSize);
    }

    void resetCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Cache size must be positive: " + size + ".");
        }
        this.cache_size = size;
        this.max_entries = this.cache_size / this.image_size;
        this.cache = new HashMap<PlanePoint, Object>(this.max_entries);
    }

    Map getCache() {
        return this.cache;
    }

    NavigationHistory getNavigHistory() {
        return this.navigHistory;
    }
}

