/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Image;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.env.config.IconFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.ui.IconManager;

public abstract class AbstractIconManager {
    private static final Icon OME_ICON = AbstractIconManager.createIcon("graphx/omero16.png");
    private IconFactory factory;
    private String[] iconFiles;
    private Registry registry;

    protected static Icon createIcon(String path) {
        URL location = IconManager.class.getResource(path);
        ImageIcon icon = null;
        if (location != null) {
            icon = new ImageIcon(location);
        }
        return icon;
    }

    public static Image getOMEImageIcon() {
        return ((ImageIcon)OME_ICON).getImage();
    }

    public static Icon getOMEIcon() {
        return OME_ICON;
    }

    protected AbstractIconManager(Registry registry, String lookupName, String[] iconFiles) {
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        if (iconFiles == null || iconFiles.length == 0) {
            throw new IllegalArgumentException("No icon files.");
        }
        Object f = registry.lookup(lookupName);
        if (f == null || !(f instanceof IconFactory)) {
            throw new IllegalArgumentException("Wrong lookup name: " + lookupName + ".");
        }
        this.factory = (IconFactory)f;
        this.iconFiles = iconFiles;
        this.registry = registry;
    }

    public Icon getIcon(String name) {
        Icon icon = this.factory.getIcon(name);
        if (icon == null) {
            StringBuffer buf = new StringBuffer("Failed to retrieve icon: ");
            buf.append("<classpath>");
            buf.append(this.factory.getResourcePathname(name));
            buf.append(".");
            this.registry.getLogger().error((Object)this, buf.toString());
        }
        return icon;
    }

    public ImageIcon getImageIcon(String name) {
        ImageIcon icon = this.factory.getImageIcon(name);
        if (icon == null) {
            StringBuffer buf = new StringBuffer("Failed to retrieve icon: ");
            buf.append("<classpath>");
            buf.append(this.factory.getResourcePathname(name));
            buf.append(".");
            this.registry.getLogger().error((Object)this, buf.toString());
        }
        return icon;
    }

    public Icon getIcon(int id) {
        if (id < 0 || this.iconFiles.length <= id) {
            this.registry.getLogger().error((Object)this, "Icon id out of range: " + id + ".");
            return null;
        }
        return this.getIcon(this.iconFiles[id]);
    }

    public ImageIcon getImageIcon(int id) {
        if (id < 0 || this.iconFiles.length <= id) {
            this.registry.getLogger().error((Object)this, "Icon id out of range: " + id + ".");
            return null;
        }
        return this.getImageIcon(this.iconFiles[id]);
    }

    public URL getIconURL(int id) {
        if (id < 0 || this.iconFiles.length <= id) {
            this.registry.getLogger().error((Object)this, "Icon id out of range: " + id + ".");
            return null;
        }
        return this.getIconURL(this.iconFiles[id]);
    }

    public URL getIconURL(String name) {
        URL url = this.factory.getImageURL(name);
        if (url == null) {
            StringBuffer buf = new StringBuffer("Failed to retrieve url: ");
            buf.append("<classpath>");
            buf.append(this.factory.getResourcePathname(name));
            buf.append(".");
            this.registry.getLogger().error((Object)this, buf.toString());
        }
        return url;
    }
}

