/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.TransferableObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DataObjectTransfer
extends UserNotifierLoader {
    private CallHandle handle;
    private List<ProcessCallback> callBacks;
    private TransferableObject object;
    private int number;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to transfer the objects", message, ex);
    }

    public DataObjectTransfer(UserNotifier viewer, Registry registry, TransferableObject object, ActivityComponent activity) {
        super(viewer, registry, null, activity);
        if (object == null) {
            throw new IllegalArgumentException("No Objects to transfer.");
        }
        this.callBacks = new ArrayList<ProcessCallback>();
        this.object = object;
    }

    @Override
    public void load() {
        this.handle = this.dmView.changeGroup(this.object, this);
    }

    @Override
    public void cancel() {
        try {
            for (ProcessCallback callback : this.callBacks) {
                if (callback == null) continue;
                callback.cancel();
            }
            this.activity.onActivityCancelled();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("", null);
                }
            } else {
                ProcessCallback callBack = (ProcessCallback)o;
                callBack.setAdapter(this);
                this.callBacks.add(callBack);
                ++this.number;
                if (this.number == this.object.getSource().size()) {
                    this.activity.onCallBackSet();
                }
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof Boolean) {
            boolean b = (Boolean)result;
            if (b) {
                this.activity.endActivity("Transfer complete");
            } else {
                this.onException("No result returned.", null);
            }
        } else {
            this.activity.endActivity(result);
        }
    }
}

