/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ExportLoader
extends UserNotifierLoader {
    public static final int EXPORT_AS_OME_TIFF = 0;
    public static final int EXPORT_AS_OME_XML = 1;
    private CallHandle handle;
    private ImageData image;
    private File file;
    private int index;
    private Target target;
    private boolean cancelled;

    @Override
    protected void onException(String message, Throwable ex) {
        switch (this.index) {
            case 0: {
                this.activity.notifyError("Unable to export as OME-TIFF", message, ex);
                break;
            }
            case 1: {
                this.activity.notifyError("Unable to export as OME-XML", message, ex);
            }
        }
    }

    public ExportLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, ImageData image, File file, int index, Target target, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (image == null) {
            throw new IllegalArgumentException("Image not valid.");
        }
        this.target = target;
        this.image = image;
        this.file = file;
        this.index = index;
    }

    @Override
    public void load() {
        this.handle = this.ivView.exportImageAsOMETiff(this.ctx, this.image.getId(), this.file, this.target, this);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.handle != null) {
            this.handle.cancel();
        }
    }

    @Override
    public void handleResult(Object result) {
        if (this.cancelled) {
            this.file.delete();
        } else if (result == null) {
            this.onException("No result returned.", null);
        } else {
            this.activity.endActivity(result);
        }
    }
}

