/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;

class FileUploader
extends UserNotifierLoader {
    private CallHandle handle;
    private MessengerDetails details;
    private MessengerDialog src;
    private Map<ImportErrorObject, FileTableNode> nodes;
    private int total;

    FileUploader(UserNotifier viewer, Registry reg, SecurityContext ctx, MessengerDialog src, MessengerDetails details) {
        super(viewer, reg, ctx, null);
        if (details == null) {
            throw new IllegalArgumentException("No files to upload.");
        }
        this.details = details;
        this.src = src;
        this.nodes = new HashMap<ImportErrorObject, FileTableNode>();
        List l = (List)details.getObjectToSubmit();
        if (l != null) {
            for (FileTableNode node : l) {
                ImportErrorObject object = node.getFailure();
                this.nodes.put(object, node);
            }
        }
    }

    @Override
    public void load() {
        this.total = this.nodes.size();
        if (!this.details.isExceptionOnly()) {
            this.src.setSubmitStatus("0 out of " + this.total, false);
        }
        this.handle = this.mhView.submitFiles(this.ctx, this.details, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        int v;
        ImportErrorObject f = (ImportErrorObject)fe.getPartialResult();
        if (f != null) {
            FileTableNode node = this.nodes.get(f);
            if (node != null) {
                node.setStatus(false);
            }
            this.nodes.remove(f);
        }
        if ((v = this.total - this.nodes.size()) != this.total) {
            if (!this.details.isExceptionOnly()) {
                this.src.setSubmitStatus(v + " out of " + this.total, false);
            }
        } else if (!this.details.isExceptionOnly()) {
            this.src.setSubmitStatus("Done", true);
        }
        if (this.nodes.size() == 0) {
            String s = "";
            String verb = "has";
            if (this.total > 1) {
                s = "s";
                verb = "have";
            }
            StringBuffer buf = new StringBuffer();
            String term = this.details.isExceptionOnly() ? "exception" : "file";
            buf.append("The ");
            buf.append(term);
            buf.append(s);
            buf.append(" ");
            buf.append(verb);
            buf.append(" been successfully submitted.");
            this.viewer.notifyInfo("Submit", buf.toString());
            if (this.src != null) {
                this.src.setVisible(false);
                this.src.dispose();
            }
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "File Upload Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("File Upload failure", s, exc);
    }
}

