/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OpenObjectLoader
extends UserNotifierLoader {
    private CallHandle handle;
    private DataObject object;
    private String folderPath;
    private boolean originalImage;

    public OpenObjectLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, DataObject object, String folderPath, boolean originalImage, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        if (!(object instanceof ImageData) && !(object instanceof FileAnnotationData)) {
            throw new IllegalArgumentException("Object not valid.");
        }
        this.object = object;
        this.folderPath = folderPath;
        this.originalImage = originalImage;
    }

    public OpenObjectLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, DataObject object, String folderPath, ActivityComponent activity) {
        this(viewer, registry, ctx, object, folderPath, false, activity);
    }

    @Override
    public void load() {
        String path = this.folderPath + File.separator;
        if (this.object instanceof ImageData) {
            ImageData image = (ImageData)this.object;
            if (this.originalImage) {
                ArrayList<DataObject> objects = new ArrayList<DataObject>();
                objects.add((DataObject)image);
                File f = new File(this.folderPath);
                this.handle = this.mhView.loadArchivedImage(this.ctx, objects, f, false, false, false, this);
            } else {
                String name = image.getName();
                name = name + image.getName();
                name = name + "_" + image.getId();
                path = path + UIUtilities.replaceNonWordCharacters(name) + "." + "ome.tiff";
                File f = new File(path);
                f.deleteOnExit();
                this.handle = this.ivView.exportImageAsOMETiff(this.ctx, image.getId(), f, null, this);
            }
        } else {
            this.originalImage = false;
            FileAnnotationData fa = (FileAnnotationData)this.object;
            path = path + UIUtilities.replaceNonWordCharacters(fa.getFileName());
            File f = new File(path);
            f.deleteOnExit();
            this.handle = this.mhView.loadFile(this.ctx, f, fa.getId(), 1, this);
        }
    }

    @Override
    public void handleNullResult() {
        if (this.activity != null && this.object instanceof FileAnnotationData) {
            this.activity.notifyError("File no longer exists", "The file you wish to open no longer exists.", null);
        }
    }

    @Override
    protected void onException(String message, Throwable ex) {
        super.onException(message, ex);
        this.activity.notifyError("Error- Could not load object", ex.getMessage(), ex);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (this.originalImage) {
            Map r = (Map)result;
            List files = (List)r.get(true);
            if (files.size() > 0) {
                Iterator i = files.iterator();
                while (i.hasNext()) {
                    ((File)i.next()).deleteOnExit();
                }
                this.activity.endActivity(files.get(0));
            } else {
                this.onException("No result returned.", null);
            }
        } else {
            this.activity.endActivity(result);
        }
    }
}

