/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class SaveResultsLoader
extends UserNotifierLoader {
    private CallHandle handle;
    private ResultsObject results;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to save the imageJ results", message, ex);
    }

    public SaveResultsLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, ResultsObject results, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (results == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.results = results;
    }

    @Override
    public void load() {
        this.handle = this.ivView.saveResults(this.ctx, this.results, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        int percDone = fe.getPercentDone();
        if (percDone == 100) {
            this.activity.endActivity(Boolean.TRUE);
        }
    }
}

