/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ScriptRunner
extends UserNotifierLoader {
    private CallHandle handle;
    private ScriptObject script;
    private ProcessCallback callBack;
    private boolean cancelled;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to run the script", message, ex);
    }

    public ScriptRunner(UserNotifier viewer, Registry registry, SecurityContext ctx, ScriptObject script, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (script == null) {
            throw new IllegalArgumentException("No script to run.");
        }
        this.script = script;
    }

    @Override
    public void load() {
        this.handle = this.ivView.runScript(this.ctx, this.script, this);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (Boolean.valueOf(false).equals(o)) {
                this.onException("Unable to start the script.", null);
            } else if (o instanceof ProcessCallback) {
                this.callBack = (ProcessCallback)o;
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
                if (this.cancelled) {
                    this.cancel();
                }
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (Boolean.valueOf(false).equals(result)) {
            this.onException("Unable to start the script.", null);
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

