/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.SplashScreenFuture;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;

class SplashScreenManager
implements PropertyChangeListener,
WindowFocusListener,
WindowStateListener {
    private ScreenLogin view;
    private boolean isOpen;
    private SplashScreenFuture userCredentials;
    private int totalTasks;
    private int doneTasks;
    private Container container;
    private SplashScreen component;
    private LoginCredentials lc;

    private void login(LoginCredentials lc) {
        if (this.doneTasks != this.totalTasks) {
            this.lc = lc;
            return;
        }
        try {
            UserCredentials uc = new UserCredentials(lc.getUserName(), lc.getPassword(), lc.getHostName(), lc.getSpeedLevel());
            uc.setPort(lc.getPort());
            uc.setEncrypted(lc.isEncrypted());
            uc.setGroup(lc.getGroup());
            this.userCredentials.set(uc);
            this.lc = null;
        }
        catch (Exception e) {
            UserNotifier un = UIFactory.makeUserNotifier(this.container);
            un.notifyError("Login Incomplete", e.getMessage());
            this.view.setControlsEnabled(true);
            this.updateView();
        }
    }

    private void setWindowState(JFrame f, int state) {
        if (f == null) {
            return;
        }
        f.removeWindowStateListener(this);
        f.setState(state);
        f.addWindowStateListener(this);
    }

    private void updateView() {
        if (this.view != null) {
            this.view.setAlwaysOnTop(true);
            this.view.requestFocusOnField();
        }
    }

    private void initializedView(Icon splashscreen) {
        if (this.view != null) {
            return;
        }
        Image img = IconManager.getOMEImageIcon();
        Object version = this.container.getRegistry().lookup("Version");
        String v = "";
        if (version != null && version instanceof String) {
            v = (String)version;
        }
        OMEROInfo info = (OMEROInfo)this.container.getRegistry().lookup("/services/OMERODS");
        int p = -1;
        String port = "" + info.getPortSSL();
        String host = info.getHostName();
        boolean configurable = info.isHostNameConfigurable();
        boolean serverAvailable = this.connectToServer();
        this.view = new ScreenLogin("Open Microscopy Environment", splashscreen, img, v, port, host, serverAvailable);
        this.view.setEncryptionConfiguration(info.isEncrypted(), info.isEncryptedConfigurable());
        this.view.setHostNameConfiguration(host, configurable, p);
        this.view.showConnectionSpeed(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = this.view.getPreferredSize();
        this.view.setBounds((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2, d.width, d.height);
        this.view.addPropertyChangeListener(this);
        this.view.addWindowStateListener(this);
        this.view.addWindowFocusListener(this);
    }

    private boolean connectToServer() {
        Integer v = (Integer)this.container.getRegistry().lookup("/application/entryPoint");
        if (v != null) {
            return v == 0 || v == 2;
        }
        return false;
    }

    SplashScreenManager(SplashScreen component, Container c) {
        Integer v;
        this.container = c;
        this.component = component;
        Registry reg = c.getRegistry();
        String n = (String)reg.lookup("SplashScreenLogo");
        String f = this.container.getConfigFileRelative(null);
        Icon splashscreen = Factory.createIcon(n, f);
        if (splashscreen == null && (v = (Integer)this.container.getRegistry().lookup("/application/entryPoint")) != null) {
            switch (v) {
                case 2: {
                    splashscreen = IconManager.getImporterSplashScreen();
                    break;
                }
                default: {
                    splashscreen = IconManager.getSplashScreen();
                }
            }
        }
        this.isOpen = false;
        this.doneTasks = 0;
        this.initializedView(splashscreen);
    }

    void open() {
        this.view.setVisible(true);
        this.view.setStatusVisible(true, false);
        this.isOpen = true;
        UIUtilities.applyGnome3Workaround(this.view);
        this.container.getRegistry().bind("/services/Login/splashscreen", true);
    }

    void close() {
        if (this.view == null) {
            return;
        }
        Boolean b = (Boolean)this.container.getRegistry().lookup("SessionKey");
        if (b != null && b.booleanValue()) {
            this.view.setUserName("");
        }
        this.view.close();
        this.view = null;
        this.isOpen = false;
        this.container.getRegistry().bind("/services/Login/splashscreen", false);
    }

    void setTotalTasks(int value) {
        if (!this.isOpen) {
            return;
        }
        this.totalTasks = value;
        ++this.totalTasks;
        this.view.initProgressBar(value);
    }

    void updateProgress(String task) {
        if (!this.isOpen) {
            return;
        }
        int n = this.doneTasks++;
        this.view.setStatus(task, n);
        if (this.doneTasks == this.totalTasks) {
            this.view.setStatusVisible(false, this.lc == null);
            if (this.lc == null) {
                this.view.requestFocusOnField();
            }
            if (!this.connectToServer()) {
                this.view.setVisible(false);
            }
        }
    }

    void collectUserCredentials(SplashScreenFuture future, boolean init) {
        this.userCredentials = future;
        if (this.lc != null) {
            this.login(this.lc);
            return;
        }
        if (this.view != null) {
            this.view.setControlsEnabled(true);
        }
        if (!init) {
            if (this.view != null) {
                this.view.cleanField(1);
            }
            this.updateView();
        }
    }

    void collectUserCredentialsInit(SplashScreenFuture future) {
        this.userCredentials = future;
        if (this.view != null) {
            this.view.setControlsEnabled(true);
        }
    }

    void onLoginFailure() {
        if (this.view != null) {
            this.view.onLoginFailure();
        }
        this.updateView();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("login".equals(name)) {
            LoginCredentials lc;
            this.lc = lc = (LoginCredentials)evt.getNewValue();
            if (this.userCredentials != null && lc != null) {
                this.login(lc);
            }
        } else if ("quit".equals(name)) {
            this.container.exit();
            this.component.close();
        } else if ("toFront".equals(name) || "moveFront".equals(name)) {
            this.updateView();
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        Object src = e.getSource();
        int state = e.getNewState();
        if (src instanceof ScreenLogin) {
            this.setWindowState(this.view, state);
        }
        if (this.view != null) {
            this.view.setAlwaysOnTop(state == 0);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (e.getOppositeWindow() == null && this.view != null) {
            this.view.setAlwaysOnTop(false);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }
}

