/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.proxy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.openmicroscopy.shoola.svc.proxy.ProxyUtil;
import org.openmicroscopy.shoola.svc.proxy.Request;
import org.openmicroscopy.shoola.svc.transport.TransportException;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

class MessengerRequest
extends Request {
    private static final String EMAIL = "email";
    private static final String COMMENT = "comment";
    private static final String ERROR = "error";
    private static final String EXTRA = "extra";
    private static final String INVOKER = "type";
    private static final String MAIN_FILE_NAME = "selected_file";
    private static final String MAIN_FILE_PATH = "absolute_path";
    private static final String ADDITIONAL_FILE_NAME = "additional_files";
    private static final String ADDITIONAL_FILE_PATH = "additional_files_path";
    private static final String ADDITIONAL_FILE_SIZE = "additional_files_size";
    private String error;
    private String email;
    private String comment;
    private String extra;
    private String invoker;
    private String applicationNumber;
    private String applicationVersion;
    private File mainFile;
    private List<File> associatedFiles;

    private void checkForNull() {
        if (this.email == null) {
            this.email = "";
        }
        if (this.comment == null) {
            this.comment = "";
        }
        if (this.extra == null) {
            this.extra = "";
        }
        if (this.invoker == null) {
            this.invoker = "";
        }
    }

    MessengerRequest(String email, String comment, String extra, String error, String applicationNumber, String invoker, String applicationVersion, File mainFile, List<File> associatedFiles) {
        this.error = error;
        this.email = email;
        this.comment = comment;
        this.extra = extra;
        this.invoker = invoker;
        this.applicationNumber = applicationNumber;
        this.applicationVersion = applicationVersion;
        this.mainFile = mainFile;
        this.associatedFiles = associatedFiles;
        this.checkForNull();
    }

    @Override
    public HttpUriRequest marshal(String path) throws TransportException {
        if (CommonsLangUtils.isBlank(path)) {
            throw new TransportException("No path specified.");
        }
        HttpPost request = new HttpPost(path);
        request.addHeader("Accept", "text/plain");
        request.addHeader("Content-type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> p = new ArrayList<BasicNameValuePair>();
        p.add(new BasicNameValuePair(COMMENT, this.comment));
        p.add(new BasicNameValuePair(EMAIL, this.email));
        p.add(new BasicNameValuePair(ERROR, this.error));
        p.add(new BasicNameValuePair(EXTRA, this.extra));
        p.add(new BasicNameValuePair(INVOKER, this.invoker));
        p.add(new BasicNameValuePair("app_name", this.applicationNumber));
        p.add(new BasicNameValuePair("app_name", this.applicationNumber));
        p.add(new BasicNameValuePair("app_version", this.applicationVersion));
        Map<String, String> info = ProxyUtil.collectInfo();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            p.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        if (this.mainFile != null) {
            p.add(new BasicNameValuePair(MAIN_FILE_NAME, this.mainFile.getName()));
            p.add(new BasicNameValuePair(MAIN_FILE_PATH, this.mainFile.getAbsolutePath()));
        }
        if (CollectionUtils.isNotEmpty(this.associatedFiles)) {
            for (File f : this.associatedFiles) {
                p.add(new BasicNameValuePair(ADDITIONAL_FILE_NAME, f.getName()));
                if (f.getParent() != null) {
                    p.add(new BasicNameValuePair(ADDITIONAL_FILE_PATH, f.getParent()));
                }
                p.add(new BasicNameValuePair(ADDITIONAL_FILE_SIZE, Long.valueOf(f.length()).toString()));
            }
        }
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(p));
        }
        catch (Exception e) {
            throw new TransportException("Cannot prepare parameters", e);
        }
        return request;
    }
}

