/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class MatlabFilter
extends CustomizedFileFilter {
    public static final String MATLAB = "m";
    public static final String[] extensions = new String[1];
    private static final String description;

    @Override
    public String getMIMEType() {
        return "application/octet-stream";
    }

    @Override
    public String getExtension() {
        return MATLAB;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        MatlabFilter.extensions[0] = MATLAB;
        StringBuffer s = new StringBuffer();
        s.append("Matlab (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

