/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.openmicroscopy.shoola.util.image.io.Encoder;
import org.openmicroscopy.shoola.util.image.io.EncoderException;

public class WriterImage {
    public static final int JPEG = 0;
    public static final int PNG = 1;
    public static final int GIF = 2;

    public static void saveImage(File f, BufferedImage img, String format) throws EncoderException {
        if (f == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        if (img == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        ImageInputStream ios = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            ios = ImageIO.createImageOutputStream(f);
            if (ios == null) {
                throw new IOException("Can't access file");
            }
            writer.setOutput(ios);
            writer.write(img);
        }
        catch (IOException e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void saveImage(Encoder encoder) throws EncoderException {
        if (encoder == null) {
            throw new IllegalArgumentException("No encoder specified.");
        }
        try {
            encoder.write();
            encoder.getOutput().close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static byte[] imageToByteStream(BufferedImage image) throws EncoderException {
        return WriterImage.imageToByteStream(image, 0);
    }

    public static byte[] imageToByteStream(BufferedImage image, int type) throws EncoderException {
        if (image == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        ByteArrayOutputStream stream = null;
        try {
            stream = new ByteArrayOutputStream();
            switch (type) {
                case 1: {
                    ImageIO.write((RenderedImage)image, "png", stream);
                    break;
                }
                case 2: {
                    ImageIO.write((RenderedImage)image, "gif", stream);
                    break;
                }
                default: {
                    ImageIO.write((RenderedImage)image, "jpeg", stream);
                }
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static BufferedImage bytesToImage(byte[] values) throws EncoderException {
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(values);
            BufferedImage image = ImageIO.read(stream);
            if (image != null) {
                image.setAccelerationPriority(1.0f);
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new EncoderException("Cannot create buffered image", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] bytesToBytes(byte[] values) throws EncoderException {
        byte[] byArray;
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(values);
            BufferedImage image = ImageIO.read(stream);
            if (image == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            image.setAccelerationPriority(1.0f);
            int w = image.getWidth();
            int h = image.getHeight();
            WritableRaster raster = Raster.createInterleavedRaster(0, w, h, 4, null);
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
            BufferedImage img = new BufferedImage(cm, raster, false, null);
            Graphics2D g = img.createGraphics();
            g.drawImage(image, null, null);
            DataBufferByte buf = (DataBufferByte)raster.getDataBuffer();
            byArray = buf.getData();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot create buffered image", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    public static int[] bytesToDataBuffer(byte[] values) throws EncoderException {
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        try {
            BufferedImage img = WriterImage.bytesToImage(values);
            if (img == null) {
                return null;
            }
            DataBufferInt buf = (DataBufferInt)img.getData().getDataBuffer();
            return buf.getData();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot decode the image.", e);
        }
    }
}

