/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.LineDecoration;

public enum Cap {
    NONE("None", null),
    ARROW("Arrow", ArrowTip.class);

    private String value = null;
    private Class<? extends LineDecoration> type = null;

    private Cap(String value, Class<? extends LineDecoration> type) {
        this.value = value;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public Class<? extends LineDecoration> getType() {
        return this.type;
    }

    public <T extends LineDecoration> T newLineDecorationInstance() {
        if (this.type == null) {
            return null;
        }
        LineDecoration obj = null;
        try {
            obj = this.type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate " + this.type, e);
        }
        return (T)obj;
    }

    public String toString() {
        return this.value;
    }

    public static Cap findByValue(String value) {
        for (Cap c : Cap.values()) {
            if (!c.getValue().equalsIgnoreCase(value)) continue;
            return c;
        }
        return null;
    }

    public static Cap findByType(Class<? extends LineDecoration> type) {
        for (Cap c : Cap.values()) {
            if (c.getType() == null || !c.getType().equals(type)) continue;
            return c;
        }
        return null;
    }

    public static <T extends LineDecoration> Cap findByPrototype(T type) {
        if (type != null) {
            for (Cap c : Cap.values()) {
                if (c.getType() == null || !c.getType().isAssignableFrom(type.getClass())) continue;
                return c;
            }
        }
        return null;
    }
}

