/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ome.model.units.BigResult;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.roi.model.util.UnitPoint;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.PointTextFigure;

public class MeasurePointFigure
extends PointTextFigure
implements ROIFigure {
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;
    private boolean interactable;

    public MeasurePointFigure(String text, double x, double y, double width, double height, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        super(text, x, y, width, height);
        this.setAttributeEnabled(MeasurementAttributes.TEXT_COLOR, true);
        this.setAttribute(MeasurementAttributes.FONT_FACE, DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        this.setAttribute(MeasurementAttributes.SCALE_PROPORTIONALLY, Boolean.FALSE);
        this.shape = null;
        this.roi = null;
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.interactable = true;
    }

    public MeasurePointFigure(double x, double y, double width, double height) {
        this("", x, y, width, height, false, true, true, true, true);
    }

    public MeasurePointFigure(boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this("", 0.0, 0.0, 0.0, 0.0, readOnly, clientObject, editable, deletable, annotatable);
    }

    public MeasurePointFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Length getMeasurementX() {
        return this.transformX(this.getX());
    }

    public UnitPoint getMeasurementCentre() {
        Point2D p = this.getCentre();
        return new UnitPoint(this.transformX(p.getX()), this.transformY(p.getY()));
    }

    public Length getMeasurementY() {
        try {
            return new LengthI(this.transformY(this.getY()), this.getUnit());
        }
        catch (BigResult result) {
            return new LengthI(Double.POSITIVE_INFINITY, this.getUnit());
        }
    }

    public Length getMeasurementWidth() {
        return this.transformX(this.getWidth());
    }

    public Length getMeasurementHeight() {
        return this.transformY(this.getHeight());
    }

    public double getX() {
        return this.ellipse.getX();
    }

    public double getY() {
        return this.ellipse.getY();
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue() || MeasurementAttributes.SHOWID.get(this).booleanValue()) {
            String pointCentre = "(" + UIUtilities.formatValue(this.getMeasurementCentre().x) + "," + UIUtilities.formatValue(this.getMeasurementCentre().y) + ")";
            Double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            Font font = (Font)this.getAttribute(MeasurementAttributes.FONT_FACE);
            if (font != null) {
                g.setFont(font.deriveFont(sz.floatValue()));
            } else {
                g.setFont(new Font("sans-serif", 0, sz.intValue()));
            }
            this.bounds = g.getFontMetrics().getStringBounds(pointCentre, g);
            this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
            if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue()) {
                g.setColor(MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get(this));
                g.drawString(pointCentre, (int)this.bounds.getX(), (int)this.bounds.getY());
            }
            if (MeasurementAttributes.SHOWID.get(this).booleanValue()) {
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
                bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - bounds.getWidth() / 2.0, this.getBounds().getCenterY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight());
                g.setColor(this.getTextColor());
                g.drawString(this.getROI().getID() + "", (int)bounds.getX(), (int)bounds.getY());
            }
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (!this.readOnly && this.interactable) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly && this.interactable) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Point2D getCentre() {
        return new Point2D.Double(Math.round(this.ellipse.getCenterX()), Math.round(this.ellipse.getCenterY()));
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        UnitPoint c = this.getMeasurementCentre();
        AnnotationKeys.CENTREX.set(this.shape, c.x);
        AnnotationKeys.CENTREY.set(this.shape, c.y);
    }

    @Override
    public String getType() {
        return "Point";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        return Arrays.asList(new Point((int)this.ellipse.getCenterX(), (int)this.ellipse.getCenterY()));
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasurePointFigure clone() {
        MeasurePointFigure that = (MeasurePointFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setInteractable(true);
        return that;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public boolean canAnnotate() {
        return this.annotatable;
    }

    @Override
    public boolean canDelete() {
        return this.deletable;
    }

    @Override
    public boolean canEdit() {
        return this.editable;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public boolean canInteract() {
        return this.interactable;
    }

    private Length transformX(double x) {
        return this.transformX((int)x);
    }

    private Length transformY(double y) {
        return this.transformY((int)y);
    }

    private Length transformX(int x) {
        if (this.units.getPixelSizeX() != null) {
            return new LengthI((double)x * this.units.getPixelSizeX().getValue(), this.units.getPixelSizeX().getUnit());
        }
        return new LengthI((double)x, UnitsLength.PIXEL);
    }

    private Length transformY(int y) {
        if (this.units.getPixelSizeY() != null) {
            return new LengthI((double)y * this.units.getPixelSizeY().getValue(), this.units.getPixelSizeY().getUnit());
        }
        return new LengthI((double)y, UnitsLength.PIXEL);
    }

    private UnitsLength getUnit() {
        if (this.units.getPixelSizeX() != null) {
            return this.units.getPixelSizeX().getUnit();
        }
        return UnitsLength.PIXEL;
    }
}

